/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.io.EOFException;
import java.io.IOException;
import java.net.SocketAddress;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.concurrent.TimeUnit;
import org.xbill.DNS.NioClient;

final class TCPClient {
    private long endTime;
    private SelectionKey key;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    TCPClient(long timeout) throws IOException {
        this.endTime = System.nanoTime() + TimeUnit.MILLISECONDS.toNanos(timeout);
        boolean done = false;
        Selector selector = null;
        SocketChannel channel = SocketChannel.open();
        try {
            selector = Selector.open();
            channel.configureBlocking(false);
            this.key = channel.register(selector, 1);
            done = true;
        }
        finally {
            if (!done && selector != null) {
                selector.close();
            }
            if (!done) {
                channel.close();
            }
        }
    }

    void bind(SocketAddress addr) throws IOException {
        SocketChannel channel = (SocketChannel)this.key.channel();
        channel.socket().bind(addr);
    }

    void connect(SocketAddress addr) throws IOException {
        SocketChannel channel = (SocketChannel)this.key.channel();
        if (channel.connect(addr)) {
            return;
        }
        this.key.interestOps(8);
        try {
            while (!channel.finishConnect()) {
                if (this.key.isConnectable()) continue;
                TCPClient.blockUntil(this.key, this.endTime);
            }
        }
        finally {
            if (this.key.isValid()) {
                this.key.interestOps(0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void send(byte[] data) throws IOException {
        SocketChannel channel = (SocketChannel)this.key.channel();
        NioClient.verboseLog("TCP write", channel.socket().getLocalSocketAddress(), channel.socket().getRemoteSocketAddress(), data);
        byte[] lengthArray = new byte[]{(byte)(data.length >>> 8), (byte)(data.length & 0xFF)};
        ByteBuffer[] buffers = new ByteBuffer[]{ByteBuffer.wrap(lengthArray), ByteBuffer.wrap(data)};
        int nsent = 0;
        this.key.interestOps(4);
        try {
            while (nsent < data.length + 2) {
                if (this.key.isWritable()) {
                    long n = channel.write(buffers);
                    if (n < 0L) {
                        throw new EOFException();
                    }
                    if ((nsent += (int)n) >= data.length + 2 || this.endTime - System.nanoTime() >= 0L) continue;
                    throw new SocketTimeoutException();
                }
                TCPClient.blockUntil(this.key, this.endTime);
            }
        }
        finally {
            if (this.key.isValid()) {
                this.key.interestOps(0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] _recv(int length) throws IOException {
        SocketChannel channel = (SocketChannel)this.key.channel();
        int nrecvd = 0;
        byte[] data = new byte[length];
        ByteBuffer buffer = ByteBuffer.wrap(data);
        this.key.interestOps(1);
        try {
            while (nrecvd < length) {
                if (this.key.isReadable()) {
                    long n = channel.read(buffer);
                    if (n < 0L) {
                        throw new EOFException();
                    }
                    if ((nrecvd += (int)n) >= length || System.currentTimeMillis() <= this.endTime) continue;
                    throw new SocketTimeoutException();
                }
                TCPClient.blockUntil(this.key, this.endTime);
            }
        }
        finally {
            if (this.key.isValid()) {
                this.key.interestOps(0);
            }
        }
        return data;
    }

    private static void blockUntil(SelectionKey key, long endTime) throws IOException {
        long timeout = TimeUnit.NANOSECONDS.toMillis(endTime - System.nanoTime());
        int nkeys = 0;
        if (timeout > 0L) {
            nkeys = key.selector().select(timeout);
        } else if (timeout == 0L) {
            nkeys = key.selector().selectNow();
        }
        if (nkeys == 0) {
            throw new SocketTimeoutException();
        }
    }

    void cleanup() throws IOException {
        this.key.selector().close();
        this.key.channel().close();
    }

    byte[] recv() throws IOException {
        byte[] buf = this._recv(2);
        int length = ((buf[0] & 0xFF) << 8) + (buf[1] & 0xFF);
        byte[] data = this._recv(length);
        SocketChannel channel = (SocketChannel)this.key.channel();
        NioClient.verboseLog("TCP read", channel.socket().getLocalSocketAddress(), channel.socket().getRemoteSocketAddress(), data);
        return data;
    }
}

