/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.dto;

import org.apache.james.core.quota.QuotaCountLimit;
import org.apache.james.core.quota.QuotaCountUsage;
import org.apache.james.core.quota.QuotaSizeLimit;
import org.apache.james.core.quota.QuotaSizeUsage;
import org.apache.james.mailbox.model.Quota;
import org.apache.james.webadmin.dto.OccupationRatioDTO;

public class OccupationDTO {
    private final long size;
    private final long count;
    private final OccupationRatioDTO ratio;

    public static OccupationDTO from(Quota<QuotaSizeLimit, QuotaSizeUsage> sizeQuota, Quota<QuotaCountLimit, QuotaCountUsage> countQuota) {
        return new OccupationDTO(((QuotaSizeUsage)sizeQuota.getUsed()).asLong(), ((QuotaCountUsage)countQuota.getUsed()).asLong(), OccupationRatioDTO.from(sizeQuota, countQuota));
    }

    private OccupationDTO(long size, long count, OccupationRatioDTO ratio) {
        this.size = size;
        this.count = count;
        this.ratio = ratio;
    }

    public long getSize() {
        return this.size;
    }

    public long getCount() {
        return this.count;
    }

    public OccupationRatioDTO getRatio() {
        return this.ratio;
    }
}

