/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.events;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Objects;
import java.util.UUID;

public class EventBusId {
    private final UUID id;

    public static EventBusId of(UUID uuid) {
        return new EventBusId(uuid);
    }

    public static EventBusId random() {
        return new EventBusId(UUID.randomUUID());
    }

    public static EventBusId of(String serialized) {
        return new EventBusId(UUID.fromString(serialized));
    }

    private EventBusId(UUID id) {
        Preconditions.checkNotNull((Object)id);
        this.id = id;
    }

    public final boolean equals(Object o) {
        if (o instanceof EventBusId) {
            EventBusId eventBusId = (EventBusId)o;
            return Objects.equals(this.id, eventBusId.id);
        }
        return false;
    }

    public String asString() {
        return this.id.toString();
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.id).toString();
    }
}

