/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.util.json;

import com.unboundid.ldap.sdk.FailoverServerSet;
import com.unboundid.ldap.sdk.FastestConnectServerSet;
import com.unboundid.ldap.sdk.FewestConnectionsServerSet;
import com.unboundid.ldap.sdk.LDAPConnectionOptions;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.RoundRobinServerSet;
import com.unboundid.ldap.sdk.ServerSet;
import com.unboundid.ldap.sdk.SingleServerSet;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.ObjectPair;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.json.ConnectionOptions;
import com.unboundid.util.json.JSONArray;
import com.unboundid.util.json.JSONMessages;
import com.unboundid.util.json.JSONObject;
import com.unboundid.util.json.JSONValue;
import com.unboundid.util.json.LDAPConnectionDetailsJSONSpecification;
import com.unboundid.util.json.SecurityOptions;
import java.util.ArrayList;
import java.util.List;
import javax.net.SocketFactory;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
final class ServerDetails {
    @NotNull
    private static final String FIELD_ADDRESS = "address";
    @NotNull
    private static final String FIELD_FAILOVER_ORDER = "failover-order";
    @NotNull
    private static final String FIELD_FAILOVER_SET = "failover-set";
    @NotNull
    private static final String FIELD_FASTEST_CONNECT_SET = "fastest-connect-set";
    @NotNull
    private static final String FIELD_FEWEST_CONNECTIONS_SET = "fewest-connections-set";
    @NotNull
    private static final String FIELD_MAX_FAILOVER_CONN_AGE_MILLIS = "maximum-failover-connection-age-millis";
    @NotNull
    private static final String FIELD_PORT = "port";
    @NotNull
    private static final String FIELD_ROUND_ROBIN_SET = "round-robin-set";
    @NotNull
    private static final String FIELD_SERVERS = "servers";
    @NotNull
    private static final String FIELD_SINGLE_SERVER = "single-server";
    @NotNull
    private final ServerSet serverSet;

    ServerDetails(@NotNull JSONObject connectionDetailsObject, @NotNull SecurityOptions securityOptions, @NotNull ConnectionOptions connectionOptions) throws LDAPException {
        JSONObject o = LDAPConnectionDetailsJSONSpecification.getObject(connectionDetailsObject, "server-details");
        this.serverSet = ServerDetails.createServerSet(o, "server-details", securityOptions, connectionOptions);
    }

    @NotNull
    private static ServerSet createServerSet(@NotNull JSONObject o, @NotNull String fieldName, @NotNull SecurityOptions securityOptions, @NotNull ConnectionOptions connectionOptions) throws LDAPException {
        LDAPConnectionDetailsJSONSpecification.validateAllowedFields(o, fieldName, FIELD_FAILOVER_SET, FIELD_FASTEST_CONNECT_SET, FIELD_FEWEST_CONNECTIONS_SET, FIELD_ROUND_ROBIN_SET, FIELD_SINGLE_SERVER);
        SocketFactory socketFactory = securityOptions.getSocketFactory();
        LDAPConnectionOptions ldapConnectionOptions = connectionOptions.createConnectionOptions(securityOptions);
        if (o.getFields().size() != 1) {
            throw new LDAPException(ResultCode.PARAM_ERROR, JSONMessages.ERR_SERVER_DETAILS_INVALID_FIELD_SET.get(fieldName));
        }
        JSONObject failoverSetObject = LDAPConnectionDetailsJSONSpecification.getObject(o, FIELD_FAILOVER_SET);
        if (failoverSetObject != null) {
            LDAPConnectionDetailsJSONSpecification.validateAllowedFields(failoverSetObject, FIELD_FAILOVER_SET, FIELD_FAILOVER_ORDER, FIELD_MAX_FAILOVER_CONN_AGE_MILLIS);
            Long maxFailoverConnectionAgeMillis = LDAPConnectionDetailsJSONSpecification.getLong(failoverSetObject, FIELD_MAX_FAILOVER_CONN_AGE_MILLIS, null, 0L, null);
            JSONValue orderValue = failoverSetObject.getField(FIELD_FAILOVER_ORDER);
            if (orderValue == null) {
                throw new LDAPException(ResultCode.PARAM_ERROR, JSONMessages.ERR_SERVER_DETAILS_MISSING_FIELD.get(FIELD_FAILOVER_SET, FIELD_FAILOVER_ORDER));
            }
            if (!(orderValue instanceof JSONArray)) {
                throw new LDAPException(ResultCode.PARAM_ERROR, JSONMessages.ERR_SERVER_DETAILS_FIELD_NOT_ARRAY.get(FIELD_FAILOVER_SET, FIELD_FAILOVER_ORDER));
            }
            JSONArray orderArray = (JSONArray)orderValue;
            List<JSONValue> orderArrayValues = orderArray.getValues();
            if (orderArrayValues.isEmpty()) {
                throw new LDAPException(ResultCode.PARAM_ERROR, JSONMessages.ERR_SERVER_DETAILS_EMPTY_ARRAY.get(FIELD_FAILOVER_SET, FIELD_FAILOVER_ORDER));
            }
            ArrayList<ServerSet> failoverSets = new ArrayList<ServerSet>(orderArrayValues.size());
            for (JSONValue v : orderArrayValues) {
                if (!(v instanceof JSONObject)) {
                    throw new LDAPException(ResultCode.PARAM_ERROR, JSONMessages.ERR_SERVER_DETAILS_SERVERS_VALUE_NOT_OBJECT.get(FIELD_FAILOVER_ORDER, FIELD_FAILOVER_SET));
                }
                failoverSets.add(ServerDetails.createServerSet((JSONObject)v, FIELD_FAILOVER_ORDER, securityOptions, connectionOptions));
            }
            FailoverServerSet failoverSet = new FailoverServerSet(failoverSets);
            failoverSet.setMaxFailoverConnectionAgeMillis(maxFailoverConnectionAgeMillis);
            return failoverSet;
        }
        JSONObject fastestConnectSetObject = LDAPConnectionDetailsJSONSpecification.getObject(o, FIELD_FASTEST_CONNECT_SET);
        if (fastestConnectSetObject != null) {
            ObjectPair<String[], int[]> servers = ServerDetails.parseServers(fastestConnectSetObject, FIELD_SERVERS);
            return new FastestConnectServerSet(servers.getFirst(), servers.getSecond(), socketFactory, ldapConnectionOptions);
        }
        JSONObject fewestConnectionsSetObject = LDAPConnectionDetailsJSONSpecification.getObject(o, FIELD_FEWEST_CONNECTIONS_SET);
        if (fewestConnectionsSetObject != null) {
            ObjectPair<String[], int[]> servers = ServerDetails.parseServers(fewestConnectionsSetObject, FIELD_SERVERS);
            return new FewestConnectionsServerSet(servers.getFirst(), servers.getSecond(), socketFactory, ldapConnectionOptions);
        }
        JSONObject roundRobinSetObject = LDAPConnectionDetailsJSONSpecification.getObject(o, FIELD_ROUND_ROBIN_SET);
        if (roundRobinSetObject != null) {
            ObjectPair<String[], int[]> servers = ServerDetails.parseServers(roundRobinSetObject, FIELD_SERVERS);
            return new RoundRobinServerSet(servers.getFirst(), servers.getSecond(), socketFactory, ldapConnectionOptions);
        }
        JSONObject singleServerObject = LDAPConnectionDetailsJSONSpecification.getObject(o, FIELD_SINGLE_SERVER);
        ObjectPair<String, Integer> addressAndPort = ServerDetails.parseServer(singleServerObject, FIELD_SINGLE_SERVER);
        return new SingleServerSet(addressAndPort.getFirst(), addressAndPort.getSecond(), socketFactory, ldapConnectionOptions);
    }

    @NotNull
    private static ObjectPair<String[], int[]> parseServers(@NotNull JSONObject o, @NotNull String f) throws LDAPException {
        LDAPConnectionDetailsJSONSpecification.validateAllowedFields(o, f, FIELD_SERVERS);
        JSONValue serversValue = o.getField(FIELD_SERVERS);
        if (serversValue == null) {
            throw new LDAPException(ResultCode.PARAM_ERROR, JSONMessages.ERR_SERVER_DETAILS_MISSING_FIELD.get(f, FIELD_SERVERS));
        }
        if (!(serversValue instanceof JSONArray)) {
            throw new LDAPException(ResultCode.PARAM_ERROR, JSONMessages.ERR_SERVER_DETAILS_FIELD_NOT_ARRAY.get(f, FIELD_SERVERS));
        }
        List<JSONValue> serverArrayValues = ((JSONArray)serversValue).getValues();
        if (serverArrayValues.isEmpty()) {
            throw new LDAPException(ResultCode.PARAM_ERROR, JSONMessages.ERR_SERVER_DETAILS_EMPTY_ARRAY.get(f, FIELD_SERVERS));
        }
        int i = 0;
        String[] addresses = new String[serverArrayValues.size()];
        int[] ports = new int[addresses.length];
        for (JSONValue v : serverArrayValues) {
            if (!(v instanceof JSONObject)) {
                throw new LDAPException(ResultCode.PARAM_ERROR, JSONMessages.ERR_SERVER_DETAILS_SERVERS_VALUE_NOT_OBJECT.get(FIELD_SERVERS, f));
            }
            ObjectPair<String, Integer> p = ServerDetails.parseServer((JSONObject)v, FIELD_SERVERS);
            addresses[i] = p.getFirst();
            ports[i] = p.getSecond();
            ++i;
        }
        return new ObjectPair<String[], int[]>(addresses, ports);
    }

    @NotNull
    private static ObjectPair<String, Integer> parseServer(@NotNull JSONObject o, @NotNull String f) throws LDAPException {
        LDAPConnectionDetailsJSONSpecification.validateAllowedFields(o, f, FIELD_ADDRESS, FIELD_PORT);
        String address = LDAPConnectionDetailsJSONSpecification.getString(o, FIELD_ADDRESS, null);
        if (address == null) {
            throw new LDAPException(ResultCode.PARAM_ERROR, JSONMessages.ERR_SERVER_DETAILS_MISSING_FIELD.get(f, FIELD_ADDRESS));
        }
        Integer port = LDAPConnectionDetailsJSONSpecification.getInt(o, FIELD_PORT, null, 1, 65535);
        if (port == null) {
            throw new LDAPException(ResultCode.PARAM_ERROR, JSONMessages.ERR_SERVER_DETAILS_MISSING_FIELD.get(f, FIELD_PORT));
        }
        return new ObjectPair<String, Integer>(address, port);
    }

    @NotNull
    ServerSet getServerSet() {
        return this.serverSet;
    }
}

