/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.backup.zip;

import java.util.Date;
import java.util.Optional;
import org.apache.commons.compress.archivers.zip.ZipShort;
import org.apache.james.mailbox.backup.zip.LongExtraField;
import org.apache.james.mailbox.backup.zip.WithZipHeader;

public class InternalDateExtraField
extends LongExtraField
implements WithZipHeader {
    public static final ZipShort ID_AO = new ZipShort(WithZipHeader.toLittleEndian('a', 'o'));

    public InternalDateExtraField() {
    }

    public InternalDateExtraField(Optional<Date> date) {
        super(date.map(Date::getTime));
    }

    public InternalDateExtraField(Date date) {
        this(Optional.of(date));
    }

    public InternalDateExtraField(long timestamp) {
        this(Optional.of(new Date(timestamp)));
    }

    public ZipShort getHeaderId() {
        return ID_AO;
    }

    public Optional<Date> getDateValue() {
        return this.getValue().map(Date::new);
    }
}

