/*
 * Decompiled with CFR 0.152.
 */
package com.jakewharton.byteunits;

import com.jakewharton.byteunits.ByteUnit;
import com.jakewharton.byteunits.UnitUtil;
import java.text.DecimalFormat;
import java.text.NumberFormat;

public enum BitUnit implements ByteUnit
{
    BITS{

        @Override
        public long convert(long sourceCount, BitUnit sourceUnit) {
            return sourceUnit.toBits(sourceCount);
        }

        @Override
        public long toBytes(long count) {
            return count / 8L;
        }

        @Override
        public long toBits(long count) {
            return count;
        }

        @Override
        public long toKilobits(long count) {
            return count / 1000L;
        }

        @Override
        public long toMegabits(long count) {
            return count / 1000000L;
        }

        @Override
        public long toGigabits(long count) {
            return count / 1000000000L;
        }

        @Override
        public long toTerabits(long count) {
            return count / 1000000000000L;
        }

        @Override
        public long toPetabits(long count) {
            return count / 1000000000000000L;
        }
    }
    ,
    KILOBITS{

        @Override
        public long convert(long sourceCount, BitUnit sourceUnit) {
            return sourceUnit.toKilobits(sourceCount);
        }

        @Override
        public long toBytes(long count) {
            return count * 125L;
        }

        @Override
        public long toBits(long count) {
            return UnitUtil.multiply(count, 1000L, 9223372036854775L);
        }

        @Override
        public long toKilobits(long count) {
            return count;
        }

        @Override
        public long toMegabits(long count) {
            return count / 1000L;
        }

        @Override
        public long toGigabits(long count) {
            return count / 1000000L;
        }

        @Override
        public long toTerabits(long count) {
            return count / 1000000000L;
        }

        @Override
        public long toPetabits(long count) {
            return count / 1000000000000L;
        }
    }
    ,
    MEGABITS{

        @Override
        public long convert(long sourceCount, BitUnit sourceUnit) {
            return sourceUnit.toMegabits(sourceCount);
        }

        @Override
        public long toBytes(long count) {
            return count * 125000L;
        }

        @Override
        public long toBits(long count) {
            return UnitUtil.multiply(count, 1000000L, 9223372036854L);
        }

        @Override
        public long toKilobits(long count) {
            return UnitUtil.multiply(count, 1000L, 9223372036854775L);
        }

        @Override
        public long toMegabits(long count) {
            return count;
        }

        @Override
        public long toGigabits(long count) {
            return count / 1000L;
        }

        @Override
        public long toTerabits(long count) {
            return count / 1000000L;
        }

        @Override
        public long toPetabits(long count) {
            return count / 1000000000L;
        }
    }
    ,
    GIGABITS{

        @Override
        public long convert(long sourceCount, BitUnit sourceUnit) {
            return sourceUnit.toGigabits(sourceCount);
        }

        @Override
        public long toBytes(long count) {
            return count * 125000000L;
        }

        @Override
        public long toBits(long count) {
            return UnitUtil.multiply(count, 1000000000L, 9223372036L);
        }

        @Override
        public long toKilobits(long count) {
            return UnitUtil.multiply(count, 1000000L, 9223372036854L);
        }

        @Override
        public long toMegabits(long count) {
            return UnitUtil.multiply(count, 1000L, 9223372036854775L);
        }

        @Override
        public long toGigabits(long count) {
            return count;
        }

        @Override
        public long toTerabits(long count) {
            return count / 1000L;
        }

        @Override
        public long toPetabits(long count) {
            return count / 1000000L;
        }
    }
    ,
    TERABITS{

        @Override
        public long convert(long sourceCount, BitUnit sourceUnit) {
            return sourceUnit.toTerabits(sourceCount);
        }

        @Override
        public long toBytes(long count) {
            return count * 125000000000L;
        }

        @Override
        public long toBits(long count) {
            return UnitUtil.multiply(count, 1000000000000L, 0x8CBCCCL);
        }

        @Override
        public long toKilobits(long count) {
            return UnitUtil.multiply(count, 1000000000L, 9223372036L);
        }

        @Override
        public long toMegabits(long count) {
            return UnitUtil.multiply(count, 1000000L, 9223372036854L);
        }

        @Override
        public long toGigabits(long count) {
            return UnitUtil.multiply(count, 1000L, 9223372036854775L);
        }

        @Override
        public long toTerabits(long count) {
            return count;
        }

        @Override
        public long toPetabits(long count) {
            return count / 1000L;
        }
    }
    ,
    PETABITS{

        @Override
        public long convert(long sourceCount, BitUnit sourceUnit) {
            return sourceUnit.toPetabits(sourceCount);
        }

        @Override
        public long toBytes(long count) {
            return count * 125000000000000L;
        }

        @Override
        public long toBits(long count) {
            return UnitUtil.multiply(count, 1000000000000000L, 9223L);
        }

        @Override
        public long toKilobits(long count) {
            return UnitUtil.multiply(count, 1000000000000L, 0x8CBCCCL);
        }

        @Override
        public long toMegabits(long count) {
            return UnitUtil.multiply(count, 1000000000L, 9223372036L);
        }

        @Override
        public long toGigabits(long count) {
            return UnitUtil.multiply(count, 1000000L, 9223372036854L);
        }

        @Override
        public long toTerabits(long count) {
            return UnitUtil.multiply(count, 1000L, 9223372036854775L);
        }

        @Override
        public long toPetabits(long count) {
            return count;
        }
    };

    private static final long B = 1L;
    private static final long KB = 1000L;
    private static final long MB = 1000000L;
    private static final long GB = 1000000000L;
    private static final long TB = 1000000000000L;
    private static final long PB = 1000000000000000L;
    private static final long BYTE = 8L;
    private static final long KBYTE = 125L;
    private static final long MBYTE = 125000L;
    private static final long GBYTE = 125000000L;
    private static final long TBYTE = 125000000000L;
    private static final long PBYTE = 125000000000000L;
    private static final long MAX = Long.MAX_VALUE;
    private static final String[] UNITS;

    public long convert(long sourceCount, BitUnit sourceUnit) {
        throw new AbstractMethodError();
    }

    public long toBits(long count) {
        throw new AbstractMethodError();
    }

    public long toKilobits(long count) {
        throw new AbstractMethodError();
    }

    public long toMegabits(long count) {
        throw new AbstractMethodError();
    }

    public long toGigabits(long count) {
        throw new AbstractMethodError();
    }

    public long toTerabits(long count) {
        throw new AbstractMethodError();
    }

    public long toPetabits(long count) {
        throw new AbstractMethodError();
    }

    public static String format(long bits) {
        return BitUnit.format(bits, new DecimalFormat("#,##0.#"));
    }

    public static String format(long bits, String pattern) {
        return BitUnit.format(bits, new DecimalFormat(pattern));
    }

    public static String format(long bits, NumberFormat format) {
        double count;
        if (bits < 0L) {
            throw new IllegalArgumentException("bits < 0: " + bits);
        }
        int unitIndex = 0;
        for (count = (double)bits; count >= 1000.0 && unitIndex < UNITS.length - 1; count /= 1000.0, ++unitIndex) {
        }
        return format.format(count) + ' ' + UNITS[unitIndex];
    }

    static {
        UNITS = new String[]{"b", "Kb", "Mb", "Gb", "Tb", "Pb"};
    }
}

