/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.metrics.tests;

import java.util.concurrent.atomic.AtomicInteger;
import org.apache.james.metrics.api.Metric;

public class RecordingMetric
implements Metric {
    private final AtomicInteger value;

    RecordingMetric() {
        this(new AtomicInteger());
    }

    RecordingMetric(AtomicInteger value) {
        this.value = value;
    }

    public void increment() {
        this.value.incrementAndGet();
    }

    public void decrement() {
        this.value.updateAndGet(currentValue -> this.subtractFrom(currentValue, 1));
    }

    public void add(int i) {
        this.value.addAndGet(i);
    }

    public void remove(int i) {
        this.value.updateAndGet(currentValue -> this.subtractFrom(currentValue, i));
    }

    public long getCount() {
        return this.value.longValue();
    }

    private int subtractFrom(int currentValue, int minus) {
        int result = currentValue - minus;
        if (result < 0) {
            throw new UnsupportedOperationException("metric counter is supposed to be a non-negative number, thus this operation cannot be applied");
        }
        return result;
    }
}

