/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.tools.jsonrpc;

import com.rabbitmq.client.Channel;
import com.rabbitmq.client.RpcClient;
import com.rabbitmq.client.RpcClientParams;
import com.rabbitmq.client.ShutdownSignalException;
import com.rabbitmq.tools.json.JSONReader;
import com.rabbitmq.tools.jsonrpc.DefaultJsonRpcMapper;
import com.rabbitmq.tools.jsonrpc.JsonRpcException;
import com.rabbitmq.tools.jsonrpc.JsonRpcMapper;
import com.rabbitmq.tools.jsonrpc.ParameterDescription;
import com.rabbitmq.tools.jsonrpc.ProcedureDescription;
import com.rabbitmq.tools.jsonrpc.ServiceDescription;
import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonRpcClient
extends RpcClient
implements InvocationHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(JsonRpcClient.class);
    private final JsonRpcMapper mapper;
    private ServiceDescription serviceDescription;

    public JsonRpcClient(RpcClientParams rpcClientParams, JsonRpcMapper mapper) throws IOException, JsonRpcException, TimeoutException {
        super(rpcClientParams);
        this.mapper = mapper;
        this.retrieveServiceDescription();
    }

    public JsonRpcClient(Channel channel, String exchange, String routingKey, int timeout, JsonRpcMapper mapper) throws IOException, JsonRpcException, TimeoutException {
        super(new RpcClientParams().channel(channel).exchange(exchange).routingKey(routingKey).timeout(timeout));
        this.mapper = mapper;
        this.retrieveServiceDescription();
    }

    public JsonRpcClient(Channel channel, String exchange, String routingKey, int timeout) throws IOException, JsonRpcException, TimeoutException {
        this(channel, exchange, routingKey, timeout, new DefaultJsonRpcMapper());
    }

    public JsonRpcClient(Channel channel, String exchange, String routingKey) throws IOException, JsonRpcException, TimeoutException {
        this(channel, exchange, routingKey, -1);
    }

    @Deprecated
    public static Object coerce(String val, String type) throws NumberFormatException {
        if ("bit".equals(type)) {
            return Boolean.getBoolean(val) ? Boolean.TRUE : Boolean.FALSE;
        }
        if ("num".equals(type)) {
            try {
                return Integer.valueOf(val);
            }
            catch (NumberFormatException nfe) {
                return Double.valueOf(val);
            }
        }
        if ("str".equals(type)) {
            return val;
        }
        if ("arr".equals(type) || "obj".equals(type) || "any".equals(type)) {
            return new JSONReader().read(val);
        }
        if ("nil".equals(type)) {
            return null;
        }
        throw new IllegalArgumentException("Bad type: " + type);
    }

    private Object checkReply(JsonRpcMapper.JsonRpcResponse reply) throws JsonRpcException {
        if (reply.getError() != null) {
            throw reply.getException();
        }
        return reply.getResult();
    }

    public Object call(String method, Object[] params) throws IOException, JsonRpcException, TimeoutException {
        HashMap<String, Object> request = new HashMap<String, Object>();
        request.put("id", null);
        request.put("method", method);
        request.put("version", "1.1");
        params = params == null ? new Object[]{} : params;
        request.put("params", params);
        String requestStr = this.mapper.write(request);
        try {
            Class expectedType;
            String replyStr = this.stringCall(requestStr);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Reply string: {}", (Object)replyStr);
            }
            if ("system.describe".equals(method) && params.length == 0) {
                expectedType = Map.class;
            } else {
                ProcedureDescription proc = this.serviceDescription.getProcedure(method, params.length);
                expectedType = proc.getReturnType();
            }
            JsonRpcMapper.JsonRpcResponse reply = this.mapper.parse(replyStr, expectedType);
            return this.checkReply(reply);
        }
        catch (ShutdownSignalException ex) {
            throw new IOException(ex.getMessage());
        }
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        return this.call(method.getName(), args);
    }

    public <T> T createProxy(Class<T> klass) throws IllegalArgumentException {
        return (T)Proxy.newProxyInstance(klass.getClassLoader(), new Class[]{klass}, (InvocationHandler)this);
    }

    @Deprecated
    public Object call(String[] args) throws NumberFormatException, IOException, JsonRpcException, TimeoutException {
        if (args.length == 0) {
            throw new IllegalArgumentException("First string argument must be method name");
        }
        String method = args[0];
        int arity = args.length - 1;
        ProcedureDescription proc = this.serviceDescription.getProcedure(method, arity);
        ParameterDescription[] params = proc.getParams();
        Object[] actuals = new Object[arity];
        for (int count = 0; count < params.length; ++count) {
            actuals[count] = JsonRpcClient.coerce(args[count + 1], params[count].getType());
        }
        return this.call(method, actuals);
    }

    public ServiceDescription getServiceDescription() {
        return this.serviceDescription;
    }

    private void retrieveServiceDescription() throws IOException, JsonRpcException, TimeoutException {
        Map rawServiceDescription = (Map)this.call("system.describe", null);
        this.serviceDescription = new ServiceDescription(rawServiceDescription);
    }
}

