/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 *
 *   SPDX-License-Identifier: Apache-2.0
 */

package org.apache.jena.arq.junit.manifest;

import java.util.function.Function;

import org.apache.jena.arq.junit.SurpressedTest;

/**
 * A {@code TestMaker} is a function takes a {@link ManifestEntry} and provides a
 * {@link Runnable} for the test. The function should return null if the
 * {@link ManifestEntry} is not accepted by this {@code TestMaker}.
 * <p>
 * Use {@link SurpressedTest} to accept a manifest entry and do nothing.
 */
@FunctionalInterface
public interface TestMaker extends Function<ManifestEntry, Runnable> {}
