/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 *
 *   SPDX-License-Identifier: Apache-2.0
 */

package org.apache.jena.arq.junit.sparql.tests;

import static org.junit.jupiter.api.Assertions.fail;

import org.apache.jena.arq.junit.LibTest;
import org.apache.jena.arq.junit.manifest.AbstractManifestTest;
import org.apache.jena.arq.junit.manifest.ManifestEntry;
import org.apache.jena.atlas.lib.FileOps;
import org.apache.jena.query.Syntax;

public class UpdateSyntaxTest extends AbstractManifestTest {
    final boolean expectLegalSyntax ;
    final Syntax testSyntax;

    public UpdateSyntaxTest(ManifestEntry entry, Syntax defSyntax, boolean positiveTest) {
        super(entry);
        testSyntax = defSyntax;
        expectLegalSyntax = positiveTest ;
    }

    @Override
    public void runTest() {
        try {
            SparqlTestLib.updateFromEntry(manifestEntry, testSyntax) ;
            if ( ! expectLegalSyntax ) {
                String filename = SparqlTestLib.getAction(manifestEntry);
                System.out.printf("==== Syntax test %s : %s\n", FileOps.basename(filename), "expected negative, got positive");
                LibTest.printFile(filename);
                fail("Expected parse failure");
            }
        } catch (RuntimeException ex) {
            if ( expectLegalSyntax ) {
                String filename = SparqlTestLib.getAction(manifestEntry);
                System.out.printf("==== Syntax test %s : %s\n", FileOps.basename(filename), "expected positive, got negative");
                LibTest.printFile(filename);
                throw ex;
            }
        } catch (AssertionError ex) {
            throw ex;
        } catch (Exception ex) {
            ex.printStackTrace();
            fail("Exception: " + ex.getClass().getName() + ": " + ex.getMessage());
        }
    }
}
