/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.functions;

import com.google.auto.service.AutoService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.jmeter.engine.util.CompoundVariable;
import org.apache.jmeter.functions.AbstractFunction;
import org.apache.jmeter.functions.Function;
import org.apache.jmeter.functions.InvalidVariableException;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.samplers.Sampler;
import org.apache.jmeter.threads.JMeterVariables;
import org.apache.jmeter.util.JMeterUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AutoService(value={Function.class})
public class EvalVarFunction
extends AbstractFunction {
    private static final Logger log = LoggerFactory.getLogger(EvalVarFunction.class);
    private static final List<String> desc = new ArrayList<String>();
    private static final String KEY = "__evalVar";
    private static final int MIN_PARAMETER_COUNT = 1;
    private static final int MAX_PARAMETER_COUNT = 1;
    private Object[] values;

    public String execute(SampleResult previousResult, Sampler currentSampler) throws InvalidVariableException {
        String variableName = ((CompoundVariable)this.values[0]).execute();
        JMeterVariables vars = this.getVariables();
        if (vars == null) {
            log.error("Variables have not yet been defined");
            return "**ERROR - see log file**";
        }
        String variableValue = vars.get(variableName);
        CompoundVariable cv = new CompoundVariable(variableValue);
        return cv.execute();
    }

    public void setParameters(Collection<CompoundVariable> parameters) throws InvalidVariableException {
        this.checkParameterCount(parameters, 1, 1);
        this.values = parameters.toArray();
    }

    public String getReferenceKey() {
        return KEY;
    }

    public List<String> getArgumentDesc() {
        return desc;
    }

    static {
        desc.add(JMeterUtils.getResString((String)"evalvar_name_param"));
    }
}

