/*
 * Decompiled with CFR 0.152.
 */
package org.apache.johnzon.jsonschema.generator;

import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.json.JsonObject;
import javax.json.JsonString;
import javax.json.JsonValue;
import javax.json.bind.annotation.JsonbProperty;

public class PojoGenerator {
    private final PojoConfiguration configuration;
    protected final Set<String> imports = new TreeSet<String>(String::compareTo);
    protected final List<Attribute> attributes = new ArrayList<Attribute>();
    protected final Map<String, String> nested = new TreeMap<String, String>(String::compareTo);
    private boolean isEnum;

    public PojoGenerator(PojoConfiguration configuration) {
        this.configuration = configuration;
    }

    public PojoGenerator setNested(Map<String, String> nested) {
        this.nested.putAll(nested);
        return this;
    }

    public Map<String, String> generate() {
        if (this.isEnum) {
            return this.nested;
        }
        String name = this.configuration.getPackageName() + '.' + this.configuration.getClassName();
        String path = name.replace('.', '/') + ".java";
        this.attributes.sort(Comparator.comparing(a -> a.javaName));
        if (!this.attributes.isEmpty()) {
            this.imports.add(Objects.class.getName());
        }
        String content = "package " + this.configuration.getPackageName() + ";\n\n" + (this.imports.isEmpty() ? "" : this.imports.stream().sorted().map(it -> "import " + it + ";").collect(Collectors.joining("\n", "", "\n\n"))) + this.beforeClassDeclaration() + "public class " + this.configuration.getClassName() + this.afterClassName() + " {\n" + (this.attributes.isEmpty() ? "    @Override\n    public int hashCode() {\n        return 0;\n    }\n\n    @Override\n    public boolean equals(final Object other) {\n        return other instanceof " + this.configuration.getClassName() + ";\n    }\n" : this.attributes.stream().map(a -> "" + (this.configuration.isAddJsonbProperty() && !Objects.equals(a.javaName, a.jsonName) ? "    @JsonbProperty(\"" + a.jsonName.replace("\"", "\\\"") + "\")\n" : "") + "    private " + a.type + " " + a.javaName + ";").collect(Collectors.joining("\n", "", "\n\n")) + (this.configuration.isAddAllArgsConstructor() ? "    public " + this.configuration.getClassName() + "() {\n        // no-op\n    }\n\n    public " + this.configuration.getClassName() + "(" + this.attributes.stream().map(a -> "final " + a.type + " " + a.javaName).collect(Collectors.joining(",\n" + IntStream.range(0, "    public (".length() + this.configuration.getClassName().length()).mapToObj(i -> " ").collect(Collectors.joining()), "", ") {\n" + this.attributes.stream().map(a -> "        this." + a.getJavaName() + " = " + a.javaName + ";\n").collect(Collectors.joining()) + "    }\n\n")) : "") + this.attributes.stream().map(a -> {
            String marker = Character.toUpperCase(a.javaName.charAt(0)) + a.javaName.substring(1);
            return "    public " + a.type + " get" + Character.toUpperCase(a.javaName.charAt(0)) + a.javaName.substring(1) + "() {\n        return " + a.javaName + ";\n    }\n\n    public " + (this.configuration.isFluentSetters() ? this.configuration.getClassName() : "void") + " set" + marker + "(final " + a.type + " " + a.javaName + ") {\n        this." + a.javaName + " = " + a.javaName + ";\n" + (this.configuration.isFluentSetters() ? "        return this;\n" : "") + "    }\n";
        }).collect(Collectors.joining("\n", "", "\n")) + "    @Override\n    public int hashCode() {\n        return Objects.hash(\n" + this.attributes.stream().map(a -> a.javaName).collect(Collectors.joining(",\n                ", "                ", ");\n")) + "    }\n\n    @Override\n    public boolean equals(final Object __other) {\n        if (!(__other instanceof " + this.configuration.getClassName() + ")) {\n            return false;\n        }\n        final " + this.configuration.getClassName() + " __otherCasted = (" + this.configuration.getClassName() + ") __other;\n        return " + this.attributes.stream().map(a -> a.javaName).map(it -> "Objects.equals(" + it + ", __otherCasted." + it + ")").collect(Collectors.joining(" &&\n            ")) + ";\n    }\n") + this.beforeClassEnd() + "}\n";
        if (this.nested.isEmpty()) {
            return Collections.singletonMap(path, content);
        }
        return Stream.concat(this.nested.entrySet().stream(), Stream.of(new AbstractMap.SimpleImmutableEntry<String, String>(path, content))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (a, b) -> a, () -> new TreeMap(String::compareTo)));
    }

    public PojoGenerator visitSchema(JsonObject schema) {
        if (!schema.containsKey((Object)"properties")) {
            if (schema.containsKey((Object)"enum")) {
                this.isEnum = true;
                this.doEnum((JsonValue)schema.getJsonArray("enum"), this.configuration.getClassName());
                return this;
            }
            throw new IllegalArgumentException("Unsupported schema since it does not contain any properties: " + schema);
        }
        JsonObject properties = PojoGenerator.getValueAs(schema, "properties", JsonObject.class);
        JsonValue required = (JsonValue)schema.get((Object)"required");
        List requiredAttrs = required != null && required.getValueType() == JsonValue.ValueType.ARRAY ? required.asJsonArray().stream().map(JsonString.class::cast).map(JsonString::getString).collect(Collectors.toList()) : null;
        this.attributes.addAll(properties.entrySet().stream().map(e -> {
            String javaName = this.toJavaName((String)e.getKey());
            return new Attribute(javaName, (String)e.getKey(), this.asType(javaName, ((JsonValue)e.getValue()).asJsonObject(), requiredAttrs != null && requiredAttrs.contains(e.getKey())));
        }).collect(Collectors.toList()));
        return this;
    }

    protected String onRef(Ref ref) {
        if (this.configuration.getOnRef() != null) {
            return this.configuration.getOnRef().apply(ref);
        }
        return null;
    }

    protected String beforeEnumEnd() {
        return "";
    }

    protected String beforeClassEnd() {
        return "";
    }

    protected String afterClassName() {
        return "";
    }

    protected String afterEnumName(Map<String, String> values, boolean valuesAreInjected) {
        return "";
    }

    protected String enumImports() {
        return "";
    }

    protected String beforeEnumDeclaration() {
        return "";
    }

    protected String beforeClassDeclaration() {
        return "";
    }

    /*
     * Enabled aggressive block sorting
     */
    protected String asType(String javaName, JsonObject schema, boolean required) {
        String type;
        String name;
        JsonValue ref = (JsonValue)schema.get((Object)"$ref");
        if (ref != null && ref.getValueType() == JsonValue.ValueType.STRING && (name = this.onRef(new Ref(((JsonString)JsonString.class.cast(ref)).getString(), this.configuration.getClassName(), this.imports, this.attributes, this.nested))) != null) {
            return name;
        }
        JsonValue value = (JsonValue)schema.get((Object)"type");
        if (value == null) {
            if (schema.containsKey((Object)"properties") || schema.containsKey((Object)"additionalProperties")) {
                type = "object";
            } else {
                if (!schema.containsKey((Object)"items")) {
                    this.imports.add(JsonValue.class.getName());
                    return JsonValue.class.getSimpleName();
                }
                type = "array";
            }
        } else {
            type = ((JsonString)JsonString.class.cast(value)).getString();
        }
        JsonValue formatValue = (JsonValue)schema.get((Object)"date-time");
        if (formatValue != null && formatValue.getValueType() == JsonValue.ValueType.STRING) {
            type = ((JsonString)JsonString.class.cast(formatValue)).getString();
        }
        switch (type) {
            case "array": {
                JsonObject items = PojoGenerator.getValueAs(schema, "items", JsonObject.class);
                String itemType = this.onItemSchema(javaName, items);
                this.imports.add(List.class.getName());
                return List.class.getSimpleName() + "<" + itemType + ">";
            }
            case "object": {
                return this.onObjectAttribute(javaName, schema);
            }
            case "null": {
                this.imports.add(JsonValue.class.getName());
                return JsonValue.class.getSimpleName();
            }
            case "boolean": {
                if (!required) return "Boolean";
                return "boolean";
            }
            case "string": {
                JsonValue enumList = (JsonValue)schema.get((Object)"enum");
                if (enumList == null) return "String";
                if (enumList.getValueType() != JsonValue.ValueType.ARRAY) return "String";
                return this.onEnum(javaName, enumList, schema);
            }
            case "number": 
            case "double": {
                if (!required) return "Double";
                return "double";
            }
            case "int": 
            case "int32": 
            case "integer": {
                if (!required) return "Integer";
                return "int";
            }
            case "int64": 
            case "long": {
                if (!required) return "Long";
                return "long";
            }
            case "float": {
                if (!required) return "Float";
                return "float";
            }
            case "date": {
                this.imports.add(LocalDate.class.getName());
                return LocalDate.class.getSimpleName();
            }
            case "duration": {
                this.imports.add(Duration.class.getName());
                return Duration.class.getSimpleName();
            }
            case "date-time": 
            case "dateTime": {
                this.imports.add(OffsetDateTime.class.getName());
                return OffsetDateTime.class.getSimpleName();
            }
            case "time": {
                this.imports.add(LocalTime.class.getName());
                return LocalTime.class.getSimpleName();
            }
            case "byte": {
                return "byte[]";
            }
            case "uuid": 
            case "hostname": 
            case "idn-hostname": 
            case "email": 
            case "idn-email": 
            case "ipv4": 
            case "ipv6": 
            case "uri": 
            case "uri-reference": 
            case "iri": 
            case "iri-reference": 
            case "uri-template": 
            case "json-pointer": 
            case "relative-json-pointer": 
            case "regex": 
            case "binary": 
            case "password": {
                return "String";
            }
        }
        throw new IllegalArgumentException("Unsupported type: " + type);
    }

    protected String onEnum(String javaName, JsonValue enumList, JsonObject schema) {
        String className = this.enumName(javaName, schema);
        this.doEnum(enumList, className);
        return className;
    }

    private void doEnum(JsonValue enumList, String className) {
        Map<String, String> values = enumList.asJsonArray().stream().map(JsonString.class::cast).map(JsonString::getString).collect(Collectors.toMap(Function.identity(), this::toJavaName));
        boolean injectValues = !values.keySet().equals(new HashSet<String>(values.values()));
        this.nested.put(this.configuration.getPackageName().replace('.', '/') + '/' + className + ".java", "package " + this.configuration.getPackageName() + ";\n\n" + this.enumImports() + (injectValues ? "import " + JsonbProperty.class.getName() + ";\n\n" : "") + this.beforeEnumDeclaration() + "public enum " + className + this.afterEnumName(values, injectValues) + " {\n" + values.entrySet().stream().map(it -> "" + (injectValues && this.configuration.isAddJsonbProperty() ? "    @JsonbProperty(\"" + ((String)it.getKey()).replace("\"", "\\\"") + "\")\n" : "") + "    " + (String)it.getValue() + (injectValues ? "(\"" + ((String)it.getKey()).replace("\"", "\\\"") + "\")" : "")).collect(Collectors.joining(",\n", "", injectValues ? ";\n\n" : "\n")) + (injectValues ? "    private String value;\n\n    " + className + "(final String value) {\n        this.value = value;\n    }\n\n    public String toString() {\n        return value;\n    }\n" : "") + this.beforeEnumEnd() + "}\n");
    }

    protected String enumName(String javaName, JsonObject schema) {
        return this.configuration.getClassName() + Character.toUpperCase(javaName.charAt(0)) + javaName.substring(1);
    }

    protected String onObjectAttribute(String javaName, JsonObject schema) {
        boolean hasProperties;
        JsonValue additionalProperties = (JsonValue)schema.get((Object)"additionalProperties");
        JsonValue properties = (JsonValue)schema.get((Object)"properties");
        boolean bl = hasProperties = properties != null && properties.getValueType() == JsonValue.ValueType.OBJECT;
        if (!hasProperties && additionalProperties != null && additionalProperties.getValueType() == JsonValue.ValueType.OBJECT) {
            JsonObject propSchema = additionalProperties.asJsonObject();
            JsonValue propTypeValue = (JsonValue)propSchema.get((Object)"type");
            if (propTypeValue != null && propTypeValue.getValueType() == JsonValue.ValueType.STRING) {
                String propType = ((JsonString)JsonString.class.cast(propTypeValue)).getString();
                JsonValue formatValue = (JsonValue)schema.get((Object)"date-time");
                if (formatValue != null && formatValue.getValueType() == JsonValue.ValueType.STRING) {
                    propType = ((JsonString)JsonString.class.cast(formatValue)).getString();
                }
                switch (propType) {
                    case "uuid": 
                    case "hostname": 
                    case "idn-hostname": 
                    case "email": 
                    case "idn-email": 
                    case "ipv4": 
                    case "ipv6": 
                    case "uri": 
                    case "uri-reference": 
                    case "iri": 
                    case "iri-reference": 
                    case "uri-template": 
                    case "json-pointer": 
                    case "relative-json-pointer": 
                    case "regex": 
                    case "string": 
                    case "binary": 
                    case "password": {
                        this.imports.add(Map.class.getName());
                        return "Map<String, String>";
                    }
                    case "boolean": {
                        this.imports.add(Map.class.getName());
                        return "Map<String, Boolean>";
                    }
                    case "number": 
                    case "double": {
                        this.imports.add(Map.class.getName());
                        return "Map<String, Double>";
                    }
                    case "int": 
                    case "int32": 
                    case "integer": {
                        this.imports.add(Map.class.getName());
                        return "Map<String, Integer>";
                    }
                    case "int64": 
                    case "long": {
                        this.imports.add(Map.class.getName());
                        return "Map<String, Long>";
                    }
                    case "float": {
                        this.imports.add(Map.class.getName());
                        return "Map<String, Float>";
                    }
                    case "date": {
                        this.imports.add(Map.class.getName());
                        this.imports.add(LocalDate.class.getName());
                        return "Map<String, LocalDate>";
                    }
                    case "dateTime": 
                    case "date-time": {
                        this.imports.add(Map.class.getName());
                        this.imports.add(OffsetDateTime.class.getName());
                        return "Map<String, OffsetDateTime>";
                    }
                    case "duration": {
                        this.imports.add(Map.class.getName());
                        this.imports.add(Duration.class.getName());
                        return "Map<String, Duration>";
                    }
                    case "time": {
                        this.imports.add(Map.class.getName());
                        this.imports.add(LocalTime.class.getName());
                        return "Map<String, LocalTime>";
                    }
                }
            }
        } else if (hasProperties) {
            String className = this.configuration.getClassName() + Character.toUpperCase(javaName.charAt(0)) + javaName.substring(1);
            this.nested.putAll(this.newSubPojoGenerator(new PojoConfiguration().setPackageName(this.configuration.getPackageName()).setClassName(className).setAddJsonbProperty(this.configuration.isAddJsonbProperty()).setAddAllArgsConstructor(this.configuration.isAddAllArgsConstructor()).setOnRef(this.configuration.getOnRef()), schema).visitSchema(schema).generate());
            return className;
        }
        this.imports.add(JsonObject.class.getName());
        return JsonObject.class.getSimpleName();
    }

    protected PojoGenerator newSubPojoGenerator(PojoConfiguration pojoConfiguration, JsonObject schema) {
        return new PojoGenerator(pojoConfiguration);
    }

    protected String onItemSchema(String javaName, JsonObject schema) {
        String name;
        JsonValue ref = (JsonValue)schema.get((Object)"$ref");
        if (ref != null && ref.getValueType() == JsonValue.ValueType.STRING && (name = this.onRef(new Ref(((JsonString)JsonString.class.cast(ref)).getString(), this.configuration.getClassName(), this.imports, this.attributes, this.nested))) != null) {
            return name;
        }
        JsonValue propTypeValue = (JsonValue)schema.get((Object)"type");
        if (propTypeValue != null && propTypeValue.getValueType() == JsonValue.ValueType.STRING) {
            String type = ((JsonString)JsonString.class.cast(propTypeValue)).getString();
            JsonValue formatValue = (JsonValue)schema.get((Object)"date-time");
            if (formatValue != null && formatValue.getValueType() == JsonValue.ValueType.STRING) {
                type = ((JsonString)JsonString.class.cast(formatValue)).getString();
            }
            switch (type) {
                case "array": {
                    throw new IllegalStateException("Array of array unsupported");
                }
                case "object": {
                    String className = this.configuration.getClassName() + Character.toUpperCase(javaName.charAt(0)) + javaName.substring(1);
                    this.nested.putAll(this.newSubPojoGenerator(new PojoConfiguration().setPackageName(this.configuration.getPackageName()).setClassName(className).setAddJsonbProperty(this.configuration.isAddJsonbProperty()).setAddAllArgsConstructor(this.configuration.isAddAllArgsConstructor()).setOnRef(this.configuration.getOnRef()), schema).visitSchema(schema).generate());
                    return className;
                }
                case "null": {
                    this.imports.add(JsonValue.class.getName());
                    return JsonValue.class.getSimpleName();
                }
                case "boolean": {
                    return "Boolean";
                }
                case "uuid": 
                case "hostname": 
                case "idn-hostname": 
                case "email": 
                case "idn-email": 
                case "ipv4": 
                case "ipv6": 
                case "uri": 
                case "uri-reference": 
                case "iri": 
                case "iri-reference": 
                case "uri-template": 
                case "json-pointer": 
                case "relative-json-pointer": 
                case "regex": 
                case "string": 
                case "binary": 
                case "password": {
                    return "String";
                }
                case "number": 
                case "double": {
                    return "Double";
                }
                case "int": 
                case "int32": 
                case "integer": {
                    return "Integer";
                }
                case "int64": 
                case "long": {
                    return "Long";
                }
                case "float": {
                    return "Float";
                }
                case "date": {
                    this.imports.add(LocalDate.class.getName());
                    return LocalDate.class.getSimpleName();
                }
                case "dateTime": {
                    this.imports.add(OffsetDateTime.class.getName());
                    return OffsetDateTime.class.getSimpleName();
                }
                case "duration": {
                    this.imports.add(Duration.class.getName());
                    return Duration.class.getSimpleName();
                }
                case "time": {
                    this.imports.add(LocalTime.class.getName());
                    return LocalTime.class.getSimpleName();
                }
                case "byte": {
                    return "byte[]";
                }
            }
            throw new IllegalArgumentException("Unsupported type: " + type);
        }
        this.imports.add(JsonValue.class.getName());
        return JsonValue.class.getSimpleName();
    }

    protected String toJavaName(String key) {
        String name = key.chars().mapToObj(i -> Character.toString((char)(!Character.isJavaIdentifierPart(i) ? 95 : (char)i))).collect(Collectors.joining());
        if (Character.isDigit(name.charAt(0))) {
            name = "a" + name;
        }
        while (!(name.isEmpty() || Character.isJavaIdentifierStart(name.charAt(0)) && name.charAt(0) != '_' && name.charAt(0) != '$')) {
            name = name.substring(1);
        }
        if (name.isEmpty()) {
            throw new IllegalArgumentException("Can't find a name for '" + key + "'");
        }
        if (this.isReserved(name)) {
            name = name + "Value";
        }
        if (name.contains("_")) {
            name = this.toCamelCase(name);
        }
        if (!Objects.equals(key, name) && this.configuration.isAddJsonbProperty()) {
            this.imports.add(JsonbProperty.class.getName());
        }
        return name;
    }

    protected String toCamelCase(String name) {
        StringBuilder out = new StringBuilder(name.length());
        boolean up = false;
        for (char c : name.toCharArray()) {
            if (up) {
                out.append(Character.toUpperCase(c));
                up = false;
                continue;
            }
            if (c == '_') {
                up = true;
                continue;
            }
            out.append(c);
        }
        return out.toString();
    }

    protected boolean isReserved(String name) {
        return "continue".equals(name) || "break".equals(name) || "default".equals(name) || "do".equals(name) || "while".equals(name) || "for".equals(name) || "if".equals(name) || "else".equals(name) || "enum".equals(name) || "int".equals(name) || "long".equals(name) || "float".equals(name) || "double".equals(name) || "boolean".equals(name) || "byte".equals(name) || "char".equals(name) || "short".equals(name) || "String".equals(name);
    }

    private static <T> T getValueAs(JsonObject schema, String attribute, Class<T> type) {
        JsonValue value = (JsonValue)schema.get((Object)attribute);
        if (value == null) {
            throw new IllegalArgumentException("No \"" + attribute + "\" value in " + schema);
        }
        return PojoGenerator.valueAs(schema, type, value);
    }

    private static <T> T valueAs(JsonObject schema, Class<T> type, JsonValue value) {
        if (!type.isInstance(value)) {
            throw new IllegalArgumentException("\"items\" not an object: " + schema);
        }
        return type.cast(value);
    }

    public static class Ref {
        private final String ref;
        private final String enclosingClass;
        private final Set<String> imports;
        private final List<Attribute> attributes;
        private final Map<String, String> nested;

        private Ref(String ref, String enclosingClass, Set<String> imports, List<Attribute> attributes, Map<String, String> nested) {
            this.ref = ref;
            this.enclosingClass = enclosingClass;
            this.imports = imports;
            this.attributes = attributes;
            this.nested = nested;
        }

        public String getEnclosingClass() {
            return this.enclosingClass;
        }

        public String getRef() {
            return this.ref;
        }

        public Set<String> getImports() {
            return this.imports;
        }

        public List<Attribute> getAttributes() {
            return this.attributes;
        }

        public Map<String, String> getNested() {
            return this.nested;
        }
    }

    protected static class Attribute {
        protected final String javaName;
        protected final String jsonName;
        protected final String type;

        protected Attribute(String javaName, String jsonName, String type) {
            this.javaName = javaName;
            this.jsonName = jsonName;
            this.type = type;
        }

        public String getJavaName() {
            return this.javaName;
        }

        public String getJsonName() {
            return this.jsonName;
        }

        public String getType() {
            return this.type;
        }
    }

    public static class PojoConfiguration {
        private String packageName = "org.apache.johnzon.generated.pojo";
        private String className;
        private boolean addJsonbProperty = true;
        private boolean addAllArgsConstructor = true;
        private boolean fluentSetters = false;
        private Function<Ref, String> onRef;

        public Function<Ref, String> getOnRef() {
            return this.onRef;
        }

        public PojoConfiguration setOnRef(Function<Ref, String> onRef) {
            this.onRef = onRef;
            return this;
        }

        public boolean isFluentSetters() {
            return this.fluentSetters;
        }

        public PojoConfiguration setFluentSetters(boolean fluentSetters) {
            this.fluentSetters = fluentSetters;
            return this;
        }

        public boolean isAddAllArgsConstructor() {
            return this.addAllArgsConstructor;
        }

        public PojoConfiguration setAddAllArgsConstructor(boolean addAllArgsConstructor) {
            this.addAllArgsConstructor = addAllArgsConstructor;
            return this;
        }

        public boolean isAddJsonbProperty() {
            return this.addJsonbProperty;
        }

        public PojoConfiguration setAddJsonbProperty(boolean addJsonbProperty) {
            this.addJsonbProperty = addJsonbProperty;
            return this;
        }

        public String getClassName() {
            return this.className;
        }

        public PojoConfiguration setClassName(String className) {
            this.className = className;
            return this;
        }

        public String getPackageName() {
            return this.packageName;
        }

        public PojoConfiguration setPackageName(String packageName) {
            this.packageName = packageName;
            return this;
        }
    }
}

