/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management.mbean;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import org.apache.camel.CamelContext;
import org.apache.camel.Route;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.Service;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.api.management.mbean.CamelOpenMBeanTypes;
import org.apache.camel.api.management.mbean.ManagedSupervisingRouteControllerMBean;
import org.apache.camel.management.mbean.ManagedService;
import org.apache.camel.spi.SupervisingRouteController;
import org.apache.camel.util.TimeUtils;
import org.apache.camel.util.backoff.BackOffTimer;

@ManagedResource(description="Managed SupervisingRouteController")
public class ManagedSupervisingRouteController
extends ManagedService
implements ManagedSupervisingRouteControllerMBean {
    private final SupervisingRouteController controller;

    public ManagedSupervisingRouteController(CamelContext context, SupervisingRouteController controller) {
        super(context, (Service)controller);
        this.controller = controller;
    }

    public SupervisingRouteController getRouteController() {
        return this.controller;
    }

    public boolean isEnabled() {
        return true;
    }

    public int getThreadPoolSize() {
        return this.controller.getThreadPoolSize();
    }

    public long getInitialDelay() {
        return this.controller.getInitialDelay();
    }

    public long getBackOffDelay() {
        return this.controller.getBackOffDelay();
    }

    public long getBackOffMaxDelay() {
        return this.controller.getBackOffMaxDelay();
    }

    public long getBackOffMaxElapsedTime() {
        return this.controller.getBackOffMaxElapsedTime();
    }

    public long getBackOffMaxAttempts() {
        return this.controller.getBackOffMaxAttempts();
    }

    public double getBackOffMultiplier() {
        return this.controller.getBackOffMultiplier();
    }

    public String getIncludeRoutes() {
        return this.controller.getIncludeRoutes();
    }

    public String getExcludeRoutes() {
        return this.controller.getExcludeRoutes();
    }

    public int getNumberOfControlledRoutes() {
        return this.controller.getControlledRoutes().size();
    }

    public int getNumberOfRestartingRoutes() {
        return this.controller.getRestartingRoutes().size();
    }

    public int getNumberOfExhaustedRoutes() {
        return this.controller.getExhaustedRoutes().size();
    }

    public Collection<String> getControlledRoutes() {
        if (this.controller != null) {
            return this.controller.getControlledRoutes().stream().map(Route::getId).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    public String getRouteStartupLoggingLevel() {
        if (this.controller != null) {
            return this.controller.getRouteStartupLoggingLevel().name();
        }
        return null;
    }

    public Collection<String> getRestartingRoutes() {
        if (this.controller != null) {
            return this.controller.getRestartingRoutes().stream().map(Route::getId).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    public Collection<String> getExhaustedRoutes() {
        if (this.controller != null) {
            return this.controller.getExhaustedRoutes().stream().map(Route::getId).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    public TabularData routeStatus(boolean exhausted, boolean restarting, boolean includeStacktrace) {
        try {
            TabularDataSupport answer = new TabularDataSupport(CamelOpenMBeanTypes.supervisingRouteControllerRouteStatusTabularType());
            int index = 0;
            TreeSet<Route> routes = new TreeSet<Route>(Comparator.comparing(Route::getId));
            routes.addAll(this.controller.getControlledRoutes());
            if (exhausted) {
                routes.addAll(this.controller.getExhaustedRoutes());
            }
            if (restarting) {
                routes.addAll(this.controller.getRestartingRoutes());
            }
            for (Route route : routes) {
                long delta;
                long time;
                CompositeType ct = CamelOpenMBeanTypes.supervisingRouteControllerRouteStatusCompositeType();
                String routeId = route.getRouteId();
                String status = this.controller.getRouteStatus(routeId).name();
                BackOffTimer.Task state = this.controller.getRestartingRouteState(routeId);
                String supervising = state != null ? state.getStatus().name() : "";
                long attempts = state != null ? state.getCurrentAttempts() : 0L;
                String elapsed = "";
                String last = "";
                long l = time = state != null && BackOffTimer.Task.Status.Active == state.getStatus() ? state.getFirstAttemptTime() : 0L;
                if (time > 0L) {
                    delta = System.currentTimeMillis() - time;
                    elapsed = TimeUtils.printDuration((double)delta);
                }
                long l2 = time = state != null && BackOffTimer.Task.Status.Active == state.getStatus() ? state.getLastAttemptTime() : 0L;
                if (time > 0L) {
                    delta = System.currentTimeMillis() - time;
                    last = TimeUtils.printDuration((double)delta);
                }
                String error = "";
                String stacktrace = "";
                Throwable cause = this.controller.getRestartException(routeId);
                if (cause != null) {
                    error = cause.getMessage();
                    if (includeStacktrace) {
                        StringWriter writer = new StringWriter();
                        cause.printStackTrace(new PrintWriter(writer));
                        writer.flush();
                        stacktrace = writer.toString();
                    }
                }
                CompositeDataSupport data = new CompositeDataSupport(ct, new String[]{"index", "routeId", "status", "supervising", "attempts", "elapsed", "last", "error", "stacktrace"}, new Object[]{index, routeId, status, supervising, attempts, elapsed, last, error, stacktrace});
                answer.put(data);
                ++index;
            }
            return answer;
        }
        catch (Exception e) {
            throw RuntimeCamelException.wrapRuntimeCamelException((Throwable)e);
        }
    }
}

