/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.xml.descriptors;

import java.sql.Time;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Vector;
import org.exolab.castor.xml.XMLClassDescriptor;
import org.exolab.castor.xml.descriptors.DateClassDescriptor;
import org.exolab.castor.xml.descriptors.EnumerationDescriptor;
import org.exolab.castor.xml.descriptors.LocaleDescriptor;
import org.exolab.castor.xml.descriptors.SQLDateClassDescriptor;
import org.exolab.castor.xml.descriptors.SQLTimeClassDescriptor;
import org.exolab.castor.xml.descriptors.SQLTimestampClassDescriptor;
import org.exolab.castor.xml.descriptors.StringClassDescriptor;
import org.exolab.castor.xml.descriptors.VectorClassDescriptor;

public final class CoreDescriptors {
    private static final String LIST_CLASS_NAME = "java.util.List";
    private static final String LIST_DESCRIPTOR_NAME = "org.exolab.castor.xml.descriptors.ListClassDescriptor";
    private static final XMLClassDescriptor ENUMERATION_DESCRIPTOR = new EnumerationDescriptor();
    private static final XMLClassDescriptor STRING_DESCRIPTOR = new StringClassDescriptor();
    private static final XMLClassDescriptor DATE_DESCRIPTOR = new DateClassDescriptor();
    private static final XMLClassDescriptor LOCALE_DESCRIPTOR = new LocaleDescriptor();
    private static final XMLClassDescriptor SQL_DATE_DESCRIPTOR = new SQLDateClassDescriptor();
    private static final XMLClassDescriptor SQL_TIME_DESCRIPTOR = new SQLTimeClassDescriptor();
    private static final XMLClassDescriptor SQL_TIMESTAMP_DESCRIPTOR = new SQLTimestampClassDescriptor();
    private static final XMLClassDescriptor VECTOR_DESCRIPTOR = new VectorClassDescriptor();
    private static XMLClassDescriptor LIST_DESCRIPTOR;
    private static Class LIST_CLASS;

    private CoreDescriptors() {
    }

    public static XMLClassDescriptor getDescriptor(Class clazz) {
        if (clazz == null) {
            return null;
        }
        if (clazz == String.class) {
            return STRING_DESCRIPTOR;
        }
        if (clazz == Date.class) {
            return DATE_DESCRIPTOR;
        }
        if (Enumeration.class.isAssignableFrom(clazz)) {
            return ENUMERATION_DESCRIPTOR;
        }
        if (clazz == Vector.class || Vector.class.isAssignableFrom(clazz)) {
            return VECTOR_DESCRIPTOR;
        }
        if (LIST_DESCRIPTOR != null && (LIST_CLASS == clazz || LIST_CLASS.isAssignableFrom(clazz))) {
            return LIST_DESCRIPTOR;
        }
        if (clazz == Locale.class) {
            return LOCALE_DESCRIPTOR;
        }
        if (clazz == java.sql.Date.class) {
            return SQL_DATE_DESCRIPTOR;
        }
        if (clazz == Time.class) {
            return SQL_TIME_DESCRIPTOR;
        }
        if (clazz == Timestamp.class) {
            return SQL_TIMESTAMP_DESCRIPTOR;
        }
        return null;
    }

    private static void loadDescriptors() {
        ClassLoader loader = null;
        try {
            loader = Vector.class.getClassLoader();
            LIST_CLASS = loader == null ? Class.forName(LIST_CLASS_NAME) : loader.loadClass(LIST_CLASS_NAME);
        }
        catch (ClassNotFoundException cnfe) {
            // empty catch block
        }
        if (LIST_CLASS != null) {
            loader = CoreDescriptors.class.getClassLoader();
            Class<?> descriptorClass = null;
            try {
                descriptorClass = loader == null ? Class.forName(LIST_DESCRIPTOR_NAME) : loader.loadClass(LIST_DESCRIPTOR_NAME);
            }
            catch (ClassNotFoundException cnfe) {
                // empty catch block
            }
            if (descriptorClass != null) {
                try {
                    LIST_DESCRIPTOR = (XMLClassDescriptor)descriptorClass.newInstance();
                }
                catch (InstantiationException ie) {
                }
                catch (IllegalAccessException illegalAccessException) {}
            } else {
                LIST_DESCRIPTOR = null;
            }
        } else {
            LIST_DESCRIPTOR = null;
        }
    }

    static {
        CoreDescriptors.loadDescriptors();
    }
}

