/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.myfaces.el.unified;

import javax.faces.el.EvaluationException;
import javax.faces.el.PropertyNotFoundException;
import javax.faces.el.PropertyResolver;

/**
 * @author Mathias Broekelmann (latest modification by $Author: slessard $)
 * @version $Revision: 699848 $ $Date: 2008-09-28 16:12:21 +0000 (Sun, 28 Sep 2008) $
 */
@SuppressWarnings("deprecation")
public class NoOpPropertyResolver extends PropertyResolver
{

    @SuppressWarnings("unchecked")
    @Override
    public Class getType(Object base, int index) throws EvaluationException, PropertyNotFoundException
    {
        return null;
    }

    @SuppressWarnings("unchecked")
    @Override
    public Class getType(Object base, Object property) throws EvaluationException, PropertyNotFoundException
    {
        return null;
    }

    @Override
    public Object getValue(Object base, int index) throws EvaluationException, PropertyNotFoundException
    {
        return null;
    }

    @Override
    public Object getValue(Object base, Object property) throws EvaluationException, PropertyNotFoundException
    {
        return null;
    }

    @Override
    public boolean isReadOnly(Object base, int index) throws EvaluationException, PropertyNotFoundException
    {
        return false;
    }

    @Override
    public boolean isReadOnly(Object base, Object property) throws EvaluationException, PropertyNotFoundException
    {
        return false;
    }

    @Override
    public void setValue(Object base, int index, Object value) throws EvaluationException, PropertyNotFoundException
    {
    }

    @Override
    public void setValue(Object base, Object property, Object value) throws EvaluationException,
            PropertyNotFoundException
    {
    }

}
