# Licensed to the Apache Software Foundation (ASF) under one
# or more contributor license agreements.  See the NOTICE file
# distributed with this work for additional information
# regarding copyright ownership.  The ASF licenses this file
# to you under the Apache License, Version 2.0 (the
# "License"); you may not use this file except in compliance
# with the License.  You may obtain a copy of the License at
#
#   http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing,
# software distributed under the License is distributed on an
# "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
# KIND, either express or implied.  See the License for the
# specific language governing permissions and limitations
# under the License.

# This file is automatically generated by pyo3_stub_gen
# ruff: noqa: E501, F401

import builtins
import collections.abc
import types
import typing

import typing_extensions

@typing.final
class AsyncFile:
    r"""
    An async file-like object for reading and writing data.

    Created by the `open` method of the `AsyncOperator` class.
    """

    @property
    def closed(self) -> collections.abc.Awaitable[builtins.bool]:
        r"""
        Whether this file is closed.

        Returns
        -------
        coroutine
            An awaitable that returns True if this file is closed.
        """
    def read(
        self, size: builtins.int | None = None
    ) -> collections.abc.Awaitable[builtins.bytes]:
        r"""
        Read at most `size` bytes from this file asynchronously.

        If `size` is not specified, read until EOF.

        Parameters
        ----------
        size : int, optional
            The maximum number of bytes to read.

        Notes
        -----
        Fewer bytes may be returned than requested, read in a loop
        to ensure all bytes are read.

        Returns
        -------
        coroutine
            An awaitable that returns the bytes read from the stream.
        """
    def write(self, bs: builtins.bytes) -> collections.abc.Awaitable[builtins.int]:
        r"""
        Write bytes to this file asynchronously.

        Parameters
        ----------
        bs : bytes
            The bytes to write to the file.

        Returns
        -------
        coroutine
            An awaitable that returns the number of bytes written.
        """
    def seek(
        self, pos: builtins.int, whence: builtins.int = 0
    ) -> collections.abc.Awaitable[builtins.int]:
        r"""
        Change the position of this file to the given byte offset.

        Parameters
        ----------
        pos : int
            The byte offset (position) to set.
        whence : int, optional
            The reference point for the offset.
            0: start of file (default); 1: current position; 2: end of file.

        Returns
        -------
        coroutine
            An awaitable that returns the current absolute position.
        """
    def tell(self) -> collections.abc.Awaitable[builtins.int]:
        r"""
        Return the current position of this file.

        Returns
        -------
        coroutine
            An awaitable that returns the current absolute position.
        """
    def close(self) -> collections.abc.Awaitable[None]:
        r"""
        Close this file.

        This also flushes write buffers, if applicable.

        Notes
        -----
        A closed file cannot be used for further I/O operations.
        """
    def __aenter__(self) -> typing_extensions.Self: ...
    def __aexit__(
        self,
        exc_type: type[builtins.BaseException] | None,
        exc_value: builtins.BaseException | None,
        traceback: types.TracebackType | None,
    ) -> None: ...
    def readable(self) -> collections.abc.Awaitable[builtins.bool]:
        r"""
        Whether this file can be read from.

        Returns
        -------
        coroutine
            An awaitable that returns True if this file can be read from.
        """
    def writable(self) -> collections.abc.Awaitable[builtins.bool]:
        r"""
        Whether this file can be written to.

        Returns
        -------
        coroutine
            An awaitable that returns True if this file can be written to.
        """
    def seekable(self) -> collections.abc.Awaitable[builtins.bool]:
        r"""
        Whether this file can be repositioned.

        Notes
        -----
        This is only applicable to *readable* files.

        Returns
        -------
        coroutine
            An awaitable that returns True if this file can be repositioned.
        """

@typing.final
class File:
    r"""
    A file-like object for reading and writing data.

    Created by the `open` method of the `Operator` class.
    """

    @property
    def closed(self) -> builtins.bool:
        r"""
        Whether this file is closed.

        Returns
        -------
        bool
            True if this file is closed.
        """
    def read(self, size: builtins.int | None = None) -> builtins.bytes:
        r"""
        Read at most `size` bytes from this file.

        If `size` is not specified, read until EOF.

        Parameters
        ----------
        size : int, optional
            The maximum number of bytes to read.

        Notes
        -----
        Fewer bytes may be returned than requested, read in a loop
        to ensure all bytes are read.

        Returns
        -------
        bytes
            The bytes read from this file.
        """
    def readline(self, size: builtins.int | None = None) -> builtins.bytes:
        r"""
        Read one line from this file.

        If `size` is not specified, read until newline.

        Parameters
        ----------
        size : int, optional
            The maximum number of bytes to read.

        Notes
        -----
        Retains newline characters after each line, unless
        the file’s last line has no terminating newline.

        Returns
        -------
        bytes
            The bytes read from this file.
        """
    def readinto(self, buffer: builtins.bytes | builtins.bytearray) -> builtins.int:
        r"""
        Read bytes into a pre-allocated buffer.

        Parameters
        ----------
        buffer : bytes | bytearray
            A writable, pre-allocated buffer to read into.

        Returns
        -------
        int
            The number of bytes read.
        """
    def write(self, bs: builtins.bytes) -> builtins.int:
        r"""
        Write bytes to this file.

        Parameters
        ----------
        bs : bytes
            The bytes to write to the file.

        Returns
        -------
        int
            The number of bytes written.
        """
    def seek(self, pos: builtins.int, whence: builtins.int = 0) -> builtins.int:
        r"""
        Change the position of this file to the given byte offset.

        Parameters
        ----------
        pos : int
            The byte offset (position) to set.
        whence : int, optional
            The reference point for the offset.
            0: start of file (default); 1: current position; 2: end of file.

        Returns
        -------
        int
            The new absolute position.
        """
    def tell(self) -> builtins.int:
        r"""
        Return the current position of this file.

        Returns
        -------
        int
            The current absolute position.
        """
    def close(self) -> None:
        r"""
        Close this file.

        This also flushes write buffers, if applicable.

        Notes
        -----
        A closed file cannot be used for further I/O operations.
        """
    def __enter__(self, slf: File) -> File: ...
    def __exit__(
        self,
        exc_type: type[builtins.BaseException] | None,
        exc_value: builtins.BaseException | None,
        traceback: types.TracebackType | None,
    ) -> None: ...
    def flush(self) -> None:
        r"""
        Flush the underlying writer.

        Notes
        -----
        Is a no-op if the file is not `writable`.
        """
    def readable(self) -> builtins.bool:
        r"""
        Whether this file can be read from.

        Returns
        -------
        bool
            True if this file can be read from.
        """
    def writable(self) -> builtins.bool:
        r"""
        Whether this file can be written to.

        Returns
        -------
        bool
            True if this file can be written to.
        """
    def seekable(self) -> builtins.bool:
        r"""
        Whether this file can be repositioned.

        Notes
        -----
        This is only applicable to *readable* files.

        Returns
        -------
        bool
            True if this file can be repositioned.
        """
