/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.metrics.core.meter.invocation;

import com.netflix.spectator.api.Id;
import com.netflix.spectator.api.Measurement;
import com.netflix.spectator.api.Registry;
import java.util.List;
import org.apache.servicecomb.core.event.InvocationFinishEvent;
import org.apache.servicecomb.core.invocation.InvocationStageTrace;
import org.apache.servicecomb.foundation.metrics.meter.SimpleTimer;
import org.apache.servicecomb.metrics.core.meter.invocation.AbstractInvocationMeter;

public class ProducerInvocationMeter
extends AbstractInvocationMeter {
    private SimpleTimer executorQueueTimer = this.createStageTimer("queue");
    private SimpleTimer executionTimer = this.createStageTimer("execution");
    private SimpleTimer serverFiltersRequestTimer = this.createStageTimer("server_filters_request");
    private SimpleTimer serverFiltersResponseTimer = this.createStageTimer("server_filters_response");
    private SimpleTimer sendResponseTimer = this.createStageTimer("producer_send_response");

    public ProducerInvocationMeter(Registry registry, Id id) {
        super(registry, id);
    }

    @Override
    public void onInvocationFinish(InvocationFinishEvent event) {
        super.onInvocationFinish(event);
        InvocationStageTrace invocationStageTrace = event.getInvocation().getInvocationStageTrace();
        this.executorQueueTimer.record((long)invocationStageTrace.calcThreadPoolQueueTime());
        this.executionTimer.record((long)invocationStageTrace.calcBusinessTime());
        this.serverFiltersRequestTimer.record((long)invocationStageTrace.calcServerFiltersRequestTime());
        this.serverFiltersResponseTimer.record((long)invocationStageTrace.calcServerFiltersResponseTime());
        this.sendResponseTimer.record((long)invocationStageTrace.calcSendResponseTime());
    }

    @Override
    public void calcMeasurements(List<Measurement> measurements, long msNow, long secondInterval) {
        super.calcMeasurements(measurements, msNow, secondInterval);
        this.executorQueueTimer.calcMeasurements(measurements, msNow, secondInterval);
        this.executionTimer.calcMeasurements(measurements, msNow, secondInterval);
        this.serverFiltersRequestTimer.calcMeasurements(measurements, msNow, secondInterval);
        this.serverFiltersResponseTimer.calcMeasurements(measurements, msNow, secondInterval);
        this.sendResponseTimer.calcMeasurements(measurements, msNow, secondInterval);
    }
}

