/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.core.definition;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import javax.ws.rs.core.Response;
import org.apache.servicecomb.swagger.invocation.arguments.ArgumentsMapper;
import org.apache.servicecomb.swagger.invocation.response.ResponsesMeta;

public class InvocationRuntimeType {
    private Class<?> associatedClass;
    private Method associatedMethod;
    private final ResponsesMeta responsesMeta;
    private ArgumentsMapper argumentsMapper;

    public InvocationRuntimeType(Class<?> associatedClass, Method associatedMethod, ResponsesMeta responsesMeta, ArgumentsMapper argumentsMapper) {
        this.associatedClass = associatedClass;
        this.associatedMethod = associatedMethod;
        this.argumentsMapper = argumentsMapper;
        this.responsesMeta = responsesMeta;
    }

    public InvocationRuntimeType(ResponsesMeta responsesMeta) {
        this.responsesMeta = responsesMeta;
    }

    public Class<?> getAssociatedClass() {
        return this.associatedClass;
    }

    public Method getAssociatedMethod() {
        return this.associatedMethod;
    }

    public ArgumentsMapper getArgumentsMapper() {
        return this.argumentsMapper;
    }

    public JavaType findResponseType(int statusCode) {
        return this.responsesMeta.findResponseType(statusCode);
    }

    public void setSuccessResponseType(JavaType javaType) {
        if (javaType != null) {
            this.responsesMeta.setResponseType(Response.Status.OK.getStatusCode(), javaType);
        }
    }

    public void setSuccessResponseType(Type type) {
        if (type != null) {
            this.responsesMeta.setResponseType(Response.Status.OK.getStatusCode(), TypeFactory.defaultInstance().constructType(type));
        }
    }

    public void setAssociatedClass(Class<?> associatedClass) {
        this.associatedClass = associatedClass;
    }

    public void setAssociatedMethod(Method associatedMethod) {
        this.associatedMethod = associatedMethod;
    }

    public void setArgumentsMapper(ArgumentsMapper argumentsMapper) {
        this.argumentsMapper = argumentsMapper;
    }

    public boolean isRawConsumer() {
        return this.associatedClass == null;
    }
}

