/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.io.impl.felix.utils.version;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class VersionCleaner {
    private static final Pattern FUZZY_VERSION = Pattern.compile("(\\d+)(\\.(\\d+)(\\.(\\d+))?)?([^a-zA-Z0-9](.*))?", 32);

    private VersionCleaner() {
    }

    public static String clean(String version) {
        if (version == null || version.length() == 0) {
            return "0.0.0";
        }
        String clean = VersionCleaner.fastSyntax(version);
        if (clean != null) {
            return clean;
        }
        StringBuffer result = new StringBuffer();
        Matcher m = FUZZY_VERSION.matcher(version);
        if (m.matches()) {
            String major = m.group(1);
            String minor = m.group(3);
            String micro = m.group(5);
            String qualifier = m.group(7);
            if (major != null) {
                result.append(major);
                if (minor != null) {
                    result.append(".");
                    result.append(minor);
                    if (micro != null) {
                        result.append(".");
                        result.append(micro);
                        if (qualifier != null) {
                            result.append(".");
                            VersionCleaner.cleanupModifier(result, qualifier);
                        }
                    } else if (qualifier != null) {
                        result.append(".0.");
                        VersionCleaner.cleanupModifier(result, qualifier);
                    } else {
                        result.append(".0");
                    }
                } else if (qualifier != null) {
                    result.append(".0.0.");
                    VersionCleaner.cleanupModifier(result, qualifier);
                } else {
                    result.append(".0.0");
                }
            }
        } else {
            result.append("0.0.0.");
            VersionCleaner.cleanupModifier(result, version);
        }
        return result.toString();
    }

    private static void cleanupModifier(StringBuffer result, String modifier) {
        for (int i = 0; i < modifier.length(); ++i) {
            char c = modifier.charAt(i);
            if (c >= '0' && c <= '9' || c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == '_' || c == '-') {
                result.append(c);
                continue;
            }
            result.append('_');
        }
    }

    private static String fastSyntax(String version) {
        int state = 0;
        int l = version.length();
        block9: for (int i = 0; i < l; ++i) {
            char ch = version.charAt(i);
            switch (state) {
                case 0: 
                case 2: 
                case 4: {
                    if (ch < '0' || ch > '9') {
                        return null;
                    }
                    ++state;
                    continue block9;
                }
                case 1: 
                case 3: 
                case 5: {
                    if (ch == '.') {
                        ++state;
                        continue block9;
                    }
                    if (ch >= '0' && ch <= '9') continue block9;
                    return null;
                }
                case 6: {
                    if (ch != '.') continue block9;
                    return null;
                }
            }
        }
        switch (state) {
            case 0: 
            case 1: {
                return version + ".0.0";
            }
            case 2: 
            case 3: {
                return version + ".0";
            }
        }
        return version;
    }
}

