/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.io.json;

import java.io.IOException;
import java.io.Writer;
import java.util.List;
import javax.json.stream.JsonGenerator;
import org.apache.sling.feature.Configuration;
import org.apache.sling.feature.Configurations;
import org.apache.sling.feature.Extension;
import org.apache.sling.feature.Feature;
import org.apache.sling.feature.io.json.JSONWriterBase;

public class FeatureJSONWriter
extends JSONWriterBase {
    public static void write(Writer writer, Feature feature) throws IOException {
        FeatureJSONWriter w = new FeatureJSONWriter();
        w.writeFeature(writer, feature);
    }

    protected FeatureJSONWriter() {
    }

    protected void writeFeature(Writer writer, Feature feature) throws IOException {
        JsonGenerator generator = this.newGenerator(writer);
        generator.writeStartObject();
        this.writeFeatureId(generator, feature);
        if (feature.isFinal()) {
            generator.write("final", true);
        }
        if (feature.isComplete()) {
            generator.write("complete", true);
        }
        this.writeProperty(generator, "title", feature.getTitle());
        this.writeProperty(generator, "description", feature.getDescription());
        this.writeProperty(generator, "vendor", feature.getVendor());
        this.writeProperty(generator, "license", feature.getLicense());
        this.writeVariables(generator, feature.getVariables());
        this.writePrototype(generator, feature.getPrototype());
        this.writeRequirements(generator, feature.getRequirements());
        this.writeCapabilities(generator, feature.getCapabilities());
        this.writeBundles(generator, feature.getBundles(), feature.getConfigurations());
        Configurations cfgs = new Configurations();
        for (Configuration cfg : feature.getConfigurations()) {
            String artifactProp = (String)cfg.getProperties().get(":configurator:feature:service.bundleLocation");
            if (artifactProp != null) continue;
            cfgs.add((Object)cfg);
        }
        this.writeConfigurations(generator, cfgs);
        this.writeFrameworkProperties(generator, feature.getFrameworkProperties());
        this.writeExtensions(generator, (List<Extension>)feature.getExtensions(), feature.getConfigurations());
        generator.writeEnd().close();
    }

    protected void writeFeatureId(JsonGenerator generator, Feature feature) {
        this.writeProperty(generator, "id", feature.getId().toMvnId());
    }
}

