/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.security.user;

import java.util.Collections;
import java.util.Set;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.jackrabbit.commons.predicate.Predicate;
import org.apache.jackrabbit.core.NodeImpl;
import org.apache.jackrabbit.core.nodetype.NodeTypeImpl;
import org.apache.jackrabbit.core.security.user.UserConstants;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.Path;
import org.apache.jackrabbit.spi.commons.conversion.NamePathResolver;
import org.apache.jackrabbit.util.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class NodeResolver {
    private static Logger log = LoggerFactory.getLogger(NodeResolver.class);
    private final Session session;
    private final NamePathResolver resolver;
    private String userSearchRoot = "/rep:security/rep:authorizables/rep:users";
    private String groupSearchRoot = "/rep:security/rep:authorizables/rep:groups";
    private String authorizableSearchRoot = "/rep:security/rep:authorizables";

    NodeResolver(Session session, NamePathResolver resolver) {
        this.session = session;
        this.resolver = resolver;
    }

    void setSearchRoots(String userSearchRoot, String groupSearchRoot) {
        this.userSearchRoot = userSearchRoot;
        this.groupSearchRoot = groupSearchRoot;
        this.authorizableSearchRoot = userSearchRoot;
        while (!Text.isDescendant((String)this.authorizableSearchRoot, (String)groupSearchRoot)) {
            this.authorizableSearchRoot = Text.getRelativeParent((String)this.authorizableSearchRoot, (int)1);
        }
    }

    public abstract Node findNode(Name var1, Name var2) throws RepositoryException;

    public abstract Node findNode(Name var1, String var2, Name var3) throws RepositoryException;

    public NodeIterator findNodes(Name propertyName, String value, Name ntName, boolean exact) throws RepositoryException {
        return this.findNodes(Collections.singleton(propertyName), value, ntName, exact, Long.MAX_VALUE);
    }

    public abstract NodeIterator findNodes(Set<Name> var1, String var2, Name var3, boolean var4, long var5) throws RepositoryException;

    public abstract NodeIterator findNodes(Path var1, String var2, int var3, boolean var4, long var5) throws RepositoryException;

    Session getSession() {
        return this.session;
    }

    NamePathResolver getNamePathResolver() {
        return this.resolver;
    }

    String getSearchRoot(Name ntName) {
        String searchRoot = UserConstants.NT_REP_USER.equals(ntName) ? this.userSearchRoot : (UserConstants.NT_REP_GROUP.equals(ntName) ? this.groupSearchRoot : this.authorizableSearchRoot);
        return searchRoot;
    }

    String getSearchRoot(int authorizableType) {
        switch (authorizableType) {
            case 1: {
                return this.userSearchRoot;
            }
            case 2: {
                return this.groupSearchRoot;
            }
        }
        return this.authorizableSearchRoot;
    }

    AuthorizableTypePredicate getAuthorizableTypePredicate(int authorizableType, boolean exact) {
        return new AuthorizableTypePredicate(authorizableType, exact);
    }

    static class AuthorizableTypePredicate
    implements Predicate {
        private final int authorizableType;
        private final boolean exact;

        private AuthorizableTypePredicate(int authorizableType, boolean exact) {
            this.authorizableType = authorizableType;
            this.exact = exact;
        }

        public boolean evaluate(Object object) {
            if (object instanceof NodeImpl) {
                Node n = this.getAuthorizableNode((NodeImpl)object);
                return n != null;
            }
            return false;
        }

        Node getAuthorizableNode(NodeImpl n) {
            try {
                if (this.matches(n)) {
                    return n;
                }
                if (!this.exact) {
                    while (n.getDepth() > 0) {
                        if (!this.matches(n = (NodeImpl)n.getParent())) continue;
                        return n;
                    }
                }
            }
            catch (RepositoryException e) {
                log.debug(e.getMessage());
            }
            return null;
        }

        private boolean matches(NodeImpl result) throws RepositoryException {
            Name ntName = ((NodeTypeImpl)result.getPrimaryNodeType()).getQName();
            switch (this.authorizableType) {
                case 2: {
                    return UserConstants.NT_REP_GROUP.equals(ntName);
                }
                case 1: {
                    return UserConstants.NT_REP_USER.equals(ntName);
                }
            }
            return UserConstants.NT_REP_USER.equals(ntName) || UserConstants.NT_REP_GROUP.equals(ntName);
        }
    }
}

