/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.models.impl;

import java.util.Map;
import java.util.function.IntSupplier;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingJakartaHttpServletRequest;
import org.apache.sling.api.adapter.AdapterManager;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.models.annotations.Exporter;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.export.spi.ModelExporter;
import org.apache.sling.models.factory.ExportException;
import org.apache.sling.models.factory.MissingExporterException;
import org.apache.sling.models.factory.ModelClassException;
import org.apache.sling.models.impl.ModelAdapterFactory;
import org.apache.sling.models.testutil.ModelAdapterFactoryUtil;
import org.apache.sling.scripting.api.BindingsValuesProvidersByContext;
import org.apache.sling.testing.mock.osgi.junit.OsgiContext;
import org.apache.sling.testing.mock.osgi.junit5.OsgiContextExtension;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={OsgiContextExtension.class, MockitoExtension.class})
class ModelAdapterFactoryTest {
    final OsgiContext context = new OsgiContext();
    @Mock
    private AdapterManager adapterManager;
    @Mock
    private BindingsValuesProvidersByContext bindingsValuesProvidersByContext;
    @Mock
    private SlingJakartaHttpServletRequest jakartaRequest;
    @Deprecated(since="2.0.0")
    @Mock
    private SlingHttpServletRequest javaxRequest;
    @Mock
    private Resource resource;
    @Mock
    private ResourceResolver resourceResolver;
    private ModelAdapterFactory factory;

    ModelAdapterFactoryTest() {
    }

    @BeforeEach
    void setUp() {
        Mockito.lenient().when((Object)this.resourceResolver.getSearchPath()).thenReturn((Object)new String[]{"/apps/", "/libs/"});
        this.context.registerService(BindingsValuesProvidersByContext.class, (Object)this.bindingsValuesProvidersByContext);
        this.context.registerService(AdapterManager.class, (Object)this.adapterManager);
        this.factory = (ModelAdapterFactory)this.context.registerInjectActivateService(ModelAdapterFactory.class);
        ModelAdapterFactoryUtil.addModelsForPackage(this.context.bundleContext(), JakartaModel1.class, JavaxModel2.class);
        Mockito.lenient().when((Object)this.resource.getResourceType()).thenReturn((Object)"nt:unstructured");
        Mockito.lenient().when((Object)this.resource.getResourceResolver()).thenReturn((Object)this.resourceResolver);
        Mockito.lenient().when((Object)this.jakartaRequest.getResource()).thenReturn((Object)this.resource);
        Mockito.lenient().when((Object)this.javaxRequest.getResource()).thenReturn((Object)this.resource);
    }

    protected void registerModel(Class<?> adaptableType, Class<?> clazz) {
        this.factory.adapterImplementations.registerModelToResourceType(this.context.bundleContext().getBundle(), "nt:unstructured", adaptableType, clazz);
    }

    @Deprecated(since="2.0.0")
    @Test
    void testCreateModelFromWrappedRequestSlingHttpServletRequestResourceClassOfT() {
        Assertions.assertNotNull((Object)this.factory.createModelFromWrappedRequest(this.javaxRequest, this.resource, JavaxModel2.class));
    }

    @Test
    void testCreateModelFromWrappedRequestSlingJakartaHttpServletRequestResourceClassOfT() {
        Assertions.assertNotNull((Object)this.factory.createModelFromWrappedRequest(this.jakartaRequest, this.resource, JakartaModel1.class));
    }

    @Deprecated(since="2.0.0")
    @Test
    void testIsModelClassObjectClassOfQ() {
        Assertions.assertTrue((boolean)this.factory.isModelClass((Object)this.jakartaRequest, JakartaModel1.class));
        Assertions.assertTrue((boolean)this.factory.isModelClass((Object)this.jakartaRequest, JavaxModel2.class));
        Assertions.assertFalse((boolean)this.factory.isModelClass((Object)this.jakartaRequest, Object.class));
    }

    @Test
    void testIsModelClassClassOfQ() {
        Assertions.assertTrue((boolean)this.factory.isModelClass(JakartaModel1.class));
        Assertions.assertTrue((boolean)this.factory.isModelClass(JavaxModel2.class));
        Assertions.assertFalse((boolean)this.factory.isModelClass(Object.class));
    }

    @Deprecated(since="2.0.0")
    @Test
    void testIsModelAvailableForRequestSlingHttpServletRequest() {
        Assertions.assertFalse((boolean)this.factory.isModelAvailableForRequest(this.javaxRequest));
        this.registerModel(SlingHttpServletRequest.class, JavaxModel2.class);
        Assertions.assertTrue((boolean)this.factory.isModelAvailableForRequest(this.javaxRequest));
    }

    @Test
    void testIsModelAvailableForRequestSlingJakartaHttpServletRequest() {
        Assertions.assertFalse((boolean)this.factory.isModelAvailableForRequest(this.jakartaRequest));
        this.registerModel(SlingJakartaHttpServletRequest.class, JakartaModel1.class);
        Assertions.assertTrue((boolean)this.factory.isModelAvailableForRequest(this.jakartaRequest));
    }

    @Test
    void testGetModelFromResource() {
        Assertions.assertThrows(ModelClassException.class, () -> this.factory.getModelFromResource(this.resource));
        this.registerModel(Resource.class, JakartaModel1.class);
        Object modelFromResource = this.factory.getModelFromResource(this.resource);
        Assertions.assertTrue((boolean)(modelFromResource instanceof JakartaModel1));
    }

    @Deprecated(since="2.0.0")
    @Test
    void testGetModelFromRequestSlingHttpServletRequest() {
        Assertions.assertThrows(ModelClassException.class, () -> this.factory.getModelFromRequest(this.javaxRequest));
        this.registerModel(SlingHttpServletRequest.class, JavaxModel2.class);
        Object modelFromRequest = this.factory.getModelFromRequest(this.javaxRequest);
        Assertions.assertTrue((boolean)(modelFromRequest instanceof JavaxModel2));
    }

    @Test
    void testGetModelFromRequestSlingJakartaHttpServletRequest() {
        Assertions.assertThrows(ModelClassException.class, () -> this.factory.getModelFromRequest(this.jakartaRequest));
        this.registerModel(SlingJakartaHttpServletRequest.class, JakartaModel1.class);
        Object modelFromRequest = this.factory.getModelFromRequest(this.jakartaRequest);
        Assertions.assertTrue((boolean)(modelFromRequest instanceof JakartaModel1));
    }

    @Deprecated(since="2.0.0")
    @Test
    void testExportModelForRequestSlingHttpServletRequestStringClassOfTMapOfStringString() throws ExportException, MissingExporterException {
        Map options = Map.of();
        Assertions.assertThrows(ModelClassException.class, () -> this.factory.exportModelForRequest(this.javaxRequest, "exporter1", JavaxModel2.class, options));
        ModelExporter mockExporter = (ModelExporter)this.context.registerService(ModelExporter.class, (Object)((ModelExporter)Mockito.mock(ModelExporter.class)));
        Mockito.when((Object)mockExporter.getName()).thenReturn((Object)"exporter1");
        Mockito.when((Object)mockExporter.isSupported(JavaxModel2.class)).thenReturn((Object)true);
        Mockito.when((Object)mockExporter.export(ArgumentMatchers.any(), (Class)ArgumentMatchers.any(Class.class), ArgumentMatchers.anyMap())).thenAnswer(invocation -> invocation.getArgument(0, JavaxModel2.class));
        this.registerModel(SlingHttpServletRequest.class, JavaxModel2.class);
        JavaxModel2 exportModelForRequest = (JavaxModel2)this.factory.exportModelForRequest(this.javaxRequest, "exporter1", JavaxModel2.class, options);
        Assertions.assertNotNull((Object)exportModelForRequest);
    }

    @Test
    void testExportModelForRequestSlingJakartaHttpServletRequestStringClassOfTMapOfStringString() throws ExportException, MissingExporterException {
        Map options = Map.of();
        Assertions.assertThrows(ModelClassException.class, () -> this.factory.exportModelForRequest(this.jakartaRequest, "exporter1", JakartaModel1.class, options));
        ModelExporter mockExporter = (ModelExporter)this.context.registerService(ModelExporter.class, (Object)((ModelExporter)Mockito.mock(ModelExporter.class)));
        Mockito.when((Object)mockExporter.getName()).thenReturn((Object)"exporter1");
        Mockito.when((Object)mockExporter.isSupported(JakartaModel1.class)).thenReturn((Object)true);
        Mockito.when((Object)mockExporter.export(ArgumentMatchers.any(), (Class)ArgumentMatchers.any(Class.class), ArgumentMatchers.anyMap())).thenAnswer(invocation -> invocation.getArgument(0, JakartaModel1.class));
        this.registerModel(SlingJakartaHttpServletRequest.class, JakartaModel1.class);
        JakartaModel1 exportModelForRequest = (JakartaModel1)this.factory.exportModelForRequest(this.jakartaRequest, "exporter1", JakartaModel1.class, options);
        Assertions.assertNotNull((Object)exportModelForRequest);
    }

    @Deprecated(since="2.0.0")
    @Test
    void testGetModelFromWrappedRequestSlingHttpServletRequestResourceClassOfT() {
        JavaxModel2 modelFromWrappedRequest = (JavaxModel2)this.factory.getModelFromWrappedRequest(this.javaxRequest, this.resource, JavaxModel2.class);
        Assertions.assertNull((Object)modelFromWrappedRequest);
        JavaxModel2 target = new JavaxModel2();
        Mockito.when((Object)((JavaxModel2)this.adapterManager.getAdapter(ArgumentMatchers.any(SlingHttpServletRequest.class), (Class)ArgumentMatchers.eq(JavaxModel2.class)))).thenReturn((Object)target);
        this.registerModel(SlingHttpServletRequest.class, JavaxModel2.class);
        modelFromWrappedRequest = (JavaxModel2)this.factory.getModelFromWrappedRequest(this.javaxRequest, this.resource, JavaxModel2.class);
        Assertions.assertNotNull((Object)modelFromWrappedRequest);
    }

    @Test
    void testGetModelFromWrappedRequestSlingJakartaHttpServletRequestResourceClassOfT() {
        Assertions.assertNotNull((Object)this.factory.createModelFromWrappedRequest(this.jakartaRequest, this.resource, JakartaModel1.class));
        JakartaModel1 target = new JakartaModel1();
        Mockito.when((Object)((JakartaModel1)this.adapterManager.getAdapter(ArgumentMatchers.any(SlingJakartaHttpServletRequest.class), (Class)ArgumentMatchers.eq(JakartaModel1.class)))).thenReturn((Object)target);
        this.registerModel(SlingJakartaHttpServletRequest.class, JakartaModel1.class);
        JakartaModel1 modelFromWrappedRequest = (JakartaModel1)this.factory.getModelFromWrappedRequest(this.jakartaRequest, this.resource, JakartaModel1.class);
        Assertions.assertNotNull((Object)modelFromWrappedRequest);
    }

    @Model(adaptables={SlingJakartaHttpServletRequest.class, Resource.class}, cache=true)
    static final class JakartaModel1
    implements IntSupplier {
        JakartaModel1() {
        }

        @Override
        public int getAsInt() {
            return 1;
        }
    }

    @Deprecated(since="2.0.0")
    @Model(adaptables={SlingHttpServletRequest.class}, cache=true)
    @Exporter(name="exporter1", extensions={"json"})
    static final class JavaxModel2
    implements IntSupplier {
        JavaxModel2() {
        }

        @Override
        public int getAsInt() {
            return 2;
        }
    }
}

