/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.sightly.js.impl.loop;

import java.util.LinkedList;
import java.util.Queue;
import org.apache.sling.scripting.sightly.SightlyException;
import org.apache.sling.scripting.sightly.js.impl.loop.Task;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventLoop {
    private static final Logger log = LoggerFactory.getLogger(EventLoop.class);
    private Queue<Task> taskQueue = new LinkedList<Task>();
    private boolean isRunning;

    public void schedule(Task task) {
        this.taskQueue.offer(task);
        this.run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void run() {
        if (this.isRunning) {
            return;
        }
        this.isRunning = true;
        try {
            Exception thrownException = null;
            while (!this.taskQueue.isEmpty()) {
                Task task = this.taskQueue.poll();
                try {
                    task.run();
                }
                catch (Exception e) {
                    if (thrownException == null) {
                        thrownException = e;
                        continue;
                    }
                    log.error("Additional error occurred while running JS script: ", (Throwable)e);
                }
            }
            if (thrownException != null) {
                throw new SightlyException(thrownException);
            }
        }
        finally {
            this.isRunning = false;
        }
    }
}

