/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.validation.impl.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.sling.validation.model.ChildResource;
import org.apache.sling.validation.model.ResourceProperty;
import org.apache.sling.validation.model.ValidationModel;

public class ValidationModelImpl
implements ValidationModel {
    @Nonnull
    private final List<ResourceProperty> resourceProperties;
    @Nonnull
    private final String validatedResourceType;
    @Nonnull
    private final Collection<String> applicablePaths;
    @Nonnull
    private final List<ChildResource> children;
    @Nonnull
    private final String source;

    ValidationModelImpl(@Nonnull List<ResourceProperty> resourceProperties, @Nonnull String validatedResourceType, Collection<String> applicablePaths, @Nonnull List<ChildResource> children, @Nonnull String source) {
        this.resourceProperties = new ArrayList<ResourceProperty>(resourceProperties);
        this.validatedResourceType = validatedResourceType;
        if (resourceProperties.isEmpty() && children.isEmpty()) {
            throw new IllegalArgumentException("Neither children nor properties set in validation model for " + validatedResourceType + "'");
        }
        this.applicablePaths = applicablePaths.isEmpty() ? Collections.singletonList("") : new ArrayList<String>(applicablePaths);
        this.children = new ArrayList<ChildResource>(children);
        this.source = source;
    }

    @Nonnull
    public List<ResourceProperty> getResourceProperties() {
        return this.resourceProperties;
    }

    @Nonnull
    public String getValidatingResourceType() {
        return this.validatedResourceType;
    }

    @Nonnull
    public Collection<String> getApplicablePaths() {
        return this.applicablePaths;
    }

    @Nonnull
    public List<ChildResource> getChildren() {
        return this.children;
    }

    @Nonnull
    public String getSource() {
        return this.source;
    }

    public String toString() {
        return "ValidationModelImpl [resourceProperties=" + this.resourceProperties + ", validatedResourceType=" + this.validatedResourceType + ", applicablePaths=" + this.applicablePaths + ", children=" + this.children + ", source=" + this.source + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.applicablePaths == null ? 0 : this.applicablePaths.hashCode());
        result = 31 * result + (this.children == null ? 0 : this.children.hashCode());
        result = 31 * result + (this.resourceProperties == null ? 0 : this.resourceProperties.hashCode());
        result = 31 * result + (this.source == null ? 0 : this.source.hashCode());
        result = 31 * result + (this.validatedResourceType == null ? 0 : this.validatedResourceType.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ValidationModelImpl other = (ValidationModelImpl)obj;
        if (!this.applicablePaths.equals(other.applicablePaths)) {
            return false;
        }
        if (!this.children.equals(other.children)) {
            return false;
        }
        if (!this.resourceProperties.equals(other.resourceProperties)) {
            return false;
        }
        if (!this.source.equals(other.source)) {
            return false;
        }
        return this.validatedResourceType.equals(other.validatedResourceType);
    }
}

