/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.validation.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.ResourceBundle;
import javax.annotation.Nonnull;
import org.apache.sling.validation.ValidationFailure;
import org.apache.sling.validation.ValidationResult;
import org.apache.sling.validation.spi.support.DefaultValidationResult;

public class CompositeValidationResult
implements ValidationResult,
Serializable {
    private static final long serialVersionUID = -1019113908128276733L;
    @Nonnull
    private final List<ValidationResult> results = new ArrayList<ValidationResult>();

    public void addValidationResult(@Nonnull ValidationResult result) {
        this.results.add(result);
    }

    public void addFailure(@Nonnull String location, int severity, @Nonnull ResourceBundle defaultResourceBundle, @Nonnull String message, Object ... messageArguments) {
        this.results.add((ValidationResult)new DefaultValidationResult(location, severity, defaultResourceBundle, message, messageArguments));
    }

    public boolean isValid() {
        for (ValidationResult result : this.results) {
            if (result.isValid()) continue;
            return false;
        }
        return true;
    }

    @Nonnull
    public List<ValidationFailure> getFailures() {
        LinkedList<ValidationFailure> failures = new LinkedList<ValidationFailure>();
        for (ValidationResult result : this.results) {
            for (ValidationFailure failure : result.getFailures()) {
                failures.add(failure);
            }
        }
        return failures;
    }

    public String toString() {
        return "CompositeValidationResult [results=" + this.results + "]";
    }
}

