/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sisu.wire;

import com.google.inject.Binder;
import com.google.inject.Key;
import com.google.inject.Provider;
import com.google.inject.TypeLiteral;
import com.google.inject.name.Named;
import java.lang.annotation.Annotation;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.sisu.BeanEntry;
import org.eclipse.sisu.inject.BeanLocator;
import org.eclipse.sisu.inject.TypeArguments;
import org.eclipse.sisu.wire.EntryListAdapter;
import org.eclipse.sisu.wire.EntryMapAdapter;
import org.eclipse.sisu.wire.EntrySetAdapter;
import org.eclipse.sisu.wire.NamedIterableAdapter;
import org.eclipse.sisu.wire.PlaceholderBeanProvider;
import org.eclipse.sisu.wire.ProviderIterableAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class BeanProviders {
    final Provider<BeanLocator> locator;

    BeanProviders(Binder binder) {
        this.locator = binder.getProvider(BeanLocator.class);
    }

    public <K extends Annotation, V> Provider<Iterable<? extends BeanEntry<K, V>>> beanEntriesOf(final Key<V> key) {
        return new Provider<Iterable<? extends BeanEntry<K, V>>>(){

            @Override
            public Iterable<? extends BeanEntry<K, V>> get() {
                return BeanProviders.this.locator.get().locate(key);
            }
        };
    }

    public <K extends Annotation, V> Provider<Iterable<Map.Entry<K, V>>> entriesOf(Key key) {
        TypeLiteral type = key.getTypeLiteral();
        Class clazz = type.getRawType();
        if (javax.inject.Provider.class != clazz && Provider.class != clazz) {
            return this.beanEntriesOf(key);
        }
        final Provider<Iterable<BeanEntry<K, ?>>> beanEntries = this.beanEntriesOf(key.ofType(TypeArguments.get(type, 0)));
        return new Provider<Iterable<Map.Entry<K, V>>>(){

            @Override
            public Iterable<Map.Entry<K, V>> get() {
                return new ProviderIterableAdapter((Iterable)beanEntries.get());
            }
        };
    }

    public <K extends Annotation, V> Provider<List<V>> listOf(Key<V> key) {
        final Provider<Iterable<Map.Entry<K, V>>> entries = this.entriesOf(key);
        return new Provider<List<V>>(){

            @Override
            public List<V> get() {
                return new EntryListAdapter((Iterable)entries.get());
            }
        };
    }

    public <K extends Annotation, V> Provider<Set<V>> setOf(Key<V> key) {
        final Provider<Iterable<Map.Entry<K, V>>> entries = this.entriesOf(key);
        return new Provider<Set<V>>(){

            @Override
            public Set<V> get() {
                return new EntrySetAdapter((Iterable)entries.get());
            }
        };
    }

    public <K extends Annotation, V> Provider<Map<K, V>> mapOf(Key<V> key) {
        final Provider<Iterable<Map.Entry<K, V>>> entries = this.entriesOf(key);
        return new Provider<Map<K, V>>(){

            @Override
            public Map<K, V> get() {
                return new EntryMapAdapter((Iterable)entries.get());
            }
        };
    }

    public <V> Provider<Map<String, V>> stringMapOf(TypeLiteral<V> type) {
        final Provider entries = this.entriesOf(Key.get(type, Named.class));
        return new Provider<Map<String, V>>(){

            @Override
            public Map<String, V> get() {
                return new EntryMapAdapter(new NamedIterableAdapter((Iterable)entries.get()));
            }
        };
    }

    <V> Provider<V> firstOf(Key<V> key) {
        final Provider beanEntries = this.beanEntriesOf(key);
        return new Provider<V>(){

            @Override
            public V get() {
                return BeanProviders.firstOf((Iterable)beanEntries.get());
            }
        };
    }

    public <V> Provider<V> placeholderOf(Key<V> key) {
        return new PlaceholderBeanProvider<V>(this.locator, key);
    }

    public static <V> V firstOf(Iterable<? extends Map.Entry<?, V>> entries) {
        Iterator<Map.Entry<?, V>> itr = entries.iterator();
        return itr.hasNext() ? (V)itr.next().getValue() : null;
    }
}

