/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.portlet.dispatcher;

import com.opensymphony.xwork2.ActionContext;
import com.opensymphony.xwork2.ActionProxy;
import com.opensymphony.xwork2.ActionProxyFactory;
import com.opensymphony.xwork2.config.ConfigurationException;
import com.opensymphony.xwork2.inject.Container;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.GenericPortlet;
import javax.portlet.PortletConfig;
import javax.portlet.PortletException;
import javax.portlet.PortletMode;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.WindowState;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.LocaleUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.apache.struts2.StrutsException;
import org.apache.struts2.StrutsStatics;
import org.apache.struts2.dispatcher.AttributeMap;
import org.apache.struts2.dispatcher.Dispatcher;
import org.apache.struts2.dispatcher.HttpParameters;
import org.apache.struts2.dispatcher.mapper.ActionMapper;
import org.apache.struts2.dispatcher.mapper.ActionMapping;
import org.apache.struts2.dispatcher.multipart.MultiPartRequestWrapper;
import org.apache.struts2.portlet.PortletApplicationMap;
import org.apache.struts2.portlet.PortletConstants;
import org.apache.struts2.portlet.PortletPhase;
import org.apache.struts2.portlet.PortletRequestMap;
import org.apache.struts2.portlet.PortletSessionMap;
import org.apache.struts2.portlet.servlet.PortletServletContext;
import org.apache.struts2.portlet.servlet.PortletServletRequest;
import org.apache.struts2.portlet.servlet.PortletServletResponse;

public class Jsr168Dispatcher
extends GenericPortlet
implements StrutsStatics {
    private static final Logger LOG = LogManager.getLogger(Jsr168Dispatcher.class);
    protected String portletNamespace = null;
    private ActionProxyFactory factory = null;
    private Map<PortletMode, String> modeMap = new HashMap<PortletMode, String>(3);
    private Map<PortletMode, ActionMapping> actionMap = new HashMap<PortletMode, ActionMapping>(3);
    private Dispatcher dispatcherUtils;
    private ActionMapper actionMapper;
    private Container container;
    private ServletContext servletContext;

    public void init(PortletConfig cfg) throws PortletException {
        super.init(cfg);
        LOG.debug("Initializing portlet {}", (Object)this.getPortletName());
        HashMap<String, String> params = new HashMap<String, String>();
        Enumeration e = cfg.getInitParameterNames();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            String value = cfg.getInitParameter(name);
            params.put(name, value);
        }
        this.servletContext = new PortletServletContext(cfg.getPortletContext());
        this.dispatcherUtils = new Dispatcher(this.servletContext, params);
        this.dispatcherUtils.init();
        if (this.factory == null) {
            this.factory = this.dispatcherUtils.getActionProxyFactory();
        }
        this.portletNamespace = cfg.getInitParameter("portletNamespace");
        LOG.debug("PortletNamespace: {}", (Object)this.portletNamespace);
        this.parseModeConfig(this.actionMap, cfg, PortletMode.VIEW, "viewNamespace", "defaultViewAction");
        this.parseModeConfig(this.actionMap, cfg, PortletMode.EDIT, "editNamespace", "defaultEditAction");
        this.parseModeConfig(this.actionMap, cfg, PortletMode.HELP, "helpNamespace", "defaultHelpAction");
        this.parseModeConfig(this.actionMap, cfg, new PortletMode("config"), "configNamespace", "defaultConfigAction");
        this.parseModeConfig(this.actionMap, cfg, new PortletMode("about"), "aboutNamespace", "defaultAboutAction");
        this.parseModeConfig(this.actionMap, cfg, new PortletMode("print"), "printNamespace", "defaultPrintAction");
        this.parseModeConfig(this.actionMap, cfg, new PortletMode("preview"), "previewNamespace", "defaultPreviewAction");
        this.parseModeConfig(this.actionMap, cfg, new PortletMode("edit_defaults"), "editDefaultsNamespace", "defaultEditDefaultsAction");
        if (StringUtils.isEmpty((CharSequence)this.portletNamespace)) {
            this.portletNamespace = "";
        }
        this.container = this.dispatcherUtils.getContainer();
        this.actionMapper = (ActionMapper)this.container.getInstance(ActionMapper.class);
    }

    void parseModeConfig(Map<PortletMode, ActionMapping> actionMap, PortletConfig portletConfig, PortletMode portletMode, String nameSpaceParam, String defaultActionParam) {
        String namespace = portletConfig.getInitParameter(nameSpaceParam);
        if (StringUtils.isEmpty((CharSequence)namespace)) {
            namespace = "";
        }
        this.modeMap.put(portletMode, namespace);
        String defaultAction = portletConfig.getInitParameter(defaultActionParam);
        String method = null;
        if (StringUtils.isEmpty((CharSequence)defaultAction)) {
            defaultAction = PortletConstants.DEFAULT_ACTION_NAME;
        }
        if (defaultAction.indexOf(33) >= 0) {
            method = defaultAction.substring(defaultAction.indexOf(33) + 1);
            defaultAction = defaultAction.substring(0, defaultAction.indexOf(33));
        }
        StringBuilder fullPath = new StringBuilder();
        if (StringUtils.isNotEmpty((CharSequence)this.portletNamespace)) {
            fullPath.append(this.portletNamespace);
        }
        if (StringUtils.isNotEmpty((CharSequence)namespace)) {
            fullPath.append(namespace).append("/");
        } else {
            fullPath.append("/");
        }
        fullPath.append(defaultAction);
        ActionMapping mapping = new ActionMapping();
        mapping.setName(this.getActionName(fullPath.toString()));
        mapping.setNamespace(this.getNamespace(fullPath.toString()));
        if (method != null) {
            mapping.setMethod(method);
        }
        actionMap.put(portletMode, mapping);
    }

    public void processAction(ActionRequest request, ActionResponse response) throws PortletException, IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Entering processAction in mode ", (Object)request.getPortletMode().toString());
        }
        this.resetActionContext();
        try {
            this.serviceAction((PortletRequest)request, (PortletResponse)response, this.getRequestMap((PortletRequest)request), this.getParameterMap((PortletRequest)request), this.getSessionMap((PortletRequest)request), this.getApplicationMap(), this.portletNamespace, PortletPhase.ACTION_PHASE);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Leaving processAction");
            }
        }
        finally {
            ActionContext.clear();
        }
    }

    public void render(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Entering render in mode ", (Object)request.getPortletMode().toString());
        }
        this.resetActionContext();
        response.setTitle(this.getTitle(request));
        if (!request.getWindowState().equals((Object)WindowState.MINIMIZED)) {
            try {
                this.serviceAction((PortletRequest)request, (PortletResponse)response, this.getRequestMap((PortletRequest)request), this.getParameterMap((PortletRequest)request), this.getSessionMap((PortletRequest)request), this.getApplicationMap(), this.portletNamespace, PortletPhase.RENDER_PHASE);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Leaving render");
                }
            }
            finally {
                this.resetActionContext();
            }
        }
    }

    void resetActionContext() {
        ActionContext.clear();
    }

    public Map<String, Object> createContextMap(Map<String, Object> requestMap, Map<String, String[]> parameterMap, Map<String, Object> sessionMap, Map<String, Object> applicationMap, PortletRequest request, PortletResponse response, HttpServletRequest servletRequest, HttpServletResponse servletResponse, ServletContext servletContext, PortletConfig portletConfig, PortletPhase phase) throws IOException {
        this.container.inject((Object)servletRequest);
        Map extraContext = ActionContext.of(new HashMap()).withServletRequest(servletRequest).withServletResponse(servletResponse).withServletContext(servletContext).withParameters(HttpParameters.create(parameterMap).build()).withSession(sessionMap).withApplication(applicationMap).withLocale(this.getLocale(request)).with("struts.portlet.context", (Object)this.getPortletContext()).with(PortletConstants.REQUEST, (Object)request).with(PortletConstants.RESPONSE, (Object)response).with(PortletConstants.PORTLET_CONFIG, (Object)portletConfig).with(PortletConstants.PORTLET_NAMESPACE, (Object)this.portletNamespace).with(PortletConstants.DEFAULT_ACTION_FOR_MODE, (Object)this.actionMap.get(request.getPortletMode())).with("request", requestMap).with("session", sessionMap).with("application", applicationMap).with("parameters", parameterMap).with(PortletConstants.MODE_NAMESPACE_MAP, this.modeMap).with(PortletConstants.DEFAULT_ACTION_MAP, this.actionMap).with(PortletConstants.PHASE, (Object)phase).getContextMap();
        AttributeMap attrMap = new AttributeMap(extraContext);
        extraContext.put("attr", attrMap);
        return extraContext;
    }

    protected Locale getLocale(PortletRequest request) {
        Locale locale;
        String defaultLocale = (String)this.container.getInstance(String.class, "struts.locale");
        if (defaultLocale != null) {
            try {
                locale = LocaleUtils.toLocale((String)defaultLocale);
            }
            catch (IllegalArgumentException e) {
                LOG.warn((Message)new ParameterizedMessage("Cannot convert 'struts.locale' = [{}] to proper locale, defaulting to request locale [{}]", (Object)defaultLocale, (Object)request.getLocale()), (Throwable)e);
                locale = request.getLocale();
            }
        } else {
            locale = request.getLocale();
        }
        return locale;
    }

    public void serviceAction(PortletRequest request, PortletResponse response, Map<String, Object> requestMap, Map<String, String[]> parameterMap, Map<String, Object> sessionMap, Map<String, Object> applicationMap, String portletNamespace, PortletPhase phase) throws PortletException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("serviceAction");
        }
        Dispatcher.setInstance((Dispatcher)this.dispatcherUtils);
        String actionName = null;
        try {
            PortletServletRequest servletRequest = new PortletServletRequest(request, this.getPortletContext());
            PortletServletResponse servletResponse = this.createPortletServletResponse(response);
            if (phase.isAction() && (servletRequest = this.dispatcherUtils.wrapRequest((HttpServletRequest)servletRequest)) instanceof MultiPartRequestWrapper) {
                parameterMap.putAll(servletRequest.getParameterMap());
            }
            this.container.inject((Object)servletRequest);
            ActionMapping mapping = this.getActionMapping(request, servletRequest);
            actionName = mapping.getName();
            String namespace = "renderDirect".equals(actionName) ? request.getParameter(PortletConstants.RENDER_DIRECT_NAMESPACE) : mapping.getNamespace();
            Map<String, Object> extraContext = this.createContextMap(requestMap, parameterMap, sessionMap, applicationMap, request, response, servletRequest, servletResponse, this.servletContext, this.getPortletConfig(), phase);
            extraContext.put(PortletConstants.ACTION_MAPPING, mapping);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Creating action proxy for name = " + actionName + ", namespace = " + namespace);
            }
            ActionProxy proxy = this.factory.createActionProxy(namespace, actionName, mapping.getMethod(), extraContext);
            request.setAttribute("struts.valueStack", (Object)proxy.getInvocation().getStack());
            proxy.execute();
        }
        catch (ConfigurationException e) {
            if (LOG.isErrorEnabled()) {
                LOG.error("Could not find action", (Throwable)e);
            }
            throw new PortletException("Could not find action " + actionName, (Throwable)e);
        }
        catch (Exception e) {
            if (LOG.isErrorEnabled()) {
                LOG.error("Could not execute action", (Throwable)e);
            }
            throw new PortletException("Error executing action " + actionName, (Throwable)e);
        }
        finally {
            Dispatcher.clearInstance();
        }
    }

    protected Map<String, Object> getApplicationMap() {
        return new PortletApplicationMap(this.getPortletContext());
    }

    protected ActionMapping getActionMapping(PortletRequest portletRequest, HttpServletRequest servletRequest) {
        String actionPath = this.getDefaultActionPath(portletRequest);
        ActionMapping mapping = this.resetAction(portletRequest) ? this.actionMap.get(portletRequest.getPortletMode()) : (StringUtils.isEmpty((CharSequence)(actionPath = servletRequest.getParameter(PortletConstants.ACTION_PARAM))) ? this.actionMap.get(portletRequest.getPortletMode()) : this.actionMapper.getMapping(servletRequest, this.dispatcherUtils.getConfigurationManager()));
        if (mapping == null) {
            throw new StrutsException("Unable to locate action mapping for request, probably due to an invalid action path: " + actionPath);
        }
        return mapping;
    }

    protected String getDefaultActionPath(PortletRequest portletRequest) {
        return null;
    }

    String getNamespace(String actionPath) {
        int idx = actionPath.lastIndexOf(47);
        String namespace = "";
        if (idx >= 0) {
            namespace = actionPath.substring(0, idx);
        }
        return namespace;
    }

    String getActionName(String actionPath) {
        int idx = actionPath.lastIndexOf(47);
        String action = actionPath;
        if (idx >= 0) {
            action = actionPath.substring(idx + 1);
        }
        return action;
    }

    protected Map<String, String[]> getParameterMap(PortletRequest request) throws IOException {
        return new HashMap<String, String[]>(request.getParameterMap());
    }

    protected Map<String, Object> getRequestMap(PortletRequest request) {
        return new PortletRequestMap(request);
    }

    protected Map<String, Object> getSessionMap(PortletRequest request) {
        return new PortletSessionMap(request);
    }

    protected void setActionProxyFactory(ActionProxyFactory factory) {
        this.factory = factory;
    }

    private boolean resetAction(PortletRequest request) {
        boolean reset = false;
        Map paramMap = request.getParameterMap();
        String[] modeParam = (String[])paramMap.get(PortletConstants.MODE_PARAM);
        if (modeParam != null && modeParam.length == 1) {
            String originatingMode = modeParam[0];
            String currentMode = request.getPortletMode().toString();
            if (!currentMode.equals(originatingMode)) {
                reset = true;
            }
        }
        if (reset) {
            request.setAttribute(PortletConstants.ACTION_RESET, (Object)Boolean.TRUE);
        } else {
            request.setAttribute(PortletConstants.ACTION_RESET, (Object)Boolean.FALSE);
        }
        return reset;
    }

    public void destroy() {
        if (this.dispatcherUtils != null) {
            this.dispatcherUtils.cleanup();
        } else if (LOG.isWarnEnabled()) {
            LOG.warn("Something is seriously wrong, DispatcherUtil is not initialized (null) ");
        }
    }

    public void setActionMapper(ActionMapper actionMapper) {
        this.actionMapper = actionMapper;
    }

    protected PortletServletResponse createPortletServletResponse(PortletResponse response) {
        return new PortletServletResponse(response);
    }
}

