/*
 * Decompiled with CFR 0.152.
 */
package com.google.gxp.compiler.depend;

import com.google.gxp.com.google.common.collect.ImmutableMap;
import com.google.gxp.compiler.CompilationManager;
import com.google.gxp.compiler.CompilationSet;
import com.google.gxp.compiler.CompilationTask;
import com.google.gxp.compiler.CompilationUnit;
import com.google.gxp.compiler.base.Callable;
import com.google.gxp.compiler.base.TemplateName;
import com.google.gxp.compiler.depend.DependencyNode;
import java.util.Map;
import java.util.Set;

public class DependencyGraph
implements CompilationManager {
    private final Map<TemplateName.FullyQualified, DependencyNode> nodes;

    public DependencyGraph(CompilationSet cSet) {
        ImmutableMap.Builder<TemplateName.FullyQualified, DependencyNode> mapBuilder = ImmutableMap.builder();
        for (CompilationUnit unit : cSet.getCompilationUnits()) {
            Set<Callable> requirements = this.getRequirements(unit);
            TemplateName.FullyQualified name = unit.getTemplateName();
            DependencyNode node = new DependencyNode(name, DependencyGraph.getLastModified(unit), requirements);
            mapBuilder.put(name, node);
        }
        this.nodes = mapBuilder.build();
    }

    private Set<Callable> getRequirements(CompilationUnit unit) {
        return unit.getBoundTree().getRequirements();
    }

    private static long getLastModified(CompilationUnit unit) {
        return unit.getSourceFileRef().getLastModified();
    }

    @Override
    public boolean sourceChanged(CompilationTask task) {
        long oldTimestamp;
        CompilationUnit unit = task.getCompilationUnit();
        DependencyNode node = this.nodes.get(unit.getTemplateName());
        if (node != null && (oldTimestamp = node.getLastModified()) > 0L) {
            return oldTimestamp != DependencyGraph.getLastModified(unit);
        }
        return true;
    }

    @Override
    public boolean usedInterfacesChanged(CompilationTask task) {
        CompilationUnit unit = task.getCompilationUnit();
        DependencyNode node = this.nodes.get(unit.getTemplateName());
        if (node != null) {
            Set<Callable> oldRequirements = node.getRequirements();
            return !((Object)oldRequirements).equals(this.getRequirements(unit));
        }
        return true;
    }
}

