/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.web.servlet.assertj;

import java.lang.reflect.Method;
import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ClassAssert;
import org.assertj.core.api.ObjectAssert;
import org.springframework.cglib.core.internal.Function;
import org.springframework.lang.Nullable;
import org.springframework.test.util.MethodAssert;
import org.springframework.util.ClassUtils;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.mvc.method.annotation.MvcUriComponentsBuilder;

public class HandlerResultAssert
extends AbstractObjectAssert<HandlerResultAssert, Object> {
    public HandlerResultAssert(@Nullable Object actual) {
        super(actual, HandlerResultAssert.class);
        this.as("Handler result", new Object[0]);
    }

    public MethodAssert method() {
        return new MethodAssert(this.getHandlerMethod());
    }

    public HandlerResultAssert isMethodHandler() {
        return (HandlerResultAssert)((HandlerResultAssert)this.isNotNull()).isInstanceOf(HandlerMethod.class);
    }

    public <T> HandlerResultAssert isInvokedOn(Class<T> controllerType, Function<T, Object> handlerMethod) {
        MethodAssert actual = this.method();
        Object methodInvocationInfo = handlerMethod.apply(MvcUriComponentsBuilder.on(controllerType));
        ((ObjectAssert)Assertions.assertThat((Object)methodInvocationInfo).as("Method invocation on controller '%s'", new Object[]{controllerType.getSimpleName()})).isInstanceOfSatisfying(MvcUriComponentsBuilder.MethodInvocationInfo.class, mii -> actual.isEqualTo(mii.getControllerMethod()));
        return this;
    }

    public HandlerResultAssert hasType(Class<?> type) {
        this.isNotNull();
        Class actualType = this.actual.getClass();
        Object object = this.actual;
        if (object instanceof HandlerMethod) {
            HandlerMethod handlerMethod = (HandlerMethod)object;
            actualType = handlerMethod.getBeanType();
        }
        ((ClassAssert)Assertions.assertThat((Class)ClassUtils.getUserClass(actualType)).as("Handler result type", new Object[0])).isEqualTo(type);
        return this;
    }

    private Method getHandlerMethod() {
        this.isMethodHandler();
        return ((HandlerMethod)this.actual).getMethod();
    }
}

