/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.convention;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.struts2.ObjectFactory;
import org.apache.struts2.config.Configuration;
import org.apache.struts2.config.entities.InterceptorLocator;
import org.apache.struts2.config.entities.InterceptorMapping;
import org.apache.struts2.config.entities.PackageConfig;
import org.apache.struts2.config.providers.InterceptorBuilder;
import org.apache.struts2.convention.InterceptorMapBuilder;
import org.apache.struts2.convention.StringTools;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.InterceptorRef;
import org.apache.struts2.convention.annotation.InterceptorRefs;
import org.apache.struts2.inject.Inject;
import org.apache.struts2.util.AnnotationUtils;
import org.apache.struts2.util.location.Location;

public class DefaultInterceptorMapBuilder
implements InterceptorMapBuilder {
    private static final Logger LOG = LogManager.getLogger(DefaultInterceptorMapBuilder.class);
    private Configuration configuration;

    @Override
    public List<InterceptorMapping> build(Class<?> actionClass, PackageConfig.Builder builder, String actionName, Action annotation) {
        InterceptorRef[] interceptors;
        InterceptorRef interceptorRef;
        ArrayList<InterceptorMapping> interceptorList = new ArrayList<InterceptorMapping>(10);
        InterceptorRefs interceptorRefs = (InterceptorRefs)AnnotationUtils.findAnnotation(actionClass, InterceptorRefs.class);
        if (interceptorRefs != null) {
            interceptorList.addAll(this.build(interceptorRefs.value(), actionName, builder));
        }
        if ((interceptorRef = (InterceptorRef)AnnotationUtils.findAnnotation(actionClass, InterceptorRef.class)) != null) {
            interceptorList.addAll(this.build(new InterceptorRef[]{interceptorRef}, actionName, builder));
        }
        if (annotation != null && (interceptors = annotation.interceptorRefs()) != null) {
            interceptorList.addAll(this.build(interceptors, actionName, builder));
        }
        return interceptorList;
    }

    protected List<InterceptorMapping> build(InterceptorRef[] interceptors, String actionName, PackageConfig.Builder builder) {
        ArrayList<InterceptorMapping> interceptorList = new ArrayList<InterceptorMapping>(10);
        for (InterceptorRef interceptor : interceptors) {
            LOG.trace("Adding interceptor [{}] to [{}]", (Object)interceptor.value(), (Object)actionName);
            Map<String, String> params = StringTools.createParameterMap(interceptor.params());
            interceptorList.addAll(this.buildInterceptorList(builder, interceptor, params));
        }
        return interceptorList;
    }

    protected List<InterceptorMapping> buildInterceptorList(PackageConfig.Builder builder, InterceptorRef ref, Map params) {
        return InterceptorBuilder.constructInterceptorReference((InterceptorLocator)builder, (String)ref.value(), (Map)params, (Location)builder.build().getLocation(), (ObjectFactory)((ObjectFactory)this.configuration.getContainer().getInstance(ObjectFactory.class)));
    }

    @Inject
    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }
}

