/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.controlprogram.paramserv.rpc;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.controlprogram.caching.MatrixObject;
import org.apache.sysml.runtime.controlprogram.paramserv.ParamservUtils;
import org.apache.sysml.runtime.instructions.cp.Data;
import org.apache.sysml.runtime.instructions.cp.ListObject;
import org.apache.sysml.runtime.io.IOUtilFunctions;
import org.apache.sysml.runtime.matrix.data.MatrixBlock;

public abstract class PSRpcObject {
    public static final int PUSH = 1;
    public static final int PULL = 2;

    public abstract void deserialize(ByteBuffer var1) throws IOException;

    public abstract ByteBuffer serialize() throws IOException;

    protected void serializeAndWriteListObject(ListObject lo, DataOutput output) throws IOException {
        this.validateListObject(lo);
        output.writeInt(lo.getLength());
        output.writeBoolean(lo.isNamedList());
        for (int i = 0; i < lo.getLength(); ++i) {
            if (lo.isNamedList()) {
                output.writeUTF(lo.getName(i));
            }
            ((MatrixBlock)((MatrixObject)lo.getData().get(i)).acquireReadAndRelease()).write(output);
        }
        ParamservUtils.cleanupListObject(lo);
    }

    protected ListObject readAndDeserialize(DataInput input) throws IOException {
        int listLen = input.readInt();
        ArrayList<Data> data = new ArrayList<Data>();
        ArrayList<String> names = input.readBoolean() ? new ArrayList<String>() : null;
        for (int i = 0; i < listLen; ++i) {
            if (names != null) {
                names.add(input.readUTF());
            }
            MatrixBlock mb = new MatrixBlock();
            mb.readFields(input);
            data.add(ParamservUtils.newMatrixObject(mb, false));
        }
        return new ListObject(data, names);
    }

    protected int getExactSerializedSize(ListObject lo) {
        if (lo == null) {
            return 0;
        }
        long result = 5L;
        if (lo.isNamedList()) {
            result += lo.getNames().stream().mapToLong(s -> IOUtilFunctions.getUTFSize(s)).sum();
        }
        if ((result += lo.getData().stream().mapToLong(d -> ((MatrixBlock)((MatrixObject)d).acquireReadAndRelease()).getExactSizeOnDisk()).sum()) > Integer.MAX_VALUE) {
            throw new DMLRuntimeException("Serialized size (" + result + ") larger than Integer.MAX_VALUE.");
        }
        return (int)result;
    }

    private void validateListObject(ListObject lo) {
        for (Data d : lo.getData()) {
            if (d instanceof MatrixObject) continue;
            throw new DMLRuntimeException(String.format("Paramserv func: Unsupported deep serialize of %s, which is not matrix.", d.getDebugName()));
        }
    }
}

