/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.matrix.data;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.sysml.runtime.matrix.data.TaggedFirstSecondIndexes;
import org.apache.sysml.runtime.util.UtilFunctions;

public class TaggedTripleIndexes
extends TaggedFirstSecondIndexes {
    private long third = -1L;

    public TaggedTripleIndexes() {
    }

    public TaggedTripleIndexes(long i1, long i2, long i3, byte t) {
        super(i1, t, i2);
        this.third = i3;
    }

    public TaggedTripleIndexes(TaggedTripleIndexes that) {
        this.setIndexes(that);
    }

    public void setIndexes(TaggedTripleIndexes that) {
        this.first = that.first;
        this.second = that.second;
        this.third = that.third;
        this.tag = that.tag;
    }

    @Override
    public String toString() {
        return "(" + this.first + ", " + this.second + ") k: " + this.third + ", tag: " + this.tag;
    }

    public long getThirdIndex() {
        return this.third;
    }

    public void setIndexes(long i1, long i2, long i3) {
        super.setIndexes(i1, i2);
        this.third = i3;
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        this.first = in.readLong();
        this.second = in.readLong();
        this.third = in.readLong();
        this.tag = in.readByte();
    }

    @Override
    public void write(DataOutput out) throws IOException {
        out.writeLong(this.first);
        out.writeLong(this.second);
        out.writeLong(this.third);
        out.writeByte(this.tag);
    }

    public int compareTo(TaggedTripleIndexes other) {
        if (this.first != other.first) {
            return this.first > other.first ? 1 : -1;
        }
        if (this.second != other.second) {
            return this.second > other.second ? 1 : -1;
        }
        if (this.third != other.third) {
            return this.third > other.third ? 1 : -1;
        }
        if (this.tag != other.tag) {
            return this.tag - other.tag;
        }
        return 0;
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof TaggedTripleIndexes)) {
            return false;
        }
        TaggedTripleIndexes tother = (TaggedTripleIndexes)other;
        return this.first == tother.first && this.tag == tother.tag && this.second == tother.second && this.third == tother.third;
    }

    @Override
    public int hashCode() {
        return UtilFunctions.longHashCode((this.first << 32) + (this.second << 16) + this.third + (long)this.tag + 99991L) % 1405695061;
    }
}

