/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.transform.encode;

import java.util.Arrays;
import java.util.List;
import org.apache.sysml.parser.Expression;
import org.apache.sysml.runtime.matrix.data.FrameBlock;
import org.apache.sysml.runtime.matrix.data.MatrixBlock;
import org.apache.sysml.runtime.transform.encode.Encoder;
import org.apache.sysml.runtime.transform.encode.EncoderDummycode;

public class EncoderComposite
extends Encoder {
    private static final long serialVersionUID = -8473768154646831882L;
    private List<Encoder> _encoders = null;
    private FrameBlock _meta = null;

    protected EncoderComposite(List<Encoder> encoders) {
        super(null, -1);
        this._encoders = encoders;
    }

    @Override
    public int getNumCols() {
        int clen = 0;
        for (Encoder encoder : this._encoders) {
            clen = Math.max(clen, encoder.getNumCols());
        }
        return clen;
    }

    public List<Encoder> getEncoders() {
        return this._encoders;
    }

    @Override
    public MatrixBlock encode(FrameBlock in, MatrixBlock out) {
        try {
            for (Encoder encoder : this._encoders) {
                encoder.build(in);
            }
            this._meta = new FrameBlock(in.getNumColumns(), Expression.ValueType.STRING);
            for (Encoder encoder : this._encoders) {
                this._meta = encoder.getMetaData(this._meta);
            }
            for (Encoder encoder : this._encoders) {
                encoder.initMetaData(this._meta);
            }
            for (Encoder encoder : this._encoders) {
                out = encoder.apply(in, out);
            }
        }
        catch (Exception ex) {
            LOG.error((Object)("Failed transform-encode frame with \n" + this));
            throw ex;
        }
        return out;
    }

    @Override
    public void build(FrameBlock in) {
        for (Encoder encoder : this._encoders) {
            encoder.build(in);
        }
    }

    @Override
    public MatrixBlock apply(FrameBlock in, MatrixBlock out) {
        try {
            for (Encoder encoder : this._encoders) {
                out = encoder.apply(in, out);
            }
        }
        catch (Exception ex) {
            LOG.error((Object)("Failed to transform-apply frame with \n" + this));
            throw ex;
        }
        return out;
    }

    @Override
    public FrameBlock getMetaData(FrameBlock out) {
        if (this._meta != null) {
            return this._meta;
        }
        for (Encoder encoder : this._encoders) {
            encoder.getMetaData(out);
        }
        return out;
    }

    @Override
    public void initMetaData(FrameBlock out) {
        for (Encoder encoder : this._encoders) {
            encoder.initMetaData(out);
        }
    }

    @Override
    public MatrixBlock getColMapping(FrameBlock meta, MatrixBlock out) {
        EncoderDummycode dummy = null;
        for (Encoder encoder : this._encoders) {
            if (!(encoder instanceof EncoderDummycode)) continue;
            dummy = (EncoderDummycode)encoder;
        }
        if (dummy != null) {
            out = dummy.getColMapping(meta, out);
        } else {
            for (int i = 0; i < out.getNumRows(); ++i) {
                out.quickSetValue(i, 0, i + 1);
                out.quickSetValue(i, 1, i + 1);
                out.quickSetValue(i, 2, i + 1);
            }
        }
        return out;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("CompositeEncoder(" + this._encoders.size() + "):\n");
        for (Encoder encoder : this._encoders) {
            sb.append("-- ");
            sb.append(encoder.getClass().getSimpleName());
            sb.append(": ");
            sb.append(Arrays.toString(encoder.getColList()));
            sb.append("\n");
        }
        return sb.toString();
    }
}

