/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.hops;

import java.util.Arrays;
import java.util.HashMap;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.sysml.api.DMLScript;
import org.apache.sysml.conf.CompilerConfig;
import org.apache.sysml.conf.ConfigurationManager;
import org.apache.sysml.conf.DMLConfig;
import org.apache.sysml.hops.AggBinaryOp;
import org.apache.sysml.hops.BinaryOp;
import org.apache.sysml.hops.DataOp;
import org.apache.sysml.hops.FunctionOp;
import org.apache.sysml.hops.Hop;
import org.apache.sysml.hops.LiteralOp;
import org.apache.sysml.hops.UnaryOp;
import org.apache.sysml.hops.rewrite.HopRewriteUtils;
import org.apache.sysml.lops.LopProperties;
import org.apache.sysml.lops.compile.Dag;
import org.apache.sysml.parser.Expression;
import org.apache.sysml.parser.ForStatementBlock;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.controlprogram.ForProgramBlock;
import org.apache.sysml.runtime.controlprogram.LocalVariableMap;
import org.apache.sysml.runtime.controlprogram.caching.LazyWriteBuffer;
import org.apache.sysml.runtime.controlprogram.context.SparkExecutionContext;
import org.apache.sysml.runtime.controlprogram.parfor.stat.InfrastructureAnalyzer;
import org.apache.sysml.runtime.functionobjects.IntegerDivide;
import org.apache.sysml.runtime.functionobjects.Modulus;
import org.apache.sysml.runtime.instructions.cp.Data;
import org.apache.sysml.runtime.instructions.cp.ScalarObject;
import org.apache.sysml.runtime.matrix.MatrixCharacteristics;
import org.apache.sysml.runtime.matrix.data.MatrixBlock;
import org.apache.sysml.runtime.matrix.data.OutputInfo;
import org.apache.sysml.runtime.matrix.data.SparseBlock;
import org.apache.sysml.runtime.util.IndexRange;
import org.apache.sysml.runtime.util.UtilFunctions;
import org.apache.sysml.yarn.ropt.YarnClusterAnalyzer;

public class OptimizerUtils {
    public static double MEM_UTIL_FACTOR = 0.7;
    public static final int DEFAULT_BLOCKSIZE = 1000;
    public static final int DEFAULT_FRAME_BLOCKSIZE = 1000;
    public static final OptimizationLevel DEFAULT_OPTLEVEL = OptimizationLevel.O2_LOCAL_MEMORY_DEFAULT;
    public static double DEFAULT_SIZE;
    public static final long DOUBLE_SIZE = 8L;
    public static final long INT_SIZE = 4L;
    public static final long CHAR_SIZE = 1L;
    public static final long BOOLEAN_SIZE = 1L;
    public static final double INVALID_SIZE = -1.0;
    public static final long MAX_NUMCELLS_CP_DENSE = Integer.MAX_VALUE;
    public static final long MAX_NNZ_CP_SPARSE;
    public static final long SAFE_REP_CHANGE_THRES = 0x800000L;
    public static boolean ALLOW_COMMON_SUBEXPRESSION_ELIMINATION;
    public static boolean ALLOW_CONSTANT_FOLDING;
    public static boolean ALLOW_ALGEBRAIC_SIMPLIFICATION;
    public static boolean ALLOW_OPERATOR_FUSION;
    public static boolean ALLOW_BRANCH_REMOVAL;
    public static boolean ALLOW_AUTO_VECTORIZATION;
    public static boolean ALLOW_SIZE_EXPRESSION_EVALUATION;
    public static boolean ALLOW_WORSTCASE_SIZE_EXPRESSION_EVALUATION;
    public static boolean ALLOW_RAND_JOB_RECOMPILE;
    public static boolean ALLOW_RUNTIME_PIGGYBACKING;
    public static boolean ALLOW_INTER_PROCEDURAL_ANALYSIS;
    public static int IPA_NUM_REPETITIONS;
    public static boolean ALLOW_SUM_PRODUCT_REWRITES;
    public static boolean ALLOW_SPLIT_HOP_DAGS;
    public static boolean ALLOW_LOOP_UPDATE_IN_PLACE;
    public static boolean ALLOW_CODE_MOTION;
    public static final double PARALLEL_CP_READ_PARALLELISM_MULTIPLIER = 1.0;
    public static final double PARALLEL_CP_WRITE_PARALLELISM_MULTIPLIER = 1.0;
    public static final boolean ALLOW_COMBINE_FILE_INPUT_FORMAT = true;

    public static OptimizationLevel getOptLevel() {
        int optlevel = ConfigurationManager.getCompilerConfig().getInt(CompilerConfig.ConfigType.OPT_LEVEL);
        return OptimizationLevel.values()[optlevel];
    }

    public static boolean isMemoryBasedOptLevel() {
        return OptimizerUtils.getOptLevel() != OptimizationLevel.O0_LOCAL_STATIC;
    }

    public static boolean isOptLevel(OptimizationLevel level) {
        return OptimizerUtils.getOptLevel() == level;
    }

    public static CompilerConfig constructCompilerConfig(DMLConfig dmlconf) {
        return OptimizerUtils.constructCompilerConfig(new CompilerConfig(), dmlconf);
    }

    public static CompilerConfig constructCompilerConfig(CompilerConfig cconf, DMLConfig dmlconf) {
        cconf.set(CompilerConfig.ConfigType.BLOCK_SIZE, dmlconf.getIntValue("sysml.defaultblocksize"));
        int optlevel = dmlconf.getIntValue("sysml.optlevel");
        if (optlevel < 0 || optlevel > 7) {
            throw new DMLRuntimeException("Error: invalid optimization level '" + optlevel + "' (valid values: 0-5).");
        }
        if (DMLScript.ENABLE_DEBUG_MODE) {
            optlevel = 5;
        }
        switch (optlevel) {
            case 0: {
                cconf.set(CompilerConfig.ConfigType.OPT_LEVEL, OptimizationLevel.O0_LOCAL_STATIC.ordinal());
                ALLOW_CONSTANT_FOLDING = false;
                ALLOW_COMMON_SUBEXPRESSION_ELIMINATION = false;
                ALLOW_ALGEBRAIC_SIMPLIFICATION = false;
                ALLOW_AUTO_VECTORIZATION = false;
                ALLOW_INTER_PROCEDURAL_ANALYSIS = false;
                IPA_NUM_REPETITIONS = 1;
                ALLOW_BRANCH_REMOVAL = false;
                ALLOW_SUM_PRODUCT_REWRITES = false;
                break;
            }
            case 1: {
                cconf.set(CompilerConfig.ConfigType.OPT_LEVEL, OptimizationLevel.O1_LOCAL_MEMORY_MIN.ordinal());
                ALLOW_CONSTANT_FOLDING = false;
                ALLOW_COMMON_SUBEXPRESSION_ELIMINATION = false;
                ALLOW_ALGEBRAIC_SIMPLIFICATION = false;
                ALLOW_AUTO_VECTORIZATION = false;
                ALLOW_INTER_PROCEDURAL_ANALYSIS = false;
                IPA_NUM_REPETITIONS = 1;
                ALLOW_BRANCH_REMOVAL = false;
                ALLOW_SUM_PRODUCT_REWRITES = false;
                ALLOW_LOOP_UPDATE_IN_PLACE = false;
                break;
            }
            case 2: {
                cconf.set(CompilerConfig.ConfigType.OPT_LEVEL, OptimizationLevel.O2_LOCAL_MEMORY_DEFAULT.ordinal());
                break;
            }
            case 3: {
                cconf.set(CompilerConfig.ConfigType.OPT_LEVEL, OptimizationLevel.O3_LOCAL_RESOURCE_TIME_MEMORY.ordinal());
                break;
            }
            case 4: {
                cconf.set(CompilerConfig.ConfigType.OPT_LEVEL, OptimizationLevel.O4_GLOBAL_TIME_MEMORY.ordinal());
                break;
            }
            case 5: {
                cconf.set(CompilerConfig.ConfigType.OPT_LEVEL, OptimizationLevel.O5_DEBUG_MODE.ordinal());
                ALLOW_CONSTANT_FOLDING = false;
                ALLOW_COMMON_SUBEXPRESSION_ELIMINATION = false;
                ALLOW_ALGEBRAIC_SIMPLIFICATION = false;
                ALLOW_INTER_PROCEDURAL_ANALYSIS = false;
                ALLOW_BRANCH_REMOVAL = false;
                ALLOW_SIZE_EXPRESSION_EVALUATION = false;
                ALLOW_WORSTCASE_SIZE_EXPRESSION_EVALUATION = false;
                ALLOW_RAND_JOB_RECOMPILE = false;
                ALLOW_SUM_PRODUCT_REWRITES = false;
                ALLOW_SPLIT_HOP_DAGS = false;
                cconf.set(CompilerConfig.ConfigType.ALLOW_DYN_RECOMPILATION, false);
                cconf.set(CompilerConfig.ConfigType.ALLOW_INDIVIDUAL_SB_SPECIFIC_OPS, false);
                break;
            }
            case 6: {
                cconf.set(CompilerConfig.ConfigType.OPT_LEVEL, OptimizationLevel.O2_LOCAL_MEMORY_DEFAULT.ordinal());
                ALLOW_AUTO_VECTORIZATION = false;
                break;
            }
            case 7: {
                cconf.set(CompilerConfig.ConfigType.OPT_LEVEL, OptimizationLevel.O2_LOCAL_MEMORY_DEFAULT.ordinal());
                ALLOW_OPERATOR_FUSION = false;
                ALLOW_AUTO_VECTORIZATION = false;
                ALLOW_SUM_PRODUCT_REWRITES = false;
            }
        }
        if (!dmlconf.getBooleanValue("sysml.cp.parallel.io")) {
            cconf.set(CompilerConfig.ConfigType.PARALLEL_CP_READ_TEXTFORMATS, false);
            cconf.set(CompilerConfig.ConfigType.PARALLEL_CP_WRITE_TEXTFORMATS, false);
            cconf.set(CompilerConfig.ConfigType.PARALLEL_CP_READ_BINARYFORMATS, false);
            cconf.set(CompilerConfig.ConfigType.PARALLEL_CP_WRITE_BINARYFORMATS, false);
        }
        if (!dmlconf.getBooleanValue("sysml.cp.parallel.ops")) {
            cconf.set(CompilerConfig.ConfigType.PARALLEL_CP_MATRIX_OPERATIONS, false);
        }
        return cconf;
    }

    public static void resetStaticCompilerFlags() {
        ALLOW_ALGEBRAIC_SIMPLIFICATION = true;
        ALLOW_AUTO_VECTORIZATION = true;
        ALLOW_BRANCH_REMOVAL = true;
        ALLOW_CONSTANT_FOLDING = true;
        ALLOW_COMMON_SUBEXPRESSION_ELIMINATION = true;
        ALLOW_INTER_PROCEDURAL_ANALYSIS = true;
        ALLOW_LOOP_UPDATE_IN_PLACE = true;
        ALLOW_OPERATOR_FUSION = true;
        ALLOW_RAND_JOB_RECOMPILE = true;
        ALLOW_SIZE_EXPRESSION_EVALUATION = true;
        ALLOW_SPLIT_HOP_DAGS = true;
        ALLOW_SUM_PRODUCT_REWRITES = true;
        ALLOW_WORSTCASE_SIZE_EXPRESSION_EVALUATION = true;
        IPA_NUM_REPETITIONS = 3;
    }

    public static long getDefaultSize() {
        return Math.max(InfrastructureAnalyzer.getLocalMaxMemory(), Math.max(InfrastructureAnalyzer.getRemoteMaxMemoryMap(), InfrastructureAnalyzer.getRemoteMaxMemoryReduce()));
    }

    public static void resetDefaultSize() {
        DEFAULT_SIZE = OptimizerUtils.getDefaultSize();
    }

    public static int getDefaultFrameSize() {
        return 1000;
    }

    public static double getLocalMemBudget() {
        double ret = InfrastructureAnalyzer.getLocalMaxMemory();
        return ret * MEM_UTIL_FACTOR;
    }

    public static double getRemoteMemBudgetMap() {
        return OptimizerUtils.getRemoteMemBudgetMap(false);
    }

    public static double getRemoteMemBudgetMap(boolean substractSortBuffer) {
        double ret = InfrastructureAnalyzer.getRemoteMaxMemoryMap();
        if (substractSortBuffer) {
            ret -= (double)InfrastructureAnalyzer.getRemoteMaxMemorySortBuffer();
        }
        return ret * MEM_UTIL_FACTOR;
    }

    public static double getRemoteMemBudgetReduce() {
        double ret = InfrastructureAnalyzer.getRemoteMaxMemoryReduce();
        return ret * MEM_UTIL_FACTOR;
    }

    public static boolean isMaxLocalParallelism(int k) {
        return InfrastructureAnalyzer.getLocalParallelism() == k;
    }

    public static boolean isTopLevelParFor() {
        return InfrastructureAnalyzer.getLocalMaxMemoryFraction() >= 0.99;
    }

    public static boolean checkSparkBroadcastMemoryBudget(double size) {
        double memBudgetExec = SparkExecutionContext.getBroadcastMemoryBudget();
        double memBudgetLocal = OptimizerUtils.getLocalMemBudget();
        return size < memBudgetExec && 2.0 * size < memBudgetLocal;
    }

    public static boolean checkSparkBroadcastMemoryBudget(long rlen, long clen, long brlen, long bclen, long nnz) {
        double memBudgetExec = SparkExecutionContext.getBroadcastMemoryBudget();
        double memBudgetLocal = OptimizerUtils.getLocalMemBudget();
        double sp = OptimizerUtils.getSparsity(rlen, clen, nnz);
        double size = OptimizerUtils.estimateSizeExactSparsity(rlen, clen, sp);
        double sizeP = OptimizerUtils.estimatePartitionedSizeExactSparsity(rlen, clen, brlen, bclen, sp);
        return OptimizerUtils.isValidCPDimensions(rlen, clen) && sizeP < memBudgetExec && size + sizeP < memBudgetLocal;
    }

    public static boolean checkSparkCollectMemoryBudget(MatrixCharacteristics mc, long memPinned) {
        return OptimizerUtils.checkSparkCollectMemoryBudget(mc.getRows(), mc.getCols(), mc.getRowsPerBlock(), mc.getColsPerBlock(), mc.getNonZerosBound(), memPinned, false);
    }

    public static boolean checkSparkCollectMemoryBudget(MatrixCharacteristics mc, long memPinned, boolean checkBP) {
        return OptimizerUtils.checkSparkCollectMemoryBudget(mc.getRows(), mc.getCols(), mc.getRowsPerBlock(), mc.getColsPerBlock(), mc.getNonZerosBound(), memPinned, checkBP);
    }

    private static boolean checkSparkCollectMemoryBudget(long rlen, long clen, int brlen, int bclen, long nnz, long memPinned, boolean checkBP) {
        double memPMatrix;
        double sp = OptimizerUtils.getSparsity(rlen, clen, nnz);
        double memMatrix = OptimizerUtils.estimateSizeExactSparsity(rlen, clen, sp);
        return (double)memPinned + memMatrix + (memPMatrix = (double)OptimizerUtils.estimatePartitionedSizeExactSparsity(rlen, clen, (long)brlen, (long)bclen, sp)) < OptimizerUtils.getLocalMemBudget() && (!checkBP || memMatrix < (double)LazyWriteBuffer.getWriteBufferLimit());
    }

    public static boolean checkSparseBlockCSRConversion(MatrixCharacteristics mcIn) {
        return OptimizerUtils.getSparsity(mcIn) < 0.4;
    }

    public static int getNumReducers(boolean configOnly) {
        if (OptimizerUtils.isSparkExecutionMode()) {
            return SparkExecutionContext.getDefaultParallelism(false);
        }
        int ret = ConfigurationManager.getNumReducers();
        if (!configOnly) {
            ret = Math.min(ret, InfrastructureAnalyzer.getRemoteParallelReduceTasks());
            if (InfrastructureAnalyzer.isYarnEnabled()) {
                ret = (int)Math.max((long)ret, YarnClusterAnalyzer.getNumCores() / 2L);
            }
        }
        return ret;
    }

    public static int getNumMappers() {
        if (OptimizerUtils.isSparkExecutionMode()) {
            return SparkExecutionContext.getDefaultParallelism(false);
        }
        int ret = InfrastructureAnalyzer.getRemoteParallelMapTasks();
        if (InfrastructureAnalyzer.isYarnEnabled()) {
            ret = (int)Math.max((long)ret, YarnClusterAnalyzer.getNumCores());
        }
        return ret;
    }

    public static DMLScript.RUNTIME_PLATFORM getDefaultExecutionMode() {
        DMLScript.RUNTIME_PLATFORM ret = DMLScript.RUNTIME_PLATFORM.HYBRID;
        String sparkenv = System.getenv().get("SPARK_ENV_LOADED");
        if (sparkenv != null && sparkenv.equals("1")) {
            ret = DMLScript.RUNTIME_PLATFORM.HYBRID_SPARK;
        }
        return ret;
    }

    public static boolean isSparkExecutionMode() {
        return DMLScript.rtplatform == DMLScript.RUNTIME_PLATFORM.SPARK || DMLScript.rtplatform == DMLScript.RUNTIME_PLATFORM.HYBRID_SPARK;
    }

    public static boolean isHadoopExecutionMode() {
        return DMLScript.rtplatform == DMLScript.RUNTIME_PLATFORM.HADOOP || DMLScript.rtplatform == DMLScript.RUNTIME_PLATFORM.HYBRID;
    }

    public static boolean isHybridExecutionMode() {
        return DMLScript.rtplatform == DMLScript.RUNTIME_PLATFORM.HYBRID || DMLScript.rtplatform == DMLScript.RUNTIME_PLATFORM.HYBRID_SPARK;
    }

    public static int getParallelTextReadParallelism() {
        if (!ConfigurationManager.getCompilerConfigFlag(CompilerConfig.ConfigType.PARALLEL_CP_READ_TEXTFORMATS)) {
            return 1;
        }
        double dop = (double)InfrastructureAnalyzer.getLocalParallelism() * 1.0;
        return (int)Math.round(dop);
    }

    public static int getParallelBinaryReadParallelism() {
        if (!ConfigurationManager.getCompilerConfigFlag(CompilerConfig.ConfigType.PARALLEL_CP_READ_BINARYFORMATS)) {
            return 1;
        }
        double dop = (double)InfrastructureAnalyzer.getLocalParallelism() * 1.0;
        return (int)Math.round(dop);
    }

    public static int getParallelTextWriteParallelism() {
        if (!ConfigurationManager.getCompilerConfigFlag(CompilerConfig.ConfigType.PARALLEL_CP_WRITE_TEXTFORMATS)) {
            return 1;
        }
        double dop = (double)InfrastructureAnalyzer.getLocalParallelism() * 1.0;
        return (int)Math.round(dop);
    }

    public static int getParallelBinaryWriteParallelism() {
        if (!ConfigurationManager.getCompilerConfigFlag(CompilerConfig.ConfigType.PARALLEL_CP_WRITE_BINARYFORMATS)) {
            return 1;
        }
        double dop = (double)InfrastructureAnalyzer.getLocalParallelism() * 1.0;
        return (int)Math.round(dop);
    }

    public static long estimateSize(MatrixCharacteristics mc) {
        return OptimizerUtils.estimateSizeExactSparsity(mc);
    }

    public static long estimateSizeExactSparsity(MatrixCharacteristics mc) {
        return OptimizerUtils.estimateSizeExactSparsity(mc.getRows(), mc.getCols(), mc.getNonZeros());
    }

    public static long estimateSizeExactSparsity(long nrows, long ncols, long nnz) {
        double sp = OptimizerUtils.getSparsity(nrows, ncols, nnz);
        return OptimizerUtils.estimateSizeExactSparsity(nrows, ncols, sp);
    }

    public static long estimateSizeExactSparsity(long nrows, long ncols, double sp) {
        return MatrixBlock.estimateSizeInMemory(nrows, ncols, sp);
    }

    public static long estimatePartitionedSizeExactSparsity(MatrixCharacteristics mc) {
        return OptimizerUtils.estimatePartitionedSizeExactSparsity(mc.getRows(), mc.getCols(), (long)mc.getRowsPerBlock(), (long)mc.getColsPerBlock(), mc.getNonZerosBound());
    }

    public static long estimatePartitionedSizeExactSparsity(long rlen, long clen, long brlen, long bclen, long nnz) {
        double sp = OptimizerUtils.getSparsity(rlen, clen, nnz);
        return OptimizerUtils.estimatePartitionedSizeExactSparsity(rlen, clen, brlen, bclen, sp);
    }

    public static long estimatePartitionedSizeExactSparsity(long rlen, long clen, long brlen, long bclen, double sp) {
        long ret = 0L;
        long tnrblks = (long)Math.ceil((double)rlen / (double)brlen);
        long tncblks = (long)Math.ceil((double)clen / (double)bclen);
        long nnz = (long)Math.ceil(sp * (double)rlen * (double)clen);
        if (nnz <= tnrblks * tncblks) {
            long lrlen = Math.min(rlen, brlen);
            long lclen = Math.min(clen, bclen);
            return nnz * OptimizerUtils.estimateSizeExactSparsity(lrlen, lclen, 1L) + (tnrblks * tncblks - nnz) * OptimizerUtils.estimateSizeEmptyBlock(lrlen, lclen);
        }
        long nrblks = rlen / brlen;
        long ncblks = clen / bclen;
        if (nrblks * ncblks > 0L) {
            ret += nrblks * ncblks * OptimizerUtils.estimateSizeExactSparsity(brlen, bclen, sp);
        }
        long lrlen = rlen % brlen;
        if (ncblks > 0L && lrlen >= 0L) {
            ret += ncblks * OptimizerUtils.estimateSizeExactSparsity(lrlen, bclen, sp);
        }
        long lclen = clen % bclen;
        if (nrblks > 0L && lclen >= 0L) {
            ret += nrblks * OptimizerUtils.estimateSizeExactSparsity(brlen, lclen, sp);
        }
        if (lrlen >= 0L && lclen >= 0L) {
            ret += OptimizerUtils.estimateSizeExactSparsity(lrlen, lclen, sp);
        }
        return ret;
    }

    public static long estimateSize(long nrows, long ncols) {
        return OptimizerUtils.estimateSizeExactSparsity(nrows, ncols, 1.0);
    }

    public static long estimateSizeEmptyBlock(long nrows, long ncols) {
        return OptimizerUtils.estimateSizeExactSparsity(0L, 0L, 0.0);
    }

    public static long estimateSizeTextOutput(long rows, long cols, long nnz, OutputInfo oinfo) {
        long bsize = MatrixBlock.estimateSizeOnDisk(rows, cols, nnz);
        if (oinfo == OutputInfo.TextCellOutputInfo || oinfo == OutputInfo.MatrixMarketOutputInfo) {
            return bsize * 3L;
        }
        if (oinfo == OutputInfo.CSVOutputInfo) {
            return bsize * 2L;
        }
        return bsize;
    }

    public static double getTotalMemEstimate(Hop[] in, Hop out) {
        return OptimizerUtils.getTotalMemEstimate(in, out, false);
    }

    public static double getTotalMemEstimate(Hop[] in, Hop out, boolean denseOut) {
        return Arrays.stream(in).mapToDouble(h -> h.getOutputMemEstimate()).sum() + (!denseOut ? out.getOutputMemEstimate() : (double)OptimizerUtils.estimateSize(out.getDim1(), out.getDim2()));
    }

    public static boolean isIndexingRangeBlockAligned(IndexRange ixrange, MatrixCharacteristics mc) {
        long rl = ixrange.rowStart;
        long ru = ixrange.rowEnd;
        long cl = ixrange.colStart;
        long cu = ixrange.colEnd;
        long brlen = mc.getRowsPerBlock();
        long bclen = mc.getColsPerBlock();
        return OptimizerUtils.isIndexingRangeBlockAligned(rl, ru, cl, cu, brlen, bclen);
    }

    public static boolean isIndexingRangeBlockAligned(long rl, long ru, long cl, long cu, long brlen, long bclen) {
        return rl != -1L && ru != -1L && cl != -1L && cu != -1L && ((rl - 1L) % brlen == 0L && (cl - 1L) % bclen == 0L || (rl - 1L) / brlen == (ru - 1L) / brlen && (cl - 1L) % bclen == 0L || (rl - 1L) % brlen == 0L && (cl - 1L) / bclen == (cu - 1L) / bclen);
    }

    public static boolean isValidCPDimensions(MatrixCharacteristics mc) {
        return OptimizerUtils.isValidCPDimensions(mc.getRows(), mc.getCols());
    }

    public static boolean isValidCPDimensions(long rows, long cols) {
        return rows <= Integer.MAX_VALUE && cols <= Integer.MAX_VALUE;
    }

    public static boolean isValidCPDimensions(Expression.ValueType[] schema, String[] names) {
        return schema != null && names != null && schema.length > 0 && schema.length == names.length;
    }

    public static boolean isValidCPMatrixSize(long rows, long cols, double sparsity) {
        boolean ret = true;
        long nnz = (long)(sparsity * (double)rows * (double)cols);
        boolean sparse = MatrixBlock.evalSparseFormatInMemory(rows, cols, nnz);
        ret = sparse ? nnz <= MAX_NNZ_CP_SPARSE : rows * cols <= Integer.MAX_VALUE;
        return ret;
    }

    public static boolean exceedsCachingThreshold(long dim2, double outMem) {
        return !(dim2 > 1L && outMem < OptimizerUtils.getLocalMemBudget() || dim2 == 1L && outMem < OptimizerUtils.getLocalMemBudget() / 3.0);
    }

    public static String getUniqueTempFileName() {
        return ConfigurationManager.getScratchSpace() + "/" + "_p" + DMLScript.getUUID() + "/" + "_t0" + "/" + Dag.getNextUniqueFilenameSuffix();
    }

    public static boolean allowsToFilterEmptyBlockOutputs(Hop hop) {
        boolean ret = true;
        for (Hop p : hop.getParent()) {
            p.optFindExecType();
            ret &= (p.getExecType() == LopProperties.ExecType.CP || p instanceof AggBinaryOp && OptimizerUtils.allowsToFilterEmptyBlockOutputs(p) || HopRewriteUtils.isReorg(p, Hop.ReOrgOp.RESHAPE, Hop.ReOrgOp.TRANS) && OptimizerUtils.allowsToFilterEmptyBlockOutputs(p) || HopRewriteUtils.isData(p, Hop.DataOpTypes.PERSISTENTWRITE) && ((DataOp)p).getInputFormatType() == Hop.FileFormatTypes.TEXT) && !(p instanceof FunctionOp) && (!(p instanceof DataOp) || ((DataOp)p).getInputFormatType() == Hop.FileFormatTypes.TEXT);
        }
        return ret;
    }

    public static int getConstrainedNumThreads(int maxNumThreads) {
        int ret = InfrastructureAnalyzer.getLocalParallelism();
        if (maxNumThreads > 0) {
            ret = Math.min(ret, maxNumThreads);
        }
        if (!ConfigurationManager.isParallelMatrixOperations()) {
            ret = 1;
        }
        return ret;
    }

    public static Level getDefaultLogLevel() {
        Level log = Logger.getRootLogger().getLevel();
        return log != null ? log : Level.INFO;
    }

    public static long getMatMultNnz(double sp1, double sp2, long m, long k, long n, boolean worstcase) {
        return OptimizerUtils.getNnz(m, n, OptimizerUtils.getMatMultSparsity(sp1, sp2, m, k, n, worstcase));
    }

    public static double getMatMultSparsity(double sp1, double sp2, long m, long k, long n, boolean worstcase) {
        if (worstcase) {
            double nnz1 = sp1 * (double)m * (double)k;
            double nnz2 = sp2 * (double)k * (double)n;
            return Math.min(1.0, nnz1 / (double)m) * Math.min(1.0, nnz2 / (double)n);
        }
        return 1.0 - Math.pow(1.0 - sp1 * sp2, k);
    }

    public static double getLeftIndexingSparsity(long rlen1, long clen1, long nnz1, long rlen2, long clen2, long nnz2) {
        boolean scalarRhs = rlen2 == 0L && clen2 == 0L;
        long lnnz = -1L;
        if (nnz1 >= 0L && scalarRhs) {
            lnnz = nnz1 + 1L;
        } else if (nnz1 >= 0L && nnz2 >= 0L) {
            lnnz = nnz1 + nnz2;
        } else if (nnz1 >= 0L && rlen2 > 0L && clen2 > 0L) {
            lnnz = nnz1 + rlen2 * clen2;
        }
        lnnz = Math.min(lnnz, rlen1 * clen1);
        return OptimizerUtils.getSparsity(rlen1, clen1, lnnz >= 0L ? lnnz : rlen1 * clen1);
    }

    public static boolean isBinaryOpConditionalSparseSafe(Hop.OpOp2 op) {
        return op == Hop.OpOp2.GREATER || op == Hop.OpOp2.LESS || op == Hop.OpOp2.NOTEQUAL || op == Hop.OpOp2.EQUAL || op == Hop.OpOp2.MINUS;
    }

    public static boolean isBinaryOpConditionalSparseSafeExact(Hop.OpOp2 op, LiteralOp lit) {
        double val = HopRewriteUtils.getDoubleValueSafe(lit);
        return op == Hop.OpOp2.NOTEQUAL && val == 0.0;
    }

    public static boolean isBinaryOpSparsityConditionalSparseSafe(Hop.OpOp2 op, LiteralOp lit) {
        double val = HopRewriteUtils.getDoubleValueSafe(lit);
        return op == Hop.OpOp2.GREATER && val == 0.0 || op == Hop.OpOp2.LESS && val == 0.0 || op == Hop.OpOp2.NOTEQUAL && val == 0.0 || op == Hop.OpOp2.EQUAL && val != 0.0 || op == Hop.OpOp2.MINUS && val == 0.0 || op == Hop.OpOp2.PLUS && val == 0.0 || op == Hop.OpOp2.POW && val != 0.0 || op == Hop.OpOp2.MAX && val <= 0.0 || op == Hop.OpOp2.MIN && val >= 0.0;
    }

    public static double getBinaryOpSparsityConditionalSparseSafe(double sp1, Hop.OpOp2 op, LiteralOp lit) {
        return OptimizerUtils.isBinaryOpSparsityConditionalSparseSafe(op, lit) ? sp1 : 1.0;
    }

    public static double getBinaryOpSparsity(double sp1, double sp2, Hop.OpOp2 op, boolean worstcase) {
        double ret = 1.0;
        if (worstcase) {
            switch (op) {
                case PLUS: 
                case MINUS: 
                case LESS: 
                case GREATER: 
                case NOTEQUAL: 
                case MIN: 
                case MAX: 
                case OR: {
                    ret = worstcase ? Math.min(1.0, sp1 + sp2) : sp1 + sp2 - sp1 * sp2;
                    break;
                }
                case MULT: 
                case AND: {
                    ret = worstcase ? Math.min(sp1, sp2) : sp1 * sp2;
                    break;
                }
                case DIV: {
                    ret = Math.min(1.0, sp1 + (1.0 - sp2));
                    break;
                }
                case MODULUS: 
                case POW: 
                case MINUS_NZ: 
                case LOG_NZ: {
                    ret = sp1;
                    break;
                }
                default: {
                    ret = 1.0;
                    break;
                }
            }
        } else {
            switch (op) {
                case PLUS: 
                case MINUS: {
                    ret = 1.0 - (1.0 - sp1) * (1.0 - sp2);
                    break;
                }
                case MULT: {
                    ret = sp1 * sp2;
                    break;
                }
                case DIV: {
                    ret = 1.0;
                    break;
                }
                case LESS: 
                case GREATER: 
                case NOTEQUAL: 
                case LESSEQUAL: 
                case GREATEREQUAL: 
                case EQUAL: {
                    ret = 1.0;
                    break;
                }
                default: {
                    ret = 1.0;
                }
            }
        }
        return ret;
    }

    public static long getOuterNonZeros(long n1, long n2, long nnz1, long nnz2, Hop.OpOp2 op) {
        if (nnz1 < 0L || nnz2 < 0L) {
            return n1 * n2;
        }
        switch (op) {
            case PLUS: 
            case MINUS: 
            case LESS: 
            case GREATER: 
            case NOTEQUAL: 
            case MIN: 
            case MAX: 
            case OR: {
                return n1 * n2 - (n1 - nnz1) * (n2 - nnz2);
            }
            case MULT: 
            case AND: {
                return nnz1 * nnz2;
            }
        }
        return n1 * n2;
    }

    public static long getNnz(long dim1, long dim2, double sp) {
        return Math.round(sp * (double)dim1 * (double)dim2);
    }

    public static double getSparsity(MatrixCharacteristics mc) {
        return OptimizerUtils.getSparsity(mc.getRows(), mc.getCols(), mc.getNonZeros());
    }

    public static double getSparsity(long dim1, long dim2, long nnz) {
        return dim1 <= 0L || dim2 <= 0L || nnz < 0L ? 1.0 : Math.min((double)nnz / (double)dim1 / (double)dim2, 1.0);
    }

    public static String toMB(double inB) {
        if (inB < 0.0) {
            return "-";
        }
        return String.format("%.0f", inB / 1048576.0);
    }

    public static long getNumIterations(ForProgramBlock fpb, long defaultValue) {
        if (fpb.getStatementBlock() == null) {
            return defaultValue;
        }
        ForStatementBlock fsb = (ForStatementBlock)fpb.getStatementBlock();
        try {
            long increment;
            HashMap<Long, Long> memo = new HashMap<Long, Long>();
            long from = OptimizerUtils.rEvalSimpleLongExpression(fsb.getFromHops().getInput().get(0), memo);
            long to = OptimizerUtils.rEvalSimpleLongExpression(fsb.getToHops().getInput().get(0), memo);
            long l = fsb.getIncrementHops() == null ? (from < to ? 1L : -1L) : (increment = OptimizerUtils.rEvalSimpleLongExpression(fsb.getIncrementHops().getInput().get(0), memo));
            if (from != Long.MAX_VALUE && to != Long.MAX_VALUE && increment != Long.MAX_VALUE) {
                return (int)Math.ceil((double)(to - from + 1L) / (double)increment);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return defaultValue;
    }

    public static long getNumIterations(ForProgramBlock fpb, LocalVariableMap vars, long defaultValue) {
        if (fpb.getStatementBlock() == null) {
            return defaultValue;
        }
        ForStatementBlock fsb = (ForStatementBlock)fpb.getStatementBlock();
        try {
            long increment;
            HashMap<Long, Long> memo = new HashMap<Long, Long>();
            long from = OptimizerUtils.rEvalSimpleLongExpression(fsb.getFromHops().getInput().get(0), memo, vars);
            long to = OptimizerUtils.rEvalSimpleLongExpression(fsb.getToHops().getInput().get(0), memo, vars);
            long l = fsb.getIncrementHops() == null ? (from < to ? 1L : -1L) : (increment = OptimizerUtils.rEvalSimpleLongExpression(fsb.getIncrementHops().getInput().get(0), memo));
            if (from != Long.MAX_VALUE && to != Long.MAX_VALUE && increment != Long.MAX_VALUE) {
                return (int)Math.ceil((double)(to - from + 1L) / (double)increment);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return defaultValue;
    }

    public static long rEvalSimpleLongExpression(Hop root, HashMap<Long, Long> valMemo) {
        long ret = Long.MAX_VALUE;
        HashMap<Long, Double> dvalMemo = new HashMap<Long, Double>();
        double tmp = OptimizerUtils.rEvalSimpleDoubleExpression(root, dvalMemo);
        if (tmp != Double.MAX_VALUE) {
            ret = UtilFunctions.toLong(tmp);
        }
        return ret;
    }

    public static long rEvalSimpleLongExpression(Hop root, HashMap<Long, Long> valMemo, LocalVariableMap vars) {
        long ret = Long.MAX_VALUE;
        HashMap<Long, Double> dvalMemo = new HashMap<Long, Double>();
        double tmp = OptimizerUtils.rEvalSimpleDoubleExpression(root, dvalMemo, vars);
        if (tmp != Double.MAX_VALUE) {
            ret = UtilFunctions.toLong(tmp);
        }
        return ret;
    }

    public static double rEvalSimpleDoubleExpression(Hop root, HashMap<Long, Double> valMemo) {
        if (valMemo.containsKey(root.getHopID())) {
            return valMemo.get(root.getHopID());
        }
        double ret = Double.MAX_VALUE;
        if (root instanceof LiteralOp) {
            ret = HopRewriteUtils.getDoubleValue((LiteralOp)root);
        }
        if (ALLOW_SIZE_EXPRESSION_EVALUATION) {
            if (root instanceof UnaryOp) {
                ret = OptimizerUtils.rEvalSimpleUnaryDoubleExpression(root, valMemo);
            } else if (root instanceof BinaryOp) {
                ret = OptimizerUtils.rEvalSimpleBinaryDoubleExpression(root, valMemo);
            }
        }
        valMemo.put(root.getHopID(), ret);
        return ret;
    }

    public static double rEvalSimpleDoubleExpression(Hop root, HashMap<Long, Double> valMemo, LocalVariableMap vars) {
        if (valMemo.containsKey(root.getHopID())) {
            return valMemo.get(root.getHopID());
        }
        double ret = Double.MAX_VALUE;
        if (ALLOW_SIZE_EXPRESSION_EVALUATION) {
            String name;
            Data dat;
            if (root instanceof LiteralOp) {
                ret = HopRewriteUtils.getDoubleValue((LiteralOp)root);
            } else if (root instanceof UnaryOp) {
                ret = OptimizerUtils.rEvalSimpleUnaryDoubleExpression(root, valMemo, vars);
            } else if (root instanceof BinaryOp) {
                ret = OptimizerUtils.rEvalSimpleBinaryDoubleExpression(root, valMemo, vars);
            } else if (root instanceof DataOp && (dat = vars.get(name = root.getName())) != null && dat instanceof ScalarObject) {
                ret = ((ScalarObject)dat).getDoubleValue();
            }
        }
        valMemo.put(root.getHopID(), ret);
        return ret;
    }

    protected static double rEvalSimpleUnaryDoubleExpression(Hop root, HashMap<Long, Double> valMemo) {
        if (valMemo.containsKey(root.getHopID())) {
            return valMemo.get(root.getHopID());
        }
        double ret = Double.MAX_VALUE;
        UnaryOp uroot = (UnaryOp)root;
        Hop input = uroot.getInput().get(0);
        if (uroot.getOp() == Hop.OpOp1.NROW) {
            ret = input.rowsKnown() ? (double)input.getDim1() : Double.MAX_VALUE;
        } else if (uroot.getOp() == Hop.OpOp1.NCOL) {
            ret = input.colsKnown() ? (double)input.getDim2() : Double.MAX_VALUE;
        } else {
            double lval = OptimizerUtils.rEvalSimpleDoubleExpression(uroot.getInput().get(0), valMemo);
            if (lval != Double.MAX_VALUE) {
                switch (uroot.getOp()) {
                    case SQRT: {
                        ret = Math.sqrt(lval);
                        break;
                    }
                    case ROUND: {
                        ret = Math.round(lval);
                        break;
                    }
                    case CEIL: {
                        ret = Math.ceil(lval);
                        break;
                    }
                    case FLOOR: {
                        ret = Math.floor(lval);
                        break;
                    }
                    case CAST_AS_BOOLEAN: {
                        ret = lval != 0.0 ? 1.0 : 0.0;
                        break;
                    }
                    case CAST_AS_INT: {
                        ret = UtilFunctions.toLong(lval);
                        break;
                    }
                    case CAST_AS_DOUBLE: {
                        ret = lval;
                        break;
                    }
                    default: {
                        ret = Double.MAX_VALUE;
                    }
                }
            }
        }
        valMemo.put(root.getHopID(), ret);
        return ret;
    }

    protected static double rEvalSimpleUnaryDoubleExpression(Hop root, HashMap<Long, Double> valMemo, LocalVariableMap vars) {
        if (valMemo.containsKey(root.getHopID())) {
            return valMemo.get(root.getHopID());
        }
        double ret = Double.MAX_VALUE;
        UnaryOp uroot = (UnaryOp)root;
        Hop input = uroot.getInput().get(0);
        if (uroot.getOp() == Hop.OpOp1.NROW) {
            ret = input.rowsKnown() ? (double)input.getDim1() : Double.MAX_VALUE;
        } else if (uroot.getOp() == Hop.OpOp1.NCOL) {
            ret = input.colsKnown() ? (double)input.getDim2() : Double.MAX_VALUE;
        } else {
            double lval = OptimizerUtils.rEvalSimpleDoubleExpression(uroot.getInput().get(0), valMemo, vars);
            if (lval != Double.MAX_VALUE) {
                switch (uroot.getOp()) {
                    case SQRT: {
                        ret = Math.sqrt(lval);
                        break;
                    }
                    case ROUND: {
                        ret = Math.round(lval);
                        break;
                    }
                    case CEIL: {
                        ret = Math.ceil(lval);
                        break;
                    }
                    case FLOOR: {
                        ret = Math.floor(lval);
                        break;
                    }
                    case CAST_AS_BOOLEAN: {
                        ret = lval != 0.0 ? 1.0 : 0.0;
                        break;
                    }
                    case CAST_AS_INT: {
                        ret = UtilFunctions.toLong(lval);
                        break;
                    }
                    case CAST_AS_DOUBLE: {
                        ret = lval;
                        break;
                    }
                    default: {
                        ret = Double.MAX_VALUE;
                    }
                }
            }
        }
        valMemo.put(root.getHopID(), ret);
        return ret;
    }

    protected static double rEvalSimpleBinaryDoubleExpression(Hop root, HashMap<Long, Double> valMemo) {
        if (valMemo.containsKey(root.getHopID())) {
            return valMemo.get(root.getHopID());
        }
        double ret = Double.MAX_VALUE;
        BinaryOp broot = (BinaryOp)root;
        double lret = OptimizerUtils.rEvalSimpleDoubleExpression(broot.getInput().get(0), valMemo);
        double rret = OptimizerUtils.rEvalSimpleDoubleExpression(broot.getInput().get(1), valMemo);
        if (lret != Double.MAX_VALUE && rret != Double.MAX_VALUE) {
            switch (broot.getOp()) {
                case PLUS: {
                    ret = lret + rret;
                    break;
                }
                case MINUS: {
                    ret = lret - rret;
                    break;
                }
                case MULT: {
                    ret = lret * rret;
                    break;
                }
                case DIV: {
                    ret = lret / rret;
                    break;
                }
                case MIN: {
                    ret = Math.min(lret, rret);
                    break;
                }
                case MAX: {
                    ret = Math.max(lret, rret);
                    break;
                }
                case POW: {
                    ret = Math.pow(lret, rret);
                    break;
                }
                case MODULUS: {
                    ret = Modulus.getFnObject().execute(lret, rret);
                    break;
                }
                case INTDIV: {
                    ret = IntegerDivide.getFnObject().execute(lret, rret);
                    break;
                }
                default: {
                    ret = Double.MAX_VALUE;
                }
            }
        }
        valMemo.put(root.getHopID(), ret);
        return ret;
    }

    protected static double rEvalSimpleBinaryDoubleExpression(Hop root, HashMap<Long, Double> valMemo, LocalVariableMap vars) {
        if (valMemo.containsKey(root.getHopID())) {
            return valMemo.get(root.getHopID());
        }
        double ret = Double.MAX_VALUE;
        BinaryOp broot = (BinaryOp)root;
        double lret = OptimizerUtils.rEvalSimpleDoubleExpression(broot.getInput().get(0), valMemo, vars);
        double rret = OptimizerUtils.rEvalSimpleDoubleExpression(broot.getInput().get(1), valMemo, vars);
        if (lret != Double.MAX_VALUE && rret != Double.MAX_VALUE) {
            switch (broot.getOp()) {
                case PLUS: {
                    ret = lret + rret;
                    break;
                }
                case MINUS: {
                    ret = lret - rret;
                    break;
                }
                case MULT: {
                    ret = lret * rret;
                    break;
                }
                case DIV: {
                    ret = lret / rret;
                    break;
                }
                case MIN: {
                    ret = Math.min(lret, rret);
                    break;
                }
                case MAX: {
                    ret = Math.max(lret, rret);
                    break;
                }
                case POW: {
                    ret = Math.pow(lret, rret);
                    break;
                }
                case MODULUS: {
                    ret = Modulus.getFnObject().execute(lret, rret);
                    break;
                }
                case INTDIV: {
                    ret = IntegerDivide.getFnObject().execute(lret, rret);
                    break;
                }
                default: {
                    ret = Double.MAX_VALUE;
                }
            }
        }
        valMemo.put(root.getHopID(), ret);
        return ret;
    }

    static {
        MAX_NNZ_CP_SPARSE = MatrixBlock.DEFAULT_SPARSEBLOCK == SparseBlock.Type.MCSR ? Long.MAX_VALUE : Integer.MAX_VALUE;
        ALLOW_COMMON_SUBEXPRESSION_ELIMINATION = true;
        ALLOW_CONSTANT_FOLDING = true;
        ALLOW_ALGEBRAIC_SIMPLIFICATION = true;
        ALLOW_OPERATOR_FUSION = true;
        ALLOW_BRANCH_REMOVAL = true;
        ALLOW_AUTO_VECTORIZATION = true;
        ALLOW_SIZE_EXPRESSION_EVALUATION = true;
        ALLOW_WORSTCASE_SIZE_EXPRESSION_EVALUATION = true;
        ALLOW_RAND_JOB_RECOMPILE = true;
        ALLOW_RUNTIME_PIGGYBACKING = true;
        ALLOW_INTER_PROCEDURAL_ANALYSIS = true;
        IPA_NUM_REPETITIONS = 3;
        ALLOW_SUM_PRODUCT_REWRITES = true;
        ALLOW_SPLIT_HOP_DAGS = true;
        ALLOW_LOOP_UPDATE_IN_PLACE = true;
        ALLOW_CODE_MOTION = false;
    }

    public static enum OptimizationLevel {
        O0_LOCAL_STATIC,
        O1_LOCAL_MEMORY_MIN,
        O2_LOCAL_MEMORY_DEFAULT,
        O3_LOCAL_RESOURCE_TIME_MEMORY,
        O4_GLOBAL_TIME_MEMORY,
        O5_DEBUG_MODE;

    }
}

