/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.yarn;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.sysml.conf.DMLConfig;
import org.apache.sysml.hops.OptimizerUtils;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.controlprogram.Program;
import org.apache.sysml.runtime.controlprogram.ProgramBlock;
import org.apache.sysml.yarn.DMLAppMasterUtils;
import org.apache.sysml.yarn.DMLYarnClient;
import org.apache.sysml.yarn.ropt.ResourceConfig;
import org.apache.sysml.yarn.ropt.ResourceOptimizer;
import org.apache.sysml.yarn.ropt.YarnClusterAnalyzer;
import org.apache.sysml.yarn.ropt.YarnClusterConfig;
import org.apache.sysml.yarn.ropt.YarnOptimizerUtils;

public class DMLYarnClientProxy {
    private static final Log LOG = LogFactory.getLog(DMLYarnClientProxy.class);
    protected static boolean RESOURCE_OPTIMIZER = false;
    protected static boolean LDEBUG = false;

    public static boolean launchDMLYarnAppmaster(String dmlScriptStr, DMLConfig conf, String[] allArgs, Program rtprog) throws IOException, DMLRuntimeException {
        boolean ret = false;
        try {
            if (DMLAppMasterUtils.isResourceOptimizerEnabled()) {
                LOG.warn("Optimization level '" + (Object)((Object)OptimizerUtils.OptimizationLevel.O3_LOCAL_RESOURCE_TIME_MEMORY) + "' is still in experimental state and not intended for production use.");
                YarnClusterConfig cc = YarnClusterAnalyzer.getClusterConfig();
                DMLAppMasterUtils.setupRemoteParallelTasks(cc);
                ArrayList<ProgramBlock> pb = DMLAppMasterUtils.getRuntimeProgramBlocks(rtprog);
                ResourceConfig rc = ResourceOptimizer.optimizeResourceConfig(pb, cc, YarnOptimizerUtils.GridEnumType.HYBRID_MEM_EXP_GRID, YarnOptimizerUtils.GridEnumType.HYBRID_MEM_EXP_GRID);
                conf.updateYarnMemorySettings(String.valueOf(YarnOptimizerUtils.toMB(rc.getCPResource())), rc.serialize());
            }
            DMLYarnClient yclient = new DMLYarnClient(dmlScriptStr, conf, allArgs);
            ret = yclient.launchDMLYarnAppmaster();
        }
        catch (NoClassDefFoundError ex) {
            LOG.warn("Failed to instantiate DML yarn client (NoClassDefFoundError: " + ex.getMessage() + "). Resume with default client processing.");
            ret = false;
        }
        return ret;
    }

    static {
        if (LDEBUG) {
            Logger.getLogger("org.apache.sysml.yarn").setLevel(Level.DEBUG);
        }
    }
}

