/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.hops.codegen;

import java.util.ArrayList;
import org.apache.sysml.hops.Hop;
import org.apache.sysml.hops.MemoTable;
import org.apache.sysml.hops.MultiThreadedHop;
import org.apache.sysml.hops.OptimizerUtils;
import org.apache.sysml.lops.Lop;
import org.apache.sysml.lops.LopProperties;
import org.apache.sysml.lops.SpoofFused;
import org.apache.sysml.parser.Expression;
import org.apache.sysml.runtime.codegen.SpoofRowwise;
import org.apache.sysml.runtime.matrix.MatrixCharacteristics;

public class SpoofFusedOp
extends MultiThreadedHop {
    private Class<?> _class = null;
    private boolean _distSupported = false;
    private long _constDim2 = -1L;
    private SpoofOutputDimsType _dimsType;

    public SpoofFusedOp() {
    }

    public SpoofFusedOp(String name, Expression.DataType dt, Expression.ValueType vt, Class<?> cla, boolean dist, SpoofOutputDimsType type) {
        super(name, dt, vt);
        this._class = cla;
        this._distSupported = dist;
        this._dimsType = type;
    }

    @Override
    public void checkArity() {
    }

    @Override
    public boolean allowsAllExecTypes() {
        return this._distSupported;
    }

    public void setConstDim2(long constDim2) {
        this._constDim2 = constDim2;
    }

    @Override
    protected double computeOutputMemEstimate(long dim1, long dim2, long nnz) {
        return this._class.getGenericSuperclass().equals(SpoofRowwise.class) ? (double)OptimizerUtils.estimateSize(dim1, dim2) : (double)OptimizerUtils.estimatePartitionedSizeExactSparsity(dim1, dim2, (long)this.getRowsInBlock(), (long)this.getColsInBlock(), nnz);
    }

    @Override
    protected double computeIntermediateMemEstimate(long dim1, long dim2, long nnz) {
        return 0.0;
    }

    @Override
    public Lop constructLops() {
        if (this.getLops() != null) {
            return this.getLops();
        }
        LopProperties.ExecType et = this.optFindExecType();
        ArrayList<Lop> inputs = new ArrayList<Lop>();
        for (Hop c : this.getInput()) {
            inputs.add(c.constructLops());
        }
        int k = OptimizerUtils.getConstrainedNumThreads(this._maxNumThreads);
        SpoofFused lop = new SpoofFused(inputs, this.getDataType(), this.getValueType(), this._class, k, et);
        this.setOutputDimensions(lop);
        this.setLineNumbers(lop);
        this.setLops(lop);
        return lop;
    }

    @Override
    protected LopProperties.ExecType optFindExecType() {
        this.checkAndSetForcedPlatform();
        if (this._etypeForced != null) {
            this._etype = this._etypeForced;
        } else {
            this._etype = this.findExecTypeByMemEstimate();
            this.checkAndSetInvalidCPDimsAndSize();
        }
        if (this._etype == LopProperties.ExecType.MR) {
            this._etype = LopProperties.ExecType.CP;
        }
        return this._etype;
    }

    @Override
    public String getOpString() {
        return "spoof(" + this._class.getSimpleName() + ")";
    }

    @Override
    protected long[] inferOutputCharacteristics(MemoTable memo) {
        long[] ret = null;
        MatrixCharacteristics mc = memo.getAllInputStats(this.getInput().get(0));
        if (mc.dimsKnown()) {
            switch (this._dimsType) {
                case ROW_DIMS: {
                    ret = new long[]{mc.getRows(), 1L, -1L};
                    break;
                }
                case COLUMN_DIMS_ROWS: {
                    ret = new long[]{mc.getCols(), 1L, -1L};
                    break;
                }
                case COLUMN_DIMS_COLS: {
                    ret = new long[]{1L, mc.getCols(), -1L};
                    break;
                }
                case RANK_DIMS_COLS: {
                    MatrixCharacteristics mc2 = memo.getAllInputStats(this.getInput().get(1));
                    if (!mc2.dimsKnown()) break;
                    ret = new long[]{1L, mc2.getCols(), -1L};
                    break;
                }
                case INPUT_DIMS: {
                    ret = new long[]{mc.getRows(), mc.getCols(), -1L};
                    break;
                }
                case INPUT_DIMS_CONST2: {
                    ret = new long[]{mc.getRows(), this._constDim2, -1L};
                    break;
                }
                case VECT_CONST2: {
                    ret = new long[]{1L, this._constDim2, -1L};
                    break;
                }
                case SCALAR: {
                    ret = new long[]{0L, 0L, -1L};
                    break;
                }
                case MULTI_SCALAR: {
                    ret = new long[]{1L, this._dim2, -1L};
                    break;
                }
                case ROW_RANK_DIMS: {
                    MatrixCharacteristics mc2 = memo.getAllInputStats(this.getInput().get(1));
                    if (!mc2.dimsKnown()) break;
                    ret = new long[]{mc.getRows(), mc2.getCols(), -1L};
                    break;
                }
                case COLUMN_RANK_DIMS: {
                    MatrixCharacteristics mc2 = memo.getAllInputStats(this.getInput().get(1));
                    if (!mc2.dimsKnown()) break;
                    ret = new long[]{mc.getCols(), mc2.getCols(), -1L};
                    break;
                }
                case COLUMN_RANK_DIMS_T: {
                    MatrixCharacteristics mc2 = memo.getAllInputStats(this.getInput().get(1));
                    if (!mc2.dimsKnown()) break;
                    ret = new long[]{mc2.getCols(), mc.getCols(), -1L};
                    break;
                }
                default: {
                    throw new RuntimeException("Failed to infer worst-case size information for type: " + this._dimsType.toString());
                }
            }
        }
        return ret;
    }

    @Override
    public void refreshSizeInformation() {
        switch (this._dimsType) {
            case ROW_DIMS: {
                this.setDim1(this.getInput().get(0).getDim1());
                this.setDim2(1L);
                break;
            }
            case COLUMN_DIMS_ROWS: {
                this.setDim1(this.getInput().get(0).getDim2());
                this.setDim2(1L);
                break;
            }
            case COLUMN_DIMS_COLS: {
                this.setDim1(1L);
                this.setDim2(this.getInput().get(0).getDim2());
                break;
            }
            case RANK_DIMS_COLS: {
                this.setDim1(1L);
                this.setDim2(this.getInput().get(1).getDim2());
                break;
            }
            case INPUT_DIMS: {
                this.setDim1(this.getInput().get(0).getDim1());
                this.setDim2(this.getInput().get(0).getDim2());
                break;
            }
            case INPUT_DIMS_CONST2: {
                this.setDim1(this.getInput().get(0).getDim1());
                this.setDim2(this._constDim2);
                break;
            }
            case VECT_CONST2: {
                this.setDim1(1L);
                this.setDim2(this._constDim2);
                break;
            }
            case SCALAR: {
                this.setDim1(0L);
                this.setDim2(0L);
                break;
            }
            case MULTI_SCALAR: {
                this.setDim1(1L);
                break;
            }
            case ROW_RANK_DIMS: {
                this.setDim1(this.getInput().get(0).getDim1());
                this.setDim2(this.getInput().get(1).getDim2());
                break;
            }
            case COLUMN_RANK_DIMS: {
                this.setDim1(this.getInput().get(0).getDim2());
                this.setDim2(this.getInput().get(1).getDim2());
                break;
            }
            case COLUMN_RANK_DIMS_T: {
                this.setDim1(this.getInput().get(1).getDim2());
                this.setDim2(this.getInput().get(0).getDim2());
                break;
            }
            default: {
                throw new RuntimeException("Failed to refresh size information for type: " + this._dimsType.toString());
            }
        }
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        SpoofFusedOp ret = new SpoofFusedOp();
        ret.clone(this, false);
        ret._class = this._class;
        ret._distSupported = this._distSupported;
        ret._maxNumThreads = this._maxNumThreads;
        ret._constDim2 = this._constDim2;
        ret._dimsType = this._dimsType;
        return ret;
    }

    @Override
    public boolean compare(Hop that) {
        boolean ret;
        if (!(that instanceof SpoofFusedOp)) {
            return false;
        }
        SpoofFusedOp that2 = (SpoofFusedOp)that;
        boolean bl = ret = this._class.equals(that2._class) && this._distSupported == that2._distSupported && this._maxNumThreads == that2._maxNumThreads && this._constDim2 == that2._constDim2 && this.getInput().size() == that2.getInput().size();
        if (ret) {
            for (int i = 0; i < this.getInput().size(); ++i) {
                ret &= this.getInput().get(i) == that2.getInput().get(i);
            }
        }
        return ret;
    }

    @Override
    public boolean isGPUEnabled() {
        return false;
    }

    public static enum SpoofOutputDimsType {
        INPUT_DIMS,
        INPUT_DIMS_CONST2,
        ROW_DIMS,
        COLUMN_DIMS_ROWS,
        COLUMN_DIMS_COLS,
        RANK_DIMS_COLS,
        SCALAR,
        MULTI_SCALAR,
        ROW_RANK_DIMS,
        COLUMN_RANK_DIMS,
        COLUMN_RANK_DIMS_T,
        VECT_CONST2;

    }
}

