/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.io;

import java.io.Serializable;
import java.util.StringTokenizer;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.io.FileFormatProperties;

public class FileFormatPropertiesMM
extends FileFormatProperties
implements Serializable {
    private static final long serialVersionUID = -2870393360885401604L;
    private final MMFormat _fmt;
    private final MMField _field;
    private final MMSymmetry _symmetry;

    public FileFormatPropertiesMM() {
        this(MMFormat.COORDINATE, MMField.REAL, MMSymmetry.GENERAL);
    }

    public FileFormatPropertiesMM(MMFormat fmt, MMField field, MMSymmetry symmetry) {
        this._fmt = fmt;
        this._field = field;
        this._symmetry = symmetry;
        if (this._field == MMField.PATTERN && (this._fmt == MMFormat.ARRAY || this._symmetry == MMSymmetry.SKEW_SYMMETRIC)) {
            throw new DMLRuntimeException("MatrixMarket: Invalid combination: " + this._fmt.toString() + " " + this._field.toString() + " " + this._symmetry.toString() + ".");
        }
    }

    public MMFormat getFormat() {
        return this._fmt;
    }

    public MMField getField() {
        return this._field;
    }

    public MMSymmetry getSymmetry() {
        return this._symmetry;
    }

    public boolean isIntField() {
        return this._field == MMField.INTEGER;
    }

    public boolean isPatternField() {
        return this._field == MMField.PATTERN;
    }

    public boolean isSymmetric() {
        return this._symmetry == MMSymmetry.SYMMETRIC || this._symmetry == MMSymmetry.SKEW_SYMMETRIC;
    }

    public static FileFormatPropertiesMM parse(String header) {
        StringTokenizer st = new StringTokenizer(header, " ");
        int numTokens = st.countTokens();
        if (numTokens != 5) {
            throw new DMLRuntimeException("MatrixMarket: Incorrect number of header tokens: " + numTokens + " (expeced: 5).");
        }
        String type = st.nextToken();
        if (!type.equals("%%MatrixMarket")) {
            throw new DMLRuntimeException("MatrixMarket: Incorrect header start: " + type + " (expected: %%MatrixMarket).");
        }
        String object = st.nextToken();
        if (!object.equals("matrix")) {
            throw new DMLRuntimeException("MatrixMarket: Incorrect object: " + object + " (expected: matrix).");
        }
        String format = st.nextToken();
        MMFormat fmt = null;
        switch (format) {
            case "coordinate": {
                fmt = MMFormat.COORDINATE;
                break;
            }
            default: {
                throw new DMLRuntimeException("MatrixMarket: Incorrect format: " + format + " (expected coordinate).");
            }
        }
        String field = st.nextToken();
        MMField f = null;
        switch (field) {
            case "real": {
                f = MMField.REAL;
                break;
            }
            case "integer": {
                f = MMField.INTEGER;
                break;
            }
            case "pattern": {
                f = MMField.PATTERN;
                break;
            }
            default: {
                throw new DMLRuntimeException("MatrixMarket: Incorrect field: " + field + " (expected real | integer | pattern).");
            }
        }
        String symmetry = st.nextToken();
        MMSymmetry s = null;
        switch (symmetry) {
            case "general": {
                s = MMSymmetry.GENERAL;
                break;
            }
            case "symmetric": {
                s = MMSymmetry.SYMMETRIC;
                break;
            }
            default: {
                throw new DMLRuntimeException("MatrixMarket: Incorrect symmetry: " + symmetry + " (expected general | symmetric).");
            }
        }
        return new FileFormatPropertiesMM(fmt, f, s);
    }

    public static enum MMSymmetry {
        GENERAL,
        SYMMETRIC,
        SKEW_SYMMETRIC;


        public String toString() {
            return this.name().toLowerCase().replaceAll("_", "-");
        }
    }

    public static enum MMField {
        REAL,
        INTEGER,
        COMPLEX,
        PATTERN;


        public String toString() {
            return this.name().toLowerCase();
        }
    }

    public static enum MMFormat {
        COORDINATE,
        ARRAY;


        public String toString() {
            return this.name().toLowerCase();
        }
    }
}

