/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.scripts.nn.layers;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.apache.sysml.api.mlcontext.MLResults;
import org.apache.sysml.api.mlcontext.Matrix;
import org.apache.sysml.api.mlcontext.Script;

public class L1_loss
extends Script {
    public L1_loss() {
        String string = "scripts/nn/layers/l1_loss.dml";
        InputStream inputStream = Script.class.getResourceAsStream(new StringBuffer().append("/").append(string).toString());
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        char[] cArray = new char[1024];
        StringBuilder stringBuilder = new StringBuilder();
        try {
            int n;
            while ((n = inputStreamReader.read(cArray)) > 0) {
                stringBuilder.append(cArray, 0, n);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.setScriptString(stringBuilder.toString());
    }

    public double forward(Object object, Object object2) {
        String string = "source('scripts/nn/layers/l1_loss.dml') as mlcontextns;loss = mlcontextns::forward(pred, y);";
        Script script = new Script(string);
        script.in("pred", object).in("y", object2).out("loss");
        MLResults mLResults = script.execute();
        double d = mLResults.getDouble("loss");
        return d;
    }

    public String forward__docs() {
        String string = "forward = function(matrix[double] pred, matrix[double] y)\n    return (double loss) {\n  /*\n   * Computes the forward pass for an L1 loss function.  The inputs\n   * consist of N examples, each with M dimensions to predict.\n   *\n   *   ```\n   *   L_i = sum_j(abs((pred_i)_j - (y_i)_j)) for all j.\n   *   L = (1/N) sum(L_i) for i=1 to N\n   *   ```\n   *\n   * In these equations, `L` is the total loss, `L_i` is the loss for\n   * example `i`, `y_i` is the scalar target, `pred_i` is the scalar\n   * prediction, and `N` is the number of examples.\n   *\n   * This can be interpreted as the negative log-likelihood assuming\n   * a Laplace distribution.\n   *\n   * Inputs:\n   *  - pred: Predictions, of shape (N, M).\n   *  - y: Targets, of shape (N, M).\n   *\n   * Outputs:\n   *  - loss: Average loss.\n   */\n";
        return string;
    }

    public String forward__source() {
        String string = "forward = function(matrix[double] pred, matrix[double] y)\n    return (double loss) {\n  /*\n   * Computes the forward pass for an L1 loss function.  The inputs\n   * consist of N examples, each with M dimensions to predict.\n   *\n   *   ```\n   *   L_i = sum_j(abs((pred_i)_j - (y_i)_j)) for all j.\n   *   L = (1/N) sum(L_i) for i=1 to N\n   *   ```\n   *\n   * In these equations, `L` is the total loss, `L_i` is the loss for\n   * example `i`, `y_i` is the scalar target, `pred_i` is the scalar\n   * prediction, and `N` is the number of examples.\n   *\n   * This can be interpreted as the negative log-likelihood assuming\n   * a Laplace distribution.\n   *\n   * Inputs:\n   *  - pred: Predictions, of shape (N, M).\n   *  - y: Targets, of shape (N, M).\n   *\n   * Outputs:\n   *  - loss: Average loss.\n   */\n  N = nrow(y)\n  losses = rowSums(abs(pred-y))\n  loss = sum(losses) / N\n}\n";
        return string;
    }

    public Matrix backward(Object object, Object object2) {
        String string = "source('scripts/nn/layers/l1_loss.dml') as mlcontextns;dpred = mlcontextns::backward(pred, y);";
        Script script = new Script(string);
        script.in("pred", object).in("y", object2).out("dpred");
        MLResults mLResults = script.execute();
        Matrix matrix = mLResults.getMatrix("dpred");
        return matrix;
    }

    public String backward__docs() {
        String string = "backward = function(matrix[double] pred, matrix[double] y)\n    return (matrix[double] dpred) {\n  /*\n   * Computes the backward pass for an L1 loss function.  The inputs\n   * consist of N examples, each with M dimensions to predict.\n   *\n   * Inputs:\n   *  - pred: Predictions, of shape (N, M).\n   *  - y: Targets, of shape (N, M).\n   *\n   * Outputs:\n   *  - dpred: Gradient wrt `pred`, of shape (N, M).\n   */\n";
        return string;
    }

    public String backward__source() {
        String string = "backward = function(matrix[double] pred, matrix[double] y)\n    return (matrix[double] dpred) {\n  /*\n   * Computes the backward pass for an L1 loss function.  The inputs\n   * consist of N examples, each with M dimensions to predict.\n   *\n   * Inputs:\n   *  - pred: Predictions, of shape (N, M).\n   *  - y: Targets, of shape (N, M).\n   *\n   * Outputs:\n   *  - dpred: Gradient wrt `pred`, of shape (N, M).\n   */\n  N = nrow(y)\n  dpred = sign(pred-y) / N\n}\n";
        return string;
    }
}

