/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.estim;

import org.apache.sysds.runtime.compress.CompressionSettings;
import org.apache.sysds.runtime.compress.estim.CompressedSizeEstimator;
import org.apache.sysds.runtime.compress.estim.CompressedSizeEstimatorExact;
import org.apache.sysds.runtime.compress.estim.CompressedSizeEstimatorSample;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;

public class CompressedSizeEstimatorFactory {
    public static CompressedSizeEstimator getSizeEstimator(MatrixBlock data, CompressionSettings compSettings) {
        long elements = compSettings.transposeInput ? (long)data.getNumColumns() : (long)data.getNumRows();
        elements = data.getNonZeros() / (long)(compSettings.transposeInput ? data.getNumRows() : data.getNumColumns());
        return compSettings.samplingRatio >= 1.0 || elements < 1000L ? new CompressedSizeEstimatorExact(data, compSettings) : new CompressedSizeEstimatorSample(data, compSettings, (int)Math.ceil((double)elements * compSettings.samplingRatio));
    }
}

