/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.io.hdf5.message;

import java.nio.ByteBuffer;
import java.util.BitSet;
import org.apache.sysds.runtime.io.hdf5.H5BufferBuilder;
import org.apache.sysds.runtime.io.hdf5.H5RootObject;
import org.apache.sysds.runtime.io.hdf5.Utils;
import org.apache.sysds.runtime.io.hdf5.message.H5Message;

public class H5SymbolTableMessage
extends H5Message {
    private final long bTreeAddress;
    private final long localHeapAddress;

    public H5SymbolTableMessage(H5RootObject rootObject, BitSet flags, ByteBuffer bb) {
        super(rootObject, flags);
        this.bTreeAddress = Utils.readBytesAsUnsignedLong(bb, rootObject.getSuperblock().sizeOfOffsets);
        this.localHeapAddress = Utils.readBytesAsUnsignedLong(bb, rootObject.getSuperblock().sizeOfOffsets);
    }

    public H5SymbolTableMessage(H5RootObject rootObject, BitSet flags, long bTreeAddress, long localHeapAddress) {
        super(rootObject, flags);
        this.bTreeAddress = bTreeAddress;
        this.localHeapAddress = localHeapAddress;
    }

    @Override
    public void toBuffer(H5BufferBuilder bb) {
        super.toBuffer(bb, 17);
        bb.writeLong(this.bTreeAddress);
        bb.writeLong(this.localHeapAddress);
    }

    public long getbTreeAddress() {
        return this.bTreeAddress;
    }

    public long getLocalHeapAddress() {
        return this.localHeapAddress;
    }
}

