/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.controlprogram.federated.monitoring.services;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.sysds.runtime.controlprogram.federated.monitoring.models.BaseEntityModel;
import org.apache.sysds.runtime.controlprogram.federated.monitoring.models.NodeEntityModel;
import org.apache.sysds.runtime.controlprogram.federated.monitoring.models.StatsEntityModel;
import org.apache.sysds.runtime.controlprogram.federated.monitoring.repositories.DerbyRepository;
import org.apache.sysds.runtime.controlprogram.federated.monitoring.repositories.EntityEnum;
import org.apache.sysds.runtime.controlprogram.federated.monitoring.repositories.IRepository;
import org.apache.sysds.runtime.controlprogram.federated.monitoring.services.StatsService;

public class WorkerService {
    private static final IRepository _entityRepository = new DerbyRepository();
    private static final Map<Long, String> _cachedWorkers = new HashMap<Long, String>();

    public WorkerService() {
        this.updateCachedWorkers(null);
        ScheduledExecutorService executor = Executors.newScheduledThreadPool(1);
        executor.scheduleAtFixedRate(WorkerService.syncWorkerStatisticsWithDB(), 0L, 3L, TimeUnit.SECONDS);
    }

    public void create(BaseEntityModel model) {
        long id = _entityRepository.createEntity(EntityEnum.WORKER, model);
        NodeEntityModel modelEntity = (NodeEntityModel)model;
        _cachedWorkers.putIfAbsent(id, modelEntity.getAddress());
    }

    public void update(BaseEntityModel model) {
        _entityRepository.updateEntity(EntityEnum.WORKER, model);
    }

    public void remove(Long id) {
        _entityRepository.removeEntity(EntityEnum.WORKER, id);
        _cachedWorkers.remove(id);
    }

    public BaseEntityModel get(Long id) {
        NodeEntityModel model = (NodeEntityModel)_entityRepository.getEntity(EntityEnum.WORKER, id);
        List<BaseEntityModel> stats = _entityRepository.getAllEntitiesByField(EntityEnum.WORKER_STATS, id);
        this.updateCachedWorkers(null);
        model.setStats(stats);
        return model;
    }

    public List<BaseEntityModel> getAll() {
        List<BaseEntityModel> workersRaw = _entityRepository.getAllEntities(EntityEnum.WORKER);
        ArrayList<BaseEntityModel> workersResult = new ArrayList<BaseEntityModel>();
        this.updateCachedWorkers(workersRaw);
        for (BaseEntityModel worker : workersRaw) {
            NodeEntityModel workerModel = (NodeEntityModel)worker;
            List<BaseEntityModel> stats = _entityRepository.getAllEntitiesByField(EntityEnum.WORKER_STATS, workerModel.getId());
            workerModel.setStats(stats);
            workersResult.add(workerModel);
        }
        return workersResult;
    }

    private void updateCachedWorkers(List<BaseEntityModel> workersRaw) {
        List<BaseEntityModel> workersBaseModel = workersRaw;
        if (workersBaseModel == null) {
            workersBaseModel = this.getAll();
        }
        for (BaseEntityModel workerBaseModel : workersBaseModel) {
            NodeEntityModel worker = (NodeEntityModel)workerBaseModel;
            _cachedWorkers.putIfAbsent(worker.getId(), worker.getAddress());
        }
    }

    private static Runnable syncWorkerStatisticsWithDB() {
        return () -> {
            for (Map.Entry<Long, String> entry : _cachedWorkers.entrySet()) {
                String address;
                Long id = entry.getKey();
                StatsEntityModel stats = (StatsEntityModel)StatsService.getWorkerStatistics(id, address = entry.getValue());
                if (stats == null) continue;
                _entityRepository.createEntity(EntityEnum.WORKER_STATS, stats);
            }
        };
    }
}

