# -------------------------------------------------------------
#
# Licensed to the Apache Software Foundation (ASF) under one
# or more contributor license agreements.  See the NOTICE file
# distributed with this work for additional information
# regarding copyright ownership.  The ASF licenses this file
# to you under the Apache License, Version 2.0 (the
# "License"); you may not use this file except in compliance
# with the License.  You may obtain a copy of the License at
#
#   http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing,
# software distributed under the License is distributed on an
# "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
# KIND, either express or implied.  See the License for the
# specific language governing permissions and limitations
# under the License.
#
# -------------------------------------------------------------

# Autogenerated By   : src/main/python/generator/generator.py
# Autogenerated From : scripts/builtin/imputeByFDApply.dml

from typing import Dict, Iterable

from systemds.operator import OperationNode, Matrix, Frame, List, MultiReturn, Scalar
from systemds.script_building.dag import OutputType
from systemds.utils.consts import VALID_INPUT_TYPES


def imputeByFDApply(X: Matrix,
                    Y_imp: Matrix):
    """
     Implements builtin for imputing missing values from observed values (if exist) using robust functional dependencies
    
    
    
    :param X: Matrix X
    :param source: source attribute to use for imputation and error correction
    :param target: attribute to be fixed
    :param threshold: threshold value in interval [0, 1] for robust FDs
    :return: Matrix with possible imputations
    """

    params_dict = {'X': X, 'Y_imp': Y_imp}
    return Matrix(X.sds_context,
        'imputeByFDApply',
        named_input_nodes=params_dict)
