/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.utils;

import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sysds.runtime.compress.utils.DCounts;
import org.apache.sysds.runtime.compress.utils.Util;

public class DoubleCountHashMap {
    protected static final Log LOG = LogFactory.getLog((String)DoubleCountHashMap.class.getName());
    protected static final int RESIZE_FACTOR = 2;
    protected static final float LOAD_FACTOR = 0.8f;
    protected int _size = -1;
    private Bucket[] _data = null;

    public DoubleCountHashMap(int init_capacity) {
        this._data = new Bucket[Util.getPow2(init_capacity) / 2 + 7];
        this._size = 0;
    }

    public int size() {
        return this._size;
    }

    private void appendValue(DCounts ent) {
        int ix = this.hashIndex(ent.key);
        Bucket l = this._data[ix];
        if (l == null) {
            this._data[ix] = new Bucket(ent);
        } else {
            while (l != null) {
                l = l.n;
            }
            Bucket ob = this._data[ix];
            this._data[ix] = new Bucket(ent);
            this._data[ix].n = ob;
        }
        ++this._size;
    }

    public final int increment(double key) {
        int ix = this.hashIndex(key);
        Bucket l = this._data[ix];
        while (l != null) {
            if (l.v.key == key) {
                ++l.v.count;
                return l.v.id;
            }
            l = l.n;
        }
        return this.addNewBucket(ix, key);
    }

    public final int increment(double key, int count) {
        int ix = this.hashIndex(key);
        Bucket l = this._data[ix];
        while (l != null) {
            if (l.v.key == key) {
                l.v.count += count;
                return l.v.id;
            }
            l = l.n;
        }
        return this.addNewBucket(ix, key);
    }

    private int addNewBucket(int ix, double key) {
        Bucket ob = this._data[ix];
        this._data[ix] = new Bucket(new DCounts(key, this._size));
        this._data[ix].n = ob;
        int id = this._size++;
        if ((float)this._size >= 0.8f * (float)this._data.length) {
            this.resize();
        }
        return id;
    }

    public int get(double key) {
        try {
            int ix = this.hashIndex(key);
            Bucket l = this._data[ix];
            while (l.v.key != key) {
                l = l.n;
            }
            return l.v.count;
        }
        catch (Exception e) {
            if (Double.isNaN(key)) {
                return this.get(0.0);
            }
            throw e;
        }
    }

    public int getOrDefault(double key, int def) {
        int ix = this.hashIndex(key);
        Bucket l = this._data[ix];
        while (l != null && l.v.key != key) {
            l = l.n;
        }
        if (l == null) {
            return def;
        }
        return l.v.count;
    }

    public DCounts[] extractValues() {
        DCounts[] ret = new DCounts[this._size];
        int i = 0;
        for (Bucket e : this._data) {
            while (e != null) {
                ret[i++] = e.v;
                e = e.n;
            }
        }
        return ret;
    }

    public void replaceWithUIDs() {
        int i = 0;
        for (Bucket e : this._data) {
            while (e != null) {
                e.v.count = i++;
                e = e.n;
            }
        }
    }

    public void replaceWithUIDsNoZero() {
        int i = 0;
        for (Bucket e : this._data) {
            while (e != null) {
                if (e.v.key != 0.0) {
                    e.v.count = i++;
                }
                e = e.n;
            }
        }
    }

    public int[] getUnorderedCountsAndReplaceWithUIDs() {
        int[] counts = new int[this._size];
        int i = 0;
        for (Bucket e : this._data) {
            while (e != null) {
                counts[i] = e.v.count;
                e.v.count = i++;
                e = e.n;
            }
        }
        return counts;
    }

    public int[] getUnorderedCountsAndReplaceWithUIDsWithout0() {
        int[] counts = new int[this._size];
        int i = 0;
        for (Bucket e : this._data) {
            while (e != null) {
                if (e.v.key != 0.0) {
                    counts[i] = e.v.count;
                    e.v.count = i++;
                }
                e = e.n;
            }
        }
        return counts;
    }

    public double getMostFrequent() {
        double f = 0.0;
        int fq = 0;
        for (Bucket e : this._data) {
            while (e != null) {
                if (e.v.count > fq) {
                    fq = e.v.count;
                    f = e.v.key;
                }
                e = e.n;
            }
        }
        return f;
    }

    private void resize() {
        if (this._data.length > 0x3FFFFFFF) {
            return;
        }
        Bucket[] olddata = this._data;
        this._data = new Bucket[this._data.length * 2];
        this._size = 0;
        for (Bucket e : olddata) {
            while (e != null) {
                this.appendValue(e.v);
                e = e.n;
            }
        }
    }

    public double[] getDictionary() {
        double[] ret = new double[this._size];
        for (Bucket e : this._data) {
            while (e != null) {
                ret[e.v.id] = e.v.key;
                e = e.n;
            }
        }
        return ret;
    }

    private final int hashIndex(double key) {
        long bits = Double.doubleToLongBits(key);
        return Math.abs((int)(bits ^ bits >>> 32) % this._data.length);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName() + this.hashCode());
        for (int i = 0; i < this._data.length; ++i) {
            if (this._data[i] == null) continue;
            sb.append(", " + this._data[i]);
        }
        return sb.toString();
    }

    public void reset(int size) {
        int p2 = Util.getPow2(size);
        if (this._data.length > 2 * p2) {
            this._data = new Bucket[p2];
        } else {
            Arrays.fill(this._data, null);
        }
        this._size = 0;
    }

    protected static class Bucket {
        protected DCounts v;
        protected Bucket n = null;

        protected Bucket(DCounts v) {
            this.v = v;
        }

        public String toString() {
            if (this.n == null) {
                return this.v.toString();
            }
            return this.v.toString() + "->" + this.n.toString();
        }
    }
}

