/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.instructions.fed;

import org.apache.commons.lang.ArrayUtils;
import org.apache.sysds.hops.fedplanner.FTypes;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.controlprogram.caching.CacheableData;
import org.apache.sysds.runtime.controlprogram.caching.FrameObject;
import org.apache.sysds.runtime.controlprogram.caching.MatrixObject;
import org.apache.sysds.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysds.runtime.instructions.InstructionUtils;
import org.apache.sysds.runtime.instructions.cp.AggregateUnaryCPInstruction;
import org.apache.sysds.runtime.instructions.cp.CPOperand;
import org.apache.sysds.runtime.instructions.cp.CentralMomentCPInstruction;
import org.apache.sysds.runtime.instructions.cp.Data;
import org.apache.sysds.runtime.instructions.cp.IndexingCPInstruction;
import org.apache.sysds.runtime.instructions.cp.QuantileSortCPInstruction;
import org.apache.sysds.runtime.instructions.cp.ReorgCPInstruction;
import org.apache.sysds.runtime.instructions.cp.ReshapeCPInstruction;
import org.apache.sysds.runtime.instructions.cp.UnaryCPInstruction;
import org.apache.sysds.runtime.instructions.cp.UnaryMatrixCPInstruction;
import org.apache.sysds.runtime.instructions.fed.AggregateUnaryFEDInstruction;
import org.apache.sysds.runtime.instructions.fed.CentralMomentFEDInstruction;
import org.apache.sysds.runtime.instructions.fed.ComputationFEDInstruction;
import org.apache.sysds.runtime.instructions.fed.FEDInstruction;
import org.apache.sysds.runtime.instructions.fed.IndexingFEDInstruction;
import org.apache.sysds.runtime.instructions.fed.QuantileSortFEDInstruction;
import org.apache.sysds.runtime.instructions.fed.ReblockFEDInstruction;
import org.apache.sysds.runtime.instructions.fed.ReorgFEDInstruction;
import org.apache.sysds.runtime.instructions.fed.ReshapeFEDInstruction;
import org.apache.sysds.runtime.instructions.fed.UnaryMatrixFEDInstruction;
import org.apache.sysds.runtime.instructions.spark.AggregateUnarySPInstruction;
import org.apache.sysds.runtime.instructions.spark.CentralMomentSPInstruction;
import org.apache.sysds.runtime.instructions.spark.IndexingSPInstruction;
import org.apache.sysds.runtime.instructions.spark.QuantileSortSPInstruction;
import org.apache.sysds.runtime.instructions.spark.ReblockSPInstruction;
import org.apache.sysds.runtime.instructions.spark.ReorgSPInstruction;
import org.apache.sysds.runtime.instructions.spark.UnaryMatrixSPInstruction;
import org.apache.sysds.runtime.instructions.spark.UnarySPInstruction;
import org.apache.sysds.runtime.matrix.operators.Operator;

public abstract class UnaryFEDInstruction
extends ComputationFEDInstruction {
    protected UnaryFEDInstruction(FEDInstruction.FEDType type, Operator op, CPOperand in, CPOperand out, String opcode, String instr) {
        this(type, op, in, null, null, out, opcode, instr);
    }

    protected UnaryFEDInstruction(FEDInstruction.FEDType type, Operator op, CPOperand in, CPOperand out, String opcode, String instr, FEDInstruction.FederatedOutput fedOut) {
        this(type, op, in, null, null, out, opcode, instr, fedOut);
    }

    protected UnaryFEDInstruction(FEDInstruction.FEDType type, Operator op, CPOperand in1, CPOperand in2, CPOperand out, String opcode, String instr) {
        this(type, op, in1, in2, null, out, opcode, instr);
    }

    protected UnaryFEDInstruction(FEDInstruction.FEDType type, Operator op, CPOperand in1, CPOperand in2, CPOperand out, String opcode, String instr, FEDInstruction.FederatedOutput fedOut) {
        this(type, op, in1, in2, null, out, opcode, instr, fedOut);
    }

    protected UnaryFEDInstruction(FEDInstruction.FEDType type, Operator op, CPOperand in1, CPOperand in2, CPOperand in3, CPOperand out, String opcode, String instr) {
        this(type, op, in1, in2, in3, out, opcode, instr, FEDInstruction.FederatedOutput.NONE);
    }

    protected UnaryFEDInstruction(FEDInstruction.FEDType type, Operator op, CPOperand in1, CPOperand in2, CPOperand in3, CPOperand out, String opcode, String instr, FEDInstruction.FederatedOutput fedOut) {
        super(type, op, in1, in2, in3, out, opcode, instr, fedOut);
    }

    public static UnaryFEDInstruction parseInstruction(UnaryCPInstruction inst, ExecutionContext ec) {
        MatrixObject mo1;
        if (inst instanceof IndexingCPInstruction) {
            IndexingCPInstruction minst = (IndexingCPInstruction)inst;
            if ((minst.input1.isMatrix() || minst.input1.isFrame()) && ec.getCacheableData(minst.input1).isFederatedExcept(FTypes.FType.BROADCAST)) {
                return IndexingFEDInstruction.parseInstruction(minst);
            }
        } else if (inst instanceof ReorgCPInstruction && (inst.getOpcode().equals("r'") || inst.getOpcode().equals("rdiag") || inst.getOpcode().equals("rev"))) {
            ReorgCPInstruction rinst = (ReorgCPInstruction)inst;
            CacheableData<?> mo = ec.getCacheableData(rinst.input1);
            if ((mo instanceof MatrixObject || mo instanceof FrameObject) && mo.isFederatedExcept(FTypes.FType.BROADCAST)) {
                return ReorgFEDInstruction.parseInstruction(rinst);
            }
        } else if (inst.input1 != null && inst.input1.isMatrix() && ec.containsVariable(inst.input1) && (mo1 = ec.getMatrixObject(inst.input1)).isFederatedExcept(FTypes.FType.BROADCAST)) {
            if (inst instanceof CentralMomentCPInstruction) {
                return CentralMomentFEDInstruction.parseInstruction((CentralMomentCPInstruction)inst);
            }
            if (inst instanceof QuantileSortCPInstruction) {
                if (mo1.isFederated(FTypes.FType.ROW) || mo1.getFedMapping().getFederatedRanges().length == 1 && mo1.isFederated(FTypes.FType.COL)) {
                    return QuantileSortFEDInstruction.parseInstruction((QuantileSortCPInstruction)inst);
                }
            } else {
                if (inst instanceof ReshapeCPInstruction) {
                    return ReshapeFEDInstruction.parseInstruction((ReshapeCPInstruction)inst);
                }
                if (inst instanceof AggregateUnaryCPInstruction && ((AggregateUnaryCPInstruction)inst).getAUType() == AggregateUnaryCPInstruction.AUType.DEFAULT) {
                    return AggregateUnaryFEDInstruction.parseInstruction((AggregateUnaryCPInstruction)inst);
                }
                if (inst instanceof UnaryMatrixCPInstruction && UnaryMatrixFEDInstruction.isValidOpcode(inst.getOpcode()) && (!inst.getOpcode().equalsIgnoreCase("ucumk+*") || !mo1.isFederated(FTypes.FType.COL))) {
                    return UnaryMatrixFEDInstruction.parseInstruction((UnaryMatrixCPInstruction)inst);
                }
            }
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static UnaryFEDInstruction parseInstruction(UnarySPInstruction inst, ExecutionContext ec) {
        MatrixObject mo1;
        if (inst instanceof IndexingSPInstruction) {
            IndexingSPInstruction minst = (IndexingSPInstruction)inst;
            if (!minst.input1.isMatrix() && !minst.input1.isFrame() || !ec.getCacheableData(minst.input1).isFederatedExcept(FTypes.FType.BROADCAST)) return null;
            return IndexingFEDInstruction.parseInstruction(minst);
        }
        if (inst instanceof CentralMomentSPInstruction) {
            CentralMomentSPInstruction cinstruction = (CentralMomentSPInstruction)inst;
            Data data = ec.getVariable(cinstruction.input1);
            if (!(data instanceof MatrixObject) || !((MatrixObject)data).isFederated() || !((MatrixObject)data).isFederatedExcept(FTypes.FType.BROADCAST)) return null;
            return CentralMomentFEDInstruction.parseInstruction(cinstruction);
        }
        if (inst instanceof QuantileSortSPInstruction) {
            QuantileSortSPInstruction qinstruction = (QuantileSortSPInstruction)inst;
            Data data = ec.getVariable(qinstruction.input1);
            if (!(data instanceof MatrixObject) || !((MatrixObject)data).isFederated() || !((MatrixObject)data).isFederatedExcept(FTypes.FType.BROADCAST)) return null;
            return QuantileSortFEDInstruction.parseInstruction(qinstruction);
        }
        if (inst instanceof AggregateUnarySPInstruction) {
            AggregateUnarySPInstruction auinstruction = (AggregateUnarySPInstruction)inst;
            Data data = ec.getVariable(auinstruction.input1);
            if (!(data instanceof MatrixObject) || !((MatrixObject)data).isFederated() || !((MatrixObject)data).isFederatedExcept(FTypes.FType.BROADCAST)) return null;
            if (!ArrayUtils.contains((Object[])new String[]{"uarimin", "uarimax"}, (Object)auinstruction.getOpcode())) return AggregateUnaryFEDInstruction.parseInstruction(auinstruction);
            if (((MatrixObject)data).getFedMapping().getType() != FTypes.FType.ROW) return null;
            return AggregateUnaryFEDInstruction.parseInstruction(auinstruction);
        }
        if (inst instanceof ReorgSPInstruction && (inst.getOpcode().equals("r'") || inst.getOpcode().equals("rdiag") || inst.getOpcode().equals("rev"))) {
            ReorgSPInstruction rinst = (ReorgSPInstruction)inst;
            CacheableData<?> mo = ec.getCacheableData(rinst.input1);
            if (!(mo instanceof MatrixObject) && !(mo instanceof FrameObject) || !mo.isFederated() || !mo.isFederatedExcept(FTypes.FType.BROADCAST)) return null;
            return ReorgFEDInstruction.parseInstruction(rinst);
        }
        if (inst instanceof ReblockSPInstruction && inst.input1 != null && (inst.input1.isFrame() || inst.input1.isMatrix())) {
            ReblockSPInstruction rinst = (ReblockSPInstruction)inst;
            CacheableData<?> data = ec.getCacheableData(rinst.input1);
            if (!data.isFederatedExcept(FTypes.FType.BROADCAST)) return null;
            return ReblockFEDInstruction.parseInstruction((ReblockSPInstruction)inst);
        }
        if (inst.input1 == null || !inst.input1.isMatrix() || !ec.containsVariable(inst.input1) || !(mo1 = ec.getMatrixObject(inst.input1)).isFederatedExcept(FTypes.FType.BROADCAST)) return null;
        if (inst.getOpcode().equalsIgnoreCase("cm")) {
            return CentralMomentFEDInstruction.parseInstruction((CentralMomentSPInstruction)inst);
        }
        if (inst.getOpcode().equalsIgnoreCase("qsort")) {
            if (mo1.getFedMapping().getFederatedRanges().length != 1) return null;
            return QuantileSortFEDInstruction.parseInstruction(inst.getInstructionString(), false);
        }
        if (inst.getOpcode().equalsIgnoreCase("rshape")) {
            return ReshapeFEDInstruction.parseInstruction(inst.getInstructionString());
        }
        if (!(inst instanceof UnaryMatrixSPInstruction) || !UnaryMatrixFEDInstruction.isValidOpcode(inst.getOpcode())) return null;
        return UnaryMatrixFEDInstruction.parseInstruction((UnaryMatrixSPInstruction)inst);
    }

    protected static String parseUnaryInstruction(String instr, CPOperand in, CPOperand out) {
        int num = InstructionUtils.checkNumFields(instr, 2, 3, 4);
        if (num == 2) {
            return UnaryFEDInstruction.parse(instr, in, null, null, out);
        }
        String[] parts = InstructionUtils.getInstructionPartsWithValueType(instr);
        String opcode = parts[0];
        in.split(parts[1]);
        out.split(parts[2]);
        return opcode;
    }

    protected static String parseUnaryInstruction(String instr, CPOperand in1, CPOperand in2, CPOperand out) {
        InstructionUtils.checkNumFields(instr, 3);
        return UnaryFEDInstruction.parse(instr, in1, in2, null, out);
    }

    protected static String parseUnaryInstruction(String instr, CPOperand in1, CPOperand in2, CPOperand in3, CPOperand out) {
        InstructionUtils.checkNumFields(instr, 4);
        return UnaryFEDInstruction.parse(instr, in1, in2, in3, out);
    }

    private static String parse(String instr, CPOperand in1, CPOperand in2, CPOperand in3, CPOperand out) {
        String[] parts = InstructionUtils.getInstructionPartsWithValueType(instr);
        String opcode = parts[0];
        out.split(parts[parts.length - 1]);
        switch (parts.length) {
            case 3: {
                in1.split(parts[1]);
                in2 = null;
                in3 = null;
                break;
            }
            case 4: {
                in1.split(parts[1]);
                in2.split(parts[2]);
                in3 = null;
                break;
            }
            case 5: {
                in1.split(parts[1]);
                in2.split(parts[2]);
                in3.split(parts[3]);
                break;
            }
            default: {
                throw new DMLRuntimeException("Unexpected number of operands in the instruction: " + instr);
            }
        }
        return opcode;
    }

    static FEDInstruction.FederatedOutput parseFedOutFlag(String instr, int position) {
        String[] parts = InstructionUtils.getInstructionPartsWithValueType(instr);
        if (parts.length > position) {
            return FEDInstruction.FederatedOutput.valueOf(parts[position]);
        }
        return FEDInstruction.FederatedOutput.NONE;
    }
}

