/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.colgroup;

import java.io.DataInput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.sysds.runtime.compress.bitmap.ABitmap;
import org.apache.sysds.runtime.compress.colgroup.AColGroup;
import org.apache.sysds.runtime.compress.colgroup.AColGroupCompressed;
import org.apache.sysds.runtime.compress.colgroup.AColGroupOffset;
import org.apache.sysds.runtime.compress.colgroup.ColGroupDDC;
import org.apache.sysds.runtime.compress.colgroup.ColGroupEmpty;
import org.apache.sysds.runtime.compress.colgroup.ColGroupSDCSingleZeros;
import org.apache.sysds.runtime.compress.colgroup.ColGroupSDCZeros;
import org.apache.sysds.runtime.compress.colgroup.dictionary.Dictionary;
import org.apache.sysds.runtime.compress.colgroup.dictionary.DictionaryFactory;
import org.apache.sysds.runtime.compress.colgroup.dictionary.IDictionary;
import org.apache.sysds.runtime.compress.colgroup.indexes.ColIndexFactory;
import org.apache.sysds.runtime.compress.colgroup.indexes.IColIndex;
import org.apache.sysds.runtime.compress.colgroup.offset.AIterator;
import org.apache.sysds.runtime.compress.colgroup.offset.AOffsetIterator;
import org.apache.sysds.runtime.compress.colgroup.scheme.ICLAScheme;
import org.apache.sysds.runtime.compress.colgroup.scheme.RLEScheme;
import org.apache.sysds.runtime.compress.cost.ComputationCostEstimator;
import org.apache.sysds.runtime.compress.estim.CompressedSizeInfoColGroup;
import org.apache.sysds.runtime.data.DenseBlock;
import org.apache.sysds.runtime.data.SparseBlock;
import org.apache.sysds.runtime.functionobjects.Builtin;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;
import org.apache.sysds.runtime.matrix.operators.BinaryOperator;
import org.apache.sysds.runtime.matrix.operators.ScalarOperator;
import org.apache.sysds.runtime.matrix.operators.UnaryOperator;

public class ColGroupRLE
extends AColGroupOffset {
    private static final long serialVersionUID = -1560710477952862791L;

    private ColGroupRLE(IColIndex colIndexes, int numRows, boolean zeros, IDictionary dict, char[] bitmaps, int[] bitmapOffs, int[] cachedCounts) {
        super(colIndexes, numRows, zeros, dict, bitmapOffs, bitmaps, cachedCounts);
    }

    protected static AColGroup create(IColIndex colIndexes, int numRows, boolean zeros, IDictionary dict, char[] bitmaps, int[] bitmapOffs, int[] cachedCounts) {
        if (dict == null) {
            return new ColGroupEmpty(colIndexes);
        }
        return new ColGroupRLE(colIndexes, numRows, zeros, dict, bitmaps, bitmapOffs, cachedCounts);
    }

    protected static AColGroup compressRLE(IColIndex colIndexes, ABitmap ubm, int nRow, double tupleSparsity) {
        IDictionary dict = DictionaryFactory.create(ubm, tupleSparsity);
        int numVals = ubm.getNumValues();
        char[][] lBitMaps = new char[numVals][];
        int totalLen = 0;
        int sumLength = 0;
        for (int k = 0; k < numVals; ++k) {
            int l = ubm.getNumOffsets(k);
            sumLength += l;
            lBitMaps[k] = ColGroupRLE.genRLEBitmap(ubm.getOffsetsList(k).extractValues(), l);
            totalLen += lBitMaps[k].length;
        }
        int[] bitmap = new int[numVals + 1];
        char[] data = new char[totalLen];
        ColGroupRLE.createCompressedBitmaps(bitmap, data, lBitMaps);
        boolean zeros = sumLength < nRow;
        return ColGroupRLE.create(colIndexes, nRow, zeros, dict, data, bitmap, null);
    }

    @Override
    public AColGroup.CompressionType getCompType() {
        return AColGroup.CompressionType.RLE;
    }

    @Override
    public AColGroup.ColGroupType getColGroupType() {
        return AColGroup.ColGroupType.RLE;
    }

    @Override
    protected void decompressToDenseBlockDenseDictionary(DenseBlock db, int rl, int ru, int offR, int offC, double[] values) {
        int numVals = this.getNumValues();
        int nCol = this._colIndexes.size();
        block0: for (int k = 0; k < numVals; ++k) {
            int blen = this._ptr[k + 1];
            skipPair tmp = this.skipScanVal(k, rl);
            int rowIndex = k * nCol;
            int rs = tmp.astart;
            int re = tmp.astart;
            for (int apos = tmp.apos; apos < blen; apos += 2) {
                int j;
                int off;
                double[] c;
                int offT;
                int rix;
                rs = re + this._data[apos];
                re = rs + this._data[apos + 1];
                int rsc = Math.max(rs, rl);
                if (re >= ru) {
                    rix = rsc;
                    offT = rsc + offR;
                    while (rix < ru) {
                        c = db.values(offT);
                        off = db.pos(offT) + offC;
                        for (j = 0; j < nCol; ++j) {
                            int n = off + this._colIndexes.get(j);
                            c[n] = c[n] + values[rowIndex + j];
                        }
                        ++rix;
                        ++offT;
                    }
                    continue block0;
                }
                rix = rsc;
                offT = rsc + offR;
                while (rix < re) {
                    c = db.values(offT);
                    off = db.pos(offT) + offC;
                    for (j = 0; j < nCol; ++j) {
                        int n = off + this._colIndexes.get(j);
                        c[n] = c[n] + values[rowIndex + j];
                    }
                    ++rix;
                    ++offT;
                }
            }
        }
    }

    @Override
    protected void decompressToDenseBlockSparseDictionary(DenseBlock db, int rl, int ru, int offR, int offC, SparseBlock sb) {
        int numVals = this.getNumValues();
        block0: for (int k = 0; k < numVals; ++k) {
            int blen = this._ptr[k + 1];
            skipPair tmp = this.skipScanVal(k, rl);
            int sbApos = sb.pos(k);
            int sbAlen = sb.size(k) + sbApos;
            int[] sbAix = sb.indexes(k);
            double[] sbAval = sb.values(k);
            int rs = tmp.astart;
            int re = tmp.astart;
            for (int apos = tmp.apos; apos < blen; apos += 2) {
                int j;
                int off;
                double[] c;
                int offT;
                int rix;
                rs = re + this._data[apos];
                re = rs + this._data[apos + 1];
                int rsc = Math.max(rs, rl);
                if (re >= ru) {
                    rix = rsc;
                    offT = rsc + offR;
                    while (rix < ru) {
                        c = db.values(offT);
                        off = db.pos(offT) + offC;
                        for (j = sbApos; j < sbAlen; ++j) {
                            int n = off + this._colIndexes.get(sbAix[j]);
                            c[n] = c[n] + sbAval[j];
                        }
                        ++rix;
                        ++offT;
                    }
                    continue block0;
                }
                rix = rsc;
                offT = rsc + offR;
                while (rix < re) {
                    c = db.values(offT);
                    off = db.pos(offT) + offC;
                    for (j = sbApos; j < sbAlen; ++j) {
                        int n = off + this._colIndexes.get(sbAix[j]);
                        c[n] = c[n] + sbAval[j];
                    }
                    ++rix;
                    ++offT;
                }
            }
        }
    }

    @Override
    protected void decompressToSparseBlockSparseDictionary(SparseBlock ret, int rl, int ru, int offR, int offC, SparseBlock sb) {
        int numVals = this.getNumValues();
        block0: for (int k = 0; k < numVals; ++k) {
            int blen = this._ptr[k + 1];
            skipPair tmp = this.skipScanVal(k, rl);
            int sbApos = sb.pos(k);
            int sbAlen = sb.size(k) + sbApos;
            int[] sbAix = sb.indexes(k);
            double[] sbAval = sb.values(k);
            int rs = tmp.astart;
            int re = tmp.astart;
            for (int apos = tmp.apos; apos < blen; apos += 2) {
                int j;
                int offT;
                int rix;
                rs = re + this._data[apos];
                re = rs + this._data[apos + 1];
                int rsc = Math.max(rs, rl);
                if (re >= ru) {
                    rix = rsc;
                    offT = rsc + offR;
                    while (rix < ru) {
                        for (j = sbApos; j < sbAlen; ++j) {
                            ret.append(offT, this._colIndexes.get(sbAix[j]) + offC, sbAval[j]);
                        }
                        ++rix;
                        ++offT;
                    }
                    continue block0;
                }
                rix = rsc;
                offT = rsc + offR;
                while (rix < re) {
                    for (j = sbApos; j < sbAlen; ++j) {
                        ret.append(offT, this._colIndexes.get(sbAix[j]) + offC, sbAval[j]);
                    }
                    ++rix;
                    ++offT;
                }
            }
        }
    }

    @Override
    protected void decompressToSparseBlockDenseDictionary(SparseBlock ret, int rl, int ru, int offR, int offC, double[] values) {
        int numVals = this.getNumValues();
        int nCol = this._colIndexes.size();
        block0: for (int k = 0; k < numVals; ++k) {
            int blen = this._ptr[k + 1];
            skipPair tmp = this.skipScanVal(k, rl);
            int rowIndex = k * nCol;
            int rs = tmp.astart;
            int re = tmp.astart;
            for (int apos = tmp.apos; apos < blen; apos += 2) {
                int j;
                int offT;
                int rix;
                rs = re + this._data[apos];
                re = rs + this._data[apos + 1];
                int rsc = Math.max(rs, rl);
                if (re >= ru) {
                    rix = rsc;
                    offT = rsc + offR;
                    while (rix < ru) {
                        for (j = 0; j < nCol; ++j) {
                            ret.append(offT, this._colIndexes.get(j) + offC, values[rowIndex + j]);
                        }
                        ++rix;
                        ++offT;
                    }
                    continue block0;
                }
                rix = rsc;
                offT = rsc + offR;
                while (rix < re) {
                    for (j = 0; j < nCol; ++j) {
                        ret.append(offT, this._colIndexes.get(j) + offC, values[rowIndex + j]);
                    }
                    ++rix;
                    ++offT;
                }
            }
        }
    }

    @Override
    public int[] getCounts(int[] counts) {
        for (int k = 0; k < this.getNumValues(); ++k) {
            for (int bix = this._ptr[k]; bix < this._ptr[k + 1]; bix += 2) {
                int n = k;
                counts[n] = counts[n] + this._data[bix + 1];
            }
        }
        return counts;
    }

    @Override
    public AColGroup scalarOperation(ScalarOperator op) {
        double val0 = op.executeScalar(0.0);
        if (op.sparseSafe || val0 == 0.0 || !this._zeros) {
            return ColGroupRLE.create(this._colIndexes, this._numRows, this._zeros, this._dict.applyScalarOp(op), this._data, this._ptr, this.getCachedCounts());
        }
        return this.appendRun(this._dict.applyScalarOpAndAppend(op, val0, this.getNumCols()));
    }

    @Override
    public AColGroup unaryOperation(UnaryOperator op) {
        double val0 = op.fn.execute(0L);
        if (op.sparseSafe || val0 == 0.0 || !this._zeros) {
            return ColGroupRLE.create(this._colIndexes, this._numRows, this._zeros, this._dict.applyUnaryOp(op), this._data, this._ptr, this.getCachedCounts());
        }
        return this.appendRun(this._dict.applyUnaryOpAndAppend(op, val0, this.getNumCols()));
    }

    @Override
    public AColGroup binaryRowOpLeft(BinaryOperator op, double[] v, boolean isRowSafe) {
        boolean sparseSafe;
        boolean bl = sparseSafe = isRowSafe || !this._zeros;
        if (sparseSafe) {
            return ColGroupRLE.create(this._colIndexes, this._numRows, this._zeros, this._dict.binOpLeft(op, v, this._colIndexes), this._data, this._ptr, this.getCachedCounts());
        }
        return this.appendRun(this._dict.binOpLeftAndAppend(op, v, this._colIndexes));
    }

    @Override
    public AColGroup binaryRowOpRight(BinaryOperator op, double[] v, boolean isRowSafe) {
        boolean sparseSafe;
        boolean bl = sparseSafe = isRowSafe || !this._zeros;
        if (sparseSafe) {
            return ColGroupRLE.create(this._colIndexes, this._numRows, this._zeros, this._dict.binOpRight(op, v, this._colIndexes), this._data, this._ptr, this.getCachedCounts());
        }
        return this.appendRun(this._dict.binOpRightAndAppend(op, v, this._colIndexes));
    }

    private AColGroup appendRun(IDictionary dict) {
        boolean[] lind = this.computeZeroIndicatorVector();
        int[] loff = this.computeOffsets(lind);
        char[] lbitmap = ColGroupRLE.genRLEBitmap(loff, loff.length);
        char[] rbitmaps = Arrays.copyOf(this._data, this._data.length + lbitmap.length);
        System.arraycopy(lbitmap, 0, rbitmaps, this._data.length, lbitmap.length);
        int[] rbitmapOffs = Arrays.copyOf(this._ptr, this._ptr.length + 1);
        rbitmapOffs[rbitmapOffs.length - 1] = rbitmaps.length;
        return ColGroupRLE.create(this._colIndexes, this._numRows, false, dict, rbitmaps, rbitmapOffs, this.getCachedCounts());
    }

    @Override
    protected final void computeRowSums(double[] c, int rl, int ru, double[] preAgg) {
        int numVals = this.getNumValues();
        block0: for (int k = 0; k < numVals; ++k) {
            double val = preAgg[k];
            if (val == 0.0) continue;
            int blen = this._ptr[k + 1];
            skipPair tmp = this.skipScanVal(k, rl);
            int rs = 0;
            int re = tmp.astart;
            for (int apos = tmp.apos; apos < blen; apos += 2) {
                int rix;
                rs = re + this._data[apos];
                re = rs + this._data[apos + 1];
                int rsc = Math.max(rs, rl);
                if (re >= ru) {
                    rix = rsc;
                    while (rix < ru) {
                        int n = rix++;
                        c[n] = c[n] + val;
                    }
                    continue block0;
                }
                rix = rsc;
                while (rix < re) {
                    int n = rix++;
                    c[n] = c[n] + val;
                }
            }
        }
    }

    @Override
    protected void computeProduct(double[] c, int nRows) {
        if (this._zeros) {
            c[0] = 0.0;
        } else {
            this._dict.product(c, this.getCounts(), this._colIndexes.size());
        }
    }

    @Override
    protected void computeColProduct(double[] c, int nRows) {
        if (this._zeros) {
            for (int i = 0; i < this._colIndexes.size(); ++i) {
                c[this._colIndexes.get((int)i)] = 0.0;
            }
        } else {
            this._dict.colProduct(c, this.getCounts(), this._colIndexes);
        }
    }

    @Override
    protected final void computeRowProduct(double[] c, int rl, int ru, double[] preAgg) {
        if (this._zeros) {
            this.computeRowProductSparseRLE(c, rl, ru, preAgg);
        } else {
            this.computeRowProductDenseRLE(c, rl, ru, preAgg);
        }
    }

    private final void computeRowProductSparseRLE(double[] c, int rl, int ru, double[] preAgg) {
        int numVals = this.getNumValues();
        boolean[] zeroRows = new boolean[ru - rl];
        block0: for (int k = 0; k < numVals; ++k) {
            double val = preAgg[k];
            int blen = this._ptr[k + 1];
            skipPair tmp = this.skipScanVal(k, rl);
            int rs = tmp.astart;
            int re = tmp.astart;
            for (int apos = tmp.apos; apos < blen; apos += 2) {
                int rix;
                rs = re + this._data[apos];
                re = rs + this._data[apos + 1];
                int rsc = Math.max(rs, rl);
                if (re >= ru) {
                    for (rix = rsc; rix < ru; ++rix) {
                        int n = rix;
                        c[n] = c[n] * val;
                        zeroRows[rix - rl] = true;
                    }
                    continue block0;
                }
                for (rix = rsc; rix < re; ++rix) {
                    int n = rix;
                    c[n] = c[n] * val;
                    zeroRows[rix - rl] = true;
                }
            }
        }
        for (int i = 0; i < zeroRows.length; ++i) {
            if (zeroRows[i]) continue;
            c[i + rl] = 0.0;
        }
    }

    private final void computeRowProductDenseRLE(double[] c, int rl, int ru, double[] preAgg) {
        int numVals = this.getNumValues();
        block0: for (int k = 0; k < numVals; ++k) {
            double val = preAgg[k];
            int blen = this._ptr[k + 1];
            skipPair tmp = this.skipScanVal(k, rl);
            int rs = tmp.astart;
            int re = tmp.astart;
            for (int apos = tmp.apos; apos < blen; apos += 2) {
                int rix;
                rs = re + this._data[apos];
                re = rs + this._data[apos + 1];
                int rsc = Math.max(rs, rl);
                if (re >= ru) {
                    rix = rsc;
                    while (rix < ru) {
                        int n = rix++;
                        c[n] = c[n] * val;
                    }
                    continue block0;
                }
                rix = rsc;
                while (rix < re) {
                    int n = rix++;
                    c[n] = c[n] * val;
                }
            }
        }
    }

    @Override
    protected final void computeRowMxx(double[] c, Builtin builtin, int rl, int ru, double[] preAgg) {
        if (this._zeros) {
            this.computeRowMxxSparseRLE(c, builtin, rl, ru, preAgg);
        } else {
            this.computeRowMxxDenseRLE(c, builtin, rl, ru, preAgg);
        }
    }

    private final void computeRowMxxSparseRLE(double[] c, Builtin builtin, int rl, int ru, double[] preAgg) {
        int numVals = this.getNumValues();
        boolean[] zeroRows = new boolean[ru - rl];
        block0: for (int k = 0; k < numVals; ++k) {
            double val = preAgg[k];
            int blen = this._ptr[k + 1];
            skipPair tmp = this.skipScanVal(k, rl);
            int rs = tmp.astart;
            int re = tmp.astart;
            for (int apos = tmp.apos; apos < blen; apos += 2) {
                int rix;
                rs = re + this._data[apos];
                re = rs + this._data[apos + 1];
                int rsc = Math.max(rs, rl);
                if (re >= ru) {
                    for (rix = rsc; rix < ru; ++rix) {
                        c[rix] = builtin.execute(c[rix], val);
                        zeroRows[rix - rl] = true;
                    }
                    continue block0;
                }
                for (rix = rsc; rix < re; ++rix) {
                    c[rix] = builtin.execute(c[rix], val);
                    zeroRows[rix - rl] = true;
                }
            }
        }
        for (int i = 0; i < zeroRows.length; ++i) {
            if (zeroRows[i]) continue;
            int id = i + rl;
            c[id] = builtin.execute(c[id], 0.0);
        }
    }

    private final void computeRowMxxDenseRLE(double[] c, Builtin builtin, int rl, int ru, double[] preAgg) {
        int numVals = this.getNumValues();
        block0: for (int k = 0; k < numVals; ++k) {
            double val = preAgg[k];
            int blen = this._ptr[k + 1];
            skipPair tmp = this.skipScanVal(k, rl);
            int rs = tmp.astart;
            int re = tmp.astart;
            for (int apos = tmp.apos; apos < blen; apos += 2) {
                int rix;
                rs = re + this._data[apos];
                re = rs + this._data[apos + 1];
                int rsc = Math.max(rs, rl);
                if (re >= ru) {
                    for (rix = rsc; rix < ru; ++rix) {
                        c[rix] = builtin.execute(c[rix], val);
                    }
                    continue block0;
                }
                for (rix = rsc; rix < re; ++rix) {
                    c[rix] = builtin.execute(c[rix], val);
                }
            }
        }
    }

    public boolean[] computeZeroIndicatorVector() {
        boolean[] ret = new boolean[this._numRows];
        int numVals = this.getNumValues();
        Arrays.fill(ret, true);
        for (int k = 0; k < numVals; ++k) {
            int boff = this._ptr[k];
            int blen = this.len(k);
            int curRunStartOff = 0;
            int curRunEnd = 0;
            for (int bix = 0; bix < blen; bix += 2) {
                curRunStartOff = curRunEnd + this._data[boff + bix];
                curRunEnd = curRunStartOff + this._data[boff + bix + 1];
                Arrays.fill(ret, curRunStartOff, curRunEnd, false);
            }
        }
        return ret;
    }

    @Override
    public double getIdx(int r, int colIdx) {
        int numVals = this.getNumValues();
        for (int k = 0; k < numVals; ++k) {
            char llen;
            char lstart;
            int boff = this._ptr[k];
            int blen = this.len(k);
            int bix = 0;
            for (int start = 0; bix < blen && start <= r; start += lstart + llen, bix += 2) {
                lstart = this._data[boff + bix];
                llen = this._data[boff + bix + 1];
                int from = start + lstart;
                int to = start + lstart + llen;
                if (r < from || r >= to) continue;
                return this._dict.getValue(k * this._colIndexes.size() + colIdx);
            }
        }
        return 0.0;
    }

    private skipPair skipScanVal(int k, int rl) {
        int nStart;
        int blen = this._ptr[k + 1];
        int apos = this._ptr[k];
        int start = 0;
        while ((nStart = start + this._data[apos] + this._data[apos + 1]) < rl) {
            start = nStart;
            if ((apos += 2) < blen) continue;
        }
        return new skipPair(apos, start);
    }

    @Override
    public void leftMultByMatrixNoPreAgg(MatrixBlock matrix, MatrixBlock result, int rl, int ru, int cl, int cu) {
        if (matrix.isInSparseFormat()) {
            if (cl != 0 || cu != this._numRows) {
                throw new NotImplementedException("Not implemented left multiplication on sparse without it being entire input");
            }
            this.lmSparseMatrixNoPreAggMultiCol(matrix, result, rl, ru);
        } else {
            this.lmDenseMatrixNoPreAggMultiCol(matrix, result, rl, ru, cl, cu);
        }
    }

    private void lmSparseMatrixNoPreAggMultiCol(MatrixBlock matrix, MatrixBlock result, int rl, int ru) {
        double[] retV = result.getDenseBlockValues();
        int nColRet = result.getNumColumns();
        SparseBlock sb = matrix.getSparseBlock();
        int nv = this.getNumValues();
        for (int r = rl; r < ru; ++r) {
            if (sb.isEmpty(r)) continue;
            int sbApos = sb.pos(r);
            int sbAlen = sb.size(r) + sbApos;
            int[] sbAix = sb.indexes(r);
            double[] sbAval = sb.values(r);
            int offR = r * nColRet;
            for (int k = 0; k < nv; ++k) {
                int i = sbApos;
                int blen = this._ptr[k + 1];
                int rs = 0;
                int re = 0;
                for (int apos = this._ptr[k]; apos < blen && i < sbAlen; apos += 2) {
                    rs = re + this._data[apos];
                    re = rs + this._data[apos + 1];
                    while (i < sbAlen && sbAix[i] < rs) {
                        ++i;
                    }
                    while (i < sbAlen && sbAix[i] < re) {
                        this._dict.multiplyScalar(sbAval[i], retV, offR, k, this._colIndexes);
                        ++i;
                    }
                }
            }
        }
    }

    private void lmDenseMatrixNoPreAggMultiCol(MatrixBlock matrix, MatrixBlock result, int rl, int ru, int cl, int cu) {
        double[] retV = result.getDenseBlockValues();
        int nColM = matrix.getNumColumns();
        int nColRet = result.getNumColumns();
        double[] mV = matrix.getDenseBlockValues();
        int nv = this.getNumValues();
        for (int r = rl; r < ru; ++r) {
            int offL = r * nColM;
            int offR = r * nColRet;
            block1: for (int k = 0; k < nv; ++k) {
                int blen = this._ptr[k + 1];
                skipPair tmp = this.skipScanVal(k, cl);
                int rs = 0;
                int re = tmp.astart;
                for (int apos = tmp.apos; apos < blen; apos += 2) {
                    int rix;
                    rs = re + this._data[apos];
                    re = rs + this._data[apos + 1];
                    int rsc = Math.max(rs, cl);
                    if (re >= cu) {
                        for (rix = rsc; rix < cu; ++rix) {
                            this._dict.multiplyScalar(mV[offL + rix], retV, offR, k, this._colIndexes);
                        }
                        continue block1;
                    }
                    for (rix = rsc; rix < re; ++rix) {
                        this._dict.multiplyScalar(mV[offL + rix], retV, offR, k, this._colIndexes);
                    }
                }
            }
        }
    }

    @Override
    protected AColGroup allocateRightMultiplication(MatrixBlock right, IColIndex colIndexes, IDictionary preAgg) {
        if (preAgg == null) {
            return null;
        }
        return ColGroupRLE.create(colIndexes, this._numRows, this._zeros, preAgg, this._data, this._ptr, this.getCachedCounts());
    }

    @Override
    protected double computeMxx(double c, Builtin builtin) {
        if (this._zeros) {
            c = builtin.execute(c, 0.0);
        }
        return this._dict.aggregate(c, builtin);
    }

    @Override
    protected void computeColMxx(double[] c, Builtin builtin) {
        if (this._zeros) {
            for (int x = 0; x < this._colIndexes.size(); ++x) {
                c[this._colIndexes.get((int)x)] = builtin.execute(c[this._colIndexes.get(x)], 0.0);
            }
        }
        this._dict.aggregateCols(c, builtin, this._colIndexes);
    }

    @Override
    public boolean containsValue(double pattern) {
        if (pattern == 0.0 && this._zeros) {
            return true;
        }
        return this._dict.containsValue(pattern);
    }

    private String pair(char[] d, int off) {
        if (this._data[off + 1] == '\u0001') {
            return "" + this._data[off];
        }
        return this._data[off] + "-" + this._data[off + 1];
    }

    private String pair(char[] d, int off, int sum) {
        if (this._data[off + 1] == '\u0001') {
            return "" + (this._data[off] + sum);
        }
        return this._data[off] + sum + "-" + this._data[off + 1];
    }

    @Override
    public void preAggregateDense(MatrixBlock m, double[] preAgg, int rl, int ru, int cl, int cu) {
        DenseBlock db = m.getDenseBlock();
        if (!db.isContiguous()) {
            throw new NotImplementedException("Not implemented support for preAggregate non contiguous dense matrix");
        }
        double[] mV = m.getDenseBlockValues();
        int nCol = m.getNumColumns();
        int nv = this.getNumValues();
        block0: for (int k = 0; k < nv; ++k) {
            int blen = this._ptr[k + 1];
            skipPair tmp = this.skipScanVal(k, cl);
            int rs = 0;
            int re = tmp.astart;
            for (int apos = tmp.apos; apos < blen; apos += 2) {
                int rix;
                int offI;
                int off;
                int r;
                rs = re + this._data[apos];
                re = rs + this._data[apos + 1];
                int rsc = Math.max(rs, cl);
                if (re >= cu) {
                    for (r = rl; r < ru; ++r) {
                        off = (r - rl) * nv + k;
                        offI = nCol * r;
                        for (rix = rsc + offI; rix < cu + offI; ++rix) {
                            int n = off;
                            preAgg[n] = preAgg[n] + mV[rix];
                        }
                    }
                    continue block0;
                }
                for (r = rl; r < ru; ++r) {
                    off = (r - rl) * nv + k;
                    offI = nCol * r;
                    for (rix = rsc + offI; rix < re + offI; ++rix) {
                        int n = off;
                        preAgg[n] = preAgg[n] + mV[rix];
                    }
                }
            }
        }
    }

    @Override
    public void preAggregateSparse(SparseBlock sb, double[] preAgg, int rl, int ru) {
        int nv = this.getNumValues();
        for (int r = rl; r < ru; ++r) {
            if (sb.isEmpty(r)) continue;
            int sbApos = sb.pos(r);
            int sbAlen = sb.size(r) + sbApos;
            int[] sbAix = sb.indexes(r);
            double[] sbAval = sb.values(r);
            for (int k = 0; k < nv; ++k) {
                int blen = this._ptr[k + 1];
                int offR = (r - rl) * nv + k;
                int i = sbApos;
                int rs = 0;
                int re = 0;
                for (int apos = this._ptr[k]; apos < blen; apos += 2) {
                    rs = re + this._data[apos];
                    re = rs + this._data[apos + 1];
                    while (i < sbAlen && sbAix[i] < rs) {
                        ++i;
                    }
                    while (i < sbAlen && sbAix[i] < re) {
                        int n = offR;
                        preAgg[n] = preAgg[n] + sbAval[i];
                        ++i;
                    }
                }
            }
        }
    }

    @Override
    protected void preAggregateThatDDCStructure(ColGroupDDC that, Dictionary ret) {
        that._data.preAggregateRLE_DDC(this._ptr, this._data, that._dict, ret, that._colIndexes.size());
    }

    @Override
    protected void preAggregateThatSDCZerosStructure(ColGroupSDCZeros that, Dictionary ret) {
        int finalOff = that._indexes.getOffsetToLast();
        double[] v = ret.getValues();
        int nv = this.getNumValues();
        int nCol = that._colIndexes.size();
        for (int k = 0; k < nv; ++k) {
            AIterator itThat = that._indexes.getIterator();
            int blen = this._ptr[k + 1];
            int rs = 0;
            int re = 0;
            block1: for (int apos = this._ptr[k]; apos < blen; apos += 2) {
                rs = re + this._data[apos];
                re = rs + this._data[apos + 1];
                if (itThat.value() >= re || rs == re || rs > finalOff) continue;
                while (itThat.value() < rs && itThat.value() != finalOff) {
                    itThat.next();
                }
                int rix = itThat.value();
                while (rix < re) {
                    that._dict.addToEntry(v, that._data.getIndex(itThat.getDataIndex()), k, nCol);
                    if (itThat.value() == finalOff) continue block1;
                    itThat.next();
                    rix = itThat.value();
                }
            }
        }
    }

    @Override
    protected void preAggregateThatSDCSingleZerosStructure(ColGroupSDCSingleZeros that, Dictionary ret) {
        int finalOff = that._indexes.getOffsetToLast();
        double[] v = ret.getValues();
        int nv = this.getNumValues();
        int nCol = that._colIndexes.size();
        for (int k = 0; k < nv; ++k) {
            AOffsetIterator itThat = that._indexes.getOffsetIterator();
            int blen = this._ptr[k + 1];
            int rs = 0;
            int re = 0;
            block1: for (int apos = this._ptr[k]; apos < blen; apos += 2) {
                rs = re + this._data[apos];
                re = rs + this._data[apos + 1];
                if (itThat.value() >= re || rs == re || rs > finalOff) continue;
                while (itThat.value() < rs && itThat.value() != finalOff) {
                    itThat.next();
                }
                int rix = Math.max(rs, itThat.value());
                while (rix < re) {
                    that._dict.addToEntry(v, 0, k, nCol);
                    if (itThat.value() == finalOff) continue block1;
                    itThat.next();
                    rix = itThat.value();
                }
            }
        }
    }

    @Override
    public boolean sameIndexStructure(AColGroupCompressed that) {
        if (that.getCompType() == this.getCompType()) {
            ColGroupRLE rle = (ColGroupRLE)that;
            return rle._ptr == this._ptr && rle._data == this._data;
        }
        return false;
    }

    @Override
    protected int numRowsToMultiply() {
        return this._data.length / 2;
    }

    @Override
    protected void preAggregateThatRLEStructure(ColGroupRLE that, Dictionary ret) {
        double[] v = ret.getValues();
        int nv = this.getNumValues();
        int tnv = that.getNumValues();
        int nCol = that._colIndexes.size();
        int[] skip = new int[tnv];
        int[] skipV = new int[tnv];
        for (int k = 0; k < nv; ++k) {
            for (int tk = 0; tk < tnv; ++tk) {
                skip[tk] = that._ptr[tk];
                skipV[tk] = 0;
            }
            int blen = this._ptr[k + 1];
            int rs = 0;
            int re = 0;
            for (int apos = this._ptr[k]; apos < blen; apos += 2) {
                rs = re + this._data[apos];
                re = rs + this._data[apos + 1];
                block3: for (int tk = 0; tk < tnv; ++tk) {
                    int tblen = that._ptr[tk + 1];
                    int trs = 0;
                    int tre = skipV[tk];
                    for (int tapos = skip[tk]; tapos < tblen; tapos += 2) {
                        trs = tre + that._data[tapos];
                        if (trs == (tre = trs + that._data[tapos + 1]) || tre <= rs) {
                            skip[tk] = tapos;
                            skipV[tk] = trs - that._data[tapos];
                            continue;
                        }
                        if (trs >= re) continue block3;
                        if (!(trs >= rs && trs < re || tre <= re && tre > rs) && (trs > rs || tre <= re)) continue;
                        int crs = Math.max(rs, trs);
                        int cre = Math.min(re, tre);
                        that._dict.addToEntry(v, tk, k, nCol, cre - crs);
                    }
                }
            }
        }
    }

    @Override
    public double getCost(ComputationCostEstimator e, int nRows) {
        int nVals = this.getNumValues();
        int nCols = this.getNumCols();
        return e.getCost(this._numRows, this._data.length, nCols, nVals, this._dict.getSparsity());
    }

    public static ColGroupRLE read(DataInput in, int nRows) throws IOException {
        IColIndex cols = ColIndexFactory.read(in);
        IDictionary dict = DictionaryFactory.read(in);
        int[] ptr = ColGroupRLE.readPointers(in);
        char[] data = ColGroupRLE.readData(in);
        boolean zeros = in.readBoolean();
        return new ColGroupRLE(cols, nRows, zeros, dict, data, ptr, null);
    }

    @Override
    public AColGroup sliceRows(int rl, int ru) {
        throw new NotImplementedException("Slice rows for RLE is not implemented yet!");
    }

    @Override
    protected AColGroup copyAndSet(IColIndex colIndexes, IDictionary newDictionary) {
        return ColGroupRLE.create(colIndexes, this._numRows, this._zeros, newDictionary, this._data, this._ptr, this.getCachedCounts());
    }

    @Override
    public AColGroup append(AColGroup g) {
        return null;
    }

    @Override
    public AColGroup appendNInternal(AColGroup[] g, int blen, int rlen) {
        throw new NotImplementedException();
    }

    @Override
    public ICLAScheme getCompressionScheme() {
        return RLEScheme.create(this);
    }

    @Override
    public AColGroup recompress() {
        return this;
    }

    @Override
    public CompressedSizeInfoColGroup getCompressionInfo(int nRow) {
        throw new NotImplementedException();
    }

    @Override
    protected AColGroup fixColIndexes(IColIndex newColIndex, int[] reordering) {
        throw new NotImplementedException();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.toString());
        sb.append(String.format("\n%14s len(%d) Zeros:%b", "Data:", this._data.length, this._zeros));
        sb.append("\nData Simplified Delta: {{");
        sb.append(this.pair(this._data, 0));
        int p = 1;
        for (int i = 2; i < this._data.length; i += 2) {
            if (this._ptr[p] == i) {
                if (this._ptr[p] + 2 == this._ptr[p + 1]) {
                    sb.append("}, {" + this.pair(this._data, i));
                } else {
                    sb.append("},\n {" + this.pair(this._data, i));
                }
                ++p;
                continue;
            }
            sb.append(", " + this.pair(this._data, i));
        }
        sb.append("}}");
        sb.append("\nData Simplified RunningSum{{");
        int sum = 0;
        sb.append(this.pair(this._data, 0, sum));
        p = 1;
        sum += this._data[0] + this._data[1];
        for (int i = 2; i < this._data.length; i += 2) {
            if (this._ptr[p] == i) {
                sum = 0;
                sb.append("},\n {" + this.pair(this._data, i, sum));
                sum += this._data[i] + this._data[i + 1];
                ++p;
                continue;
            }
            sb.append(", " + this.pair(this._data, i, sum));
            sum += this._data[i] + this._data[i + 1];
        }
        sb.append("}}");
        sb.append("\nActual: ");
        for (char c : this._data) {
            sb.append(c + ", ");
        }
        return sb.toString();
    }

    public static char[] genRLEBitmap(int[] offsets, int len) {
        int CM2 = 65535;
        int CMi = 65535;
        boolean c0 = false;
        ArrayList<Character> buf = new ArrayList<Character>();
        int lastRunEnd = 0;
        int curRunLen = 0;
        int firstOff = offsets[0];
        while (firstOff > 65535) {
            buf.add(Character.valueOf('\uffff'));
            buf.add(Character.valueOf('\u0000'));
            firstOff -= 65535;
            lastRunEnd += 65535;
        }
        int curRunOff = firstOff;
        curRunLen = 1;
        for (int i = 1; i < len; ++i) {
            int absOffset = offsets[i];
            int curRunEnd = lastRunEnd + curRunOff + curRunLen;
            if (absOffset > curRunEnd || curRunLen >= 65535) {
                buf.add(Character.valueOf((char)curRunOff));
                buf.add(Character.valueOf((char)curRunLen));
                lastRunEnd = curRunEnd;
                for (curRunOff = absOffset - lastRunEnd; curRunOff > 65535; curRunOff -= 65535) {
                    buf.add(Character.valueOf('\uffff'));
                    buf.add(Character.valueOf('\u0000'));
                    lastRunEnd += 65535;
                }
                curRunLen = 1;
                continue;
            }
            ++curRunLen;
        }
        buf.add(Character.valueOf((char)curRunOff));
        buf.add(Character.valueOf((char)curRunLen));
        char[] ret = new char[buf.size()];
        for (int i = 0; i < buf.size(); ++i) {
            ret[i] = ((Character)buf.get(i)).charValue();
        }
        return ret;
    }

    private class skipPair {
        protected final int apos;
        protected final int astart;

        protected skipPair(int apos, int astart) {
            this.apos = apos;
            this.astart = astart;
        }
    }
}

