/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.colgroup.scheme;

import org.apache.sysds.runtime.compress.colgroup.AColGroup;
import org.apache.sysds.runtime.compress.colgroup.ASDC;
import org.apache.sysds.runtime.compress.colgroup.ASDCZero;
import org.apache.sysds.runtime.compress.colgroup.ColGroupConst;
import org.apache.sysds.runtime.compress.colgroup.ColGroupEmpty;
import org.apache.sysds.runtime.compress.colgroup.ColGroupSDC;
import org.apache.sysds.runtime.compress.colgroup.dictionary.DictionaryFactory;
import org.apache.sysds.runtime.compress.colgroup.dictionary.MatrixBlockDictionary;
import org.apache.sysds.runtime.compress.colgroup.indexes.ColIndexFactory;
import org.apache.sysds.runtime.compress.colgroup.indexes.IColIndex;
import org.apache.sysds.runtime.compress.colgroup.mapping.AMapToData;
import org.apache.sysds.runtime.compress.colgroup.mapping.MapToFactory;
import org.apache.sysds.runtime.compress.colgroup.offset.AOffset;
import org.apache.sysds.runtime.compress.colgroup.offset.OffsetFactory;
import org.apache.sysds.runtime.compress.colgroup.scheme.ICLAScheme;
import org.apache.sysds.runtime.compress.colgroup.scheme.SDCScheme;
import org.apache.sysds.runtime.compress.readers.ReaderColumnSelection;
import org.apache.sysds.runtime.compress.utils.ACount;
import org.apache.sysds.runtime.compress.utils.DblArray;
import org.apache.sysds.runtime.compress.utils.DblArrayCountHashMap;
import org.apache.sysds.runtime.compress.utils.IntArrayList;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;

public class SDCSchemeMC
extends SDCScheme {
    private final DblArray emptyRow;
    private final DblArray def;
    private final DblArrayCountHashMap map;

    public SDCSchemeMC(IColIndex cols, DblArrayCountHashMap map, DblArray def) {
        super(cols);
        this.map = map;
        this.def = def;
        this.emptyRow = new DblArray(new double[cols.size()]);
    }

    protected SDCSchemeMC(ASDC g) {
        super(g.getColIndices());
        this.lastDict = g.getDictionary();
        MatrixBlockDictionary mbd = this.lastDict.getMBDict(this.cols.size());
        MatrixBlock mbDict = mbd != null ? mbd.getMatrixBlock() : new MatrixBlock(1, this.cols.size(), 0.0);
        int dictRows = mbDict.getNumRows();
        int dictCols = mbDict.getNumColumns();
        this.map = new DblArrayCountHashMap(dictRows * 2);
        this.emptyRow = new DblArray(new double[dictCols]);
        if (mbDict.isEmpty()) {
            this.map.increment(this.emptyRow);
        } else {
            ReaderColumnSelection reader = ReaderColumnSelection.createReader(mbDict, ColIndexFactory.create(dictCols), false, 0, dictRows);
            DblArray d = null;
            while ((d = reader.nextRow()) != null) {
                this.map.increment(d);
            }
        }
        this.def = new DblArray(g.getCommon());
    }

    protected SDCSchemeMC(ASDCZero g) {
        super(g.getColIndices());
        this.lastDict = g.getDictionary();
        MatrixBlock mbDict = this.lastDict.getMBDict(this.cols.size()).getMatrixBlock();
        int dictRows = mbDict.getNumRows();
        int dictCols = mbDict.getNumColumns();
        this.map = new DblArrayCountHashMap(dictRows * 2);
        ReaderColumnSelection r = ReaderColumnSelection.createReader(mbDict, ColIndexFactory.create(dictCols), false, 0, dictRows);
        DblArray d = null;
        while ((d = r.nextRow()) != null) {
            this.map.increment(d);
        }
        this.emptyRow = new DblArray(new double[dictCols]);
        this.def = new DblArray(new double[dictCols]);
    }

    @Override
    protected AColGroup encodeV(MatrixBlock data, IColIndex columns) {
        if (data.isEmpty()) {
            return new ColGroupEmpty(columns);
        }
        int nRow = data.getNumRows();
        IntArrayList offs = new IntArrayList();
        ReaderColumnSelection reader = ReaderColumnSelection.createReader(data, this.cols, false, 0, nRow);
        AMapToData d = this.encode(data, reader, offs, this.cols, nRow);
        return this.finalizeEncode(data, offs, d, columns, nRow);
    }

    private AColGroup finalizeEncode(MatrixBlock data, IntArrayList offs, AMapToData d, IColIndex columns, int nRow) {
        if (this.lastDict == null || this.lastDict.getNumberOfValues(columns.size()) != this.map.size()) {
            this.lastDict = DictionaryFactory.create(this.map, columns.size(), false, data.getSparsity());
        }
        if (offs.size() == 0) {
            return ColGroupConst.create(columns, this.def.getData());
        }
        AOffset off = OffsetFactory.createOffset(offs);
        return ColGroupSDC.create(columns, nRow, this.lastDict, this.def.getData(), off, d, null);
    }

    private AMapToData encode(MatrixBlock data, ReaderColumnSelection reader, IntArrayList off, IColIndex cols, int nRow) {
        DblArray cellVals;
        ACount<DblArray> emptyIdx = this.map.getC(this.emptyRow);
        IntArrayList dt = new IntArrayList();
        int r = 0;
        while ((cellVals = reader.nextRow()) != null) {
            int row = reader.getCurrentRowIndex();
            if (row != r) {
                if (emptyIdx != null) {
                    while (r < row) {
                        off.appendValue(r++);
                        dt.appendValue(emptyIdx.id);
                    }
                } else {
                    r = row;
                }
            }
            if (!cellVals.equals(this.def)) {
                int id = this.map.getId(cellVals);
                if (id < 0) continue;
                off.appendValue(row);
                dt.appendValue(id);
                ++r;
                continue;
            }
            ++r;
        }
        if (emptyIdx != null) {
            while (r < nRow) {
                off.appendValue(r++);
                dt.appendValue(emptyIdx.id);
            }
        }
        AMapToData d = MapToFactory.create(off.size(), this.map.size());
        for (int i = 0; i < off.size(); ++i) {
            d.set(i, dt.get(i));
        }
        return d;
    }

    @Override
    protected ICLAScheme updateV(MatrixBlock data, IColIndex columns) {
        if (data.isEmpty()) {
            if (!this.def.equals(this.emptyRow)) {
                this.map.increment(this.emptyRow, data.getNumRows());
            }
            return this;
        }
        int nRow = data.getNumRows();
        ReaderColumnSelection reader = ReaderColumnSelection.createReader(data, this.cols, false, 0, nRow);
        return this.update(data, reader, columns, nRow);
    }

    private ICLAScheme update(MatrixBlock data, ReaderColumnSelection reader, IColIndex columns, int nRow) {
        DblArray cellVals;
        boolean defIsEmpty = this.emptyRow.equals(this.def);
        int r = 0;
        while ((cellVals = reader.nextRow()) != null) {
            int row = reader.getCurrentRowIndex();
            if (row != r) {
                if (!defIsEmpty) {
                    this.map.increment(this.emptyRow, row - r);
                }
                r = row;
            }
            if (cellVals.equals(this.def)) continue;
            this.map.increment(cellVals);
        }
        if (!defIsEmpty && r < nRow) {
            this.map.increment(this.emptyRow, nRow - r);
        }
        return this;
    }

    @Override
    protected Object getDef() {
        return this.def;
    }

    @Override
    protected Object getMap() {
        return this.map;
    }

    @Override
    protected AColGroup encodeVT(MatrixBlock data, IColIndex columns) {
        if (data.isEmpty()) {
            return new ColGroupEmpty(columns);
        }
        int nRow = data.getNumColumns();
        IntArrayList offs = new IntArrayList();
        ReaderColumnSelection reader = ReaderColumnSelection.createReader(data, this.cols, true, 0, nRow);
        AMapToData d = this.encode(data, reader, offs, this.cols, nRow);
        return this.finalizeEncode(data, offs, d, columns, nRow);
    }

    @Override
    protected ICLAScheme updateVT(MatrixBlock data, IColIndex columns) {
        if (data.isEmpty()) {
            if (!this.def.equals(this.emptyRow)) {
                this.map.increment(this.emptyRow, data.getNumColumns());
            }
            return this;
        }
        int nRow = data.getNumColumns();
        ReaderColumnSelection reader = ReaderColumnSelection.createReader(data, this.cols, true, 0, nRow);
        return this.update(data, reader, columns, nRow);
    }

    @Override
    public SDCSchemeMC clone() {
        return new SDCSchemeMC(this.cols, this.map.clone(), this.def);
    }
}

