/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.matrix.operators;

import org.apache.sysds.common.Types;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.functionobjects.IndexFunction;
import org.apache.sysds.runtime.functionobjects.Plus;
import org.apache.sysds.runtime.instructions.cp.AggregateUnaryCPInstruction;
import org.apache.sysds.runtime.matrix.operators.AggregateOperator;
import org.apache.sysds.runtime.matrix.operators.CountDistinctOperatorTypes;
import org.apache.sysds.runtime.matrix.operators.UnarySketchOperator;
import org.apache.sysds.utils.Hash;

public class CountDistinctOperator
extends UnarySketchOperator {
    private static final long serialVersionUID = 7615123453265129670L;
    private final CountDistinctOperatorTypes operatorType;
    private final Hash.HashType hashType;

    public CountDistinctOperator(AggregateUnaryCPInstruction.AUType opType, Types.Direction direction, IndexFunction indexFunction) {
        super(new AggregateOperator(0.0, Plus.getPlusFnObject()), indexFunction, direction, 1);
        switch (opType) {
            case COUNT_DISTINCT: {
                this.operatorType = CountDistinctOperatorTypes.COUNT;
                break;
            }
            case COUNT_DISTINCT_APPROX: {
                this.operatorType = CountDistinctOperatorTypes.KMV;
                break;
            }
            default: {
                throw new DMLRuntimeException(opType + " not supported for CountDistinct Operator");
            }
        }
        this.hashType = Hash.HashType.LinearHash;
    }

    public CountDistinctOperator(CountDistinctOperatorTypes operatorType, Types.Direction direction, IndexFunction indexFunction, Hash.HashType hashType) {
        super(new AggregateOperator(0.0, Plus.getPlusFnObject()), indexFunction, direction, 1);
        this.operatorType = operatorType;
        this.hashType = hashType;
    }

    public CountDistinctOperatorTypes getOperatorType() {
        return this.operatorType;
    }

    public Hash.HashType getHashType() {
        return this.hashType;
    }
}

