/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.lops;

import java.util.HashMap;
import java.util.Map;
import org.apache.sysds.common.Opcodes;
import org.apache.sysds.common.Types;
import org.apache.sysds.lops.Lop;
import org.apache.sysds.lops.LopsException;
import org.apache.sysds.runtime.instructions.InstructionUtils;

public class ParameterizedBuiltin
extends Lop {
    private Types.ParamBuiltinOp _operation;
    private HashMap<String, Lop> _inputParams;
    private boolean _bRmEmptyBC;
    private int _numThreads = 1;

    public ParameterizedBuiltin(HashMap<String, Lop> paramLops, Types.ParamBuiltinOp op, Types.DataType dt, Types.ValueType vt, Types.ExecType et) {
        this(paramLops, op, dt, vt, et, 1);
    }

    public ParameterizedBuiltin(HashMap<String, Lop> paramLops, Types.ParamBuiltinOp op, Types.DataType dt, Types.ValueType vt, Types.ExecType et, int k) {
        super(Lop.Type.ParameterizedBuiltin, dt, vt);
        this._operation = op;
        for (Lop lop : paramLops.values()) {
            this.addInput(lop);
            lop.addOutput(this);
        }
        this._inputParams = paramLops;
        this._numThreads = k;
        this.lps.setProperties(this.inputs, et);
    }

    public ParameterizedBuiltin(HashMap<String, Lop> paramLops, Types.ParamBuiltinOp op, Types.DataType dt, Types.ValueType vt, Types.ExecType et, boolean bRmEmptyBC) {
        this(paramLops, op, dt, vt, et);
        this._bRmEmptyBC = bRmEmptyBC;
    }

    public Types.ParamBuiltinOp getOp() {
        return this._operation;
    }

    public void setNumThreads(int k) {
        this._numThreads = k;
    }

    public int getInputIndex(String name) {
        Lop n = this._inputParams.get(name);
        for (int i = 0; i < this.getInputs().size(); ++i) {
            if (this.getInputs().get(i) != n) continue;
            return i;
        }
        return -1;
    }

    public Lop getNamedInput(String name) {
        return this._inputParams.get(name);
    }

    @Override
    public String getInstructions(String output) {
        StringBuilder sb = InstructionUtils.getStringBuilder();
        sb.append((Object)this.getExecType());
        sb.append("\u00b0");
        switch (this._operation) {
            case CDF: 
            case INVCDF: {
                sb.append((Object)(this._operation == Types.ParamBuiltinOp.CDF ? Opcodes.CDF : Opcodes.INVCDF));
                sb.append("\u00b0");
                for (String s : this._inputParams.keySet()) {
                    sb.append(s);
                    sb.append("=");
                    Lop iLop = this._inputParams.get(s);
                    sb.append(iLop.prepScalarLabel());
                    sb.append("\u00b0");
                }
                break;
            }
            case RMEMPTY: {
                sb.append((Object)Opcodes.RMEMPTY);
                sb.append("\u00b0");
                for (String s : this._inputParams.keySet()) {
                    sb.append(s);
                    sb.append("=");
                    Lop iLop = this._inputParams.get(s);
                    if (s.equals("target") || s.equals("select") || this.getExecType() == Types.ExecType.SPARK) {
                        sb.append(iLop.getOutputParameters().getLabel());
                    } else {
                        sb.append(iLop.prepScalarLabel());
                    }
                    sb.append("\u00b0");
                }
                break;
            }
            case LOWER_TRI: {
                sb.append((Object)Opcodes.LOWERTRI);
                sb.append("\u00b0");
                ParameterizedBuiltin.compileGenericParamMap(sb, this._inputParams);
                break;
            }
            case UPPER_TRI: {
                sb.append((Object)Opcodes.UPPERTRI);
                sb.append("\u00b0");
                ParameterizedBuiltin.compileGenericParamMap(sb, this._inputParams);
                break;
            }
            case REXPAND: {
                sb.append((Object)Opcodes.REXPAND);
                sb.append("\u00b0");
                for (String s : this._inputParams.keySet()) {
                    sb.append(s);
                    sb.append("=");
                    Lop iLop = this._inputParams.get(s);
                    if (s.equals("target") || this.getExecType() == Types.ExecType.SPARK) {
                        sb.append(iLop.getOutputParameters().getLabel());
                    } else {
                        sb.append(iLop.prepScalarLabel());
                    }
                    sb.append("\u00b0");
                }
                break;
            }
            case CONTAINS: 
            case REPLACE: 
            case TOKENIZE: 
            case TRANSFORMAPPLY: 
            case TRANSFORMDECODE: 
            case TRANSFORMCOLMAP: 
            case TRANSFORMMETA: 
            case PARAMSERV: {
                sb.append(this._operation.name().toLowerCase());
                sb.append("\u00b0");
                ParameterizedBuiltin.compileGenericParamMap(sb, this._inputParams);
                break;
            }
            case AUTODIFF: {
                sb.append((Object)Opcodes.AUTODIFF);
                sb.append("\u00b0");
                ParameterizedBuiltin.compileGenericParamMap(sb, this._inputParams);
                break;
            }
            case LIST: {
                sb.append((Object)Opcodes.NVLIST);
                sb.append("\u00b0");
                ParameterizedBuiltin.compileGenericParamMap(sb, this._inputParams);
                break;
            }
            case TOSTRING: {
                sb.append((Object)Opcodes.TOSTRING);
                sb.append("\u00b0");
                ParameterizedBuiltin.compileGenericParamMap(sb, this._inputParams);
                break;
            }
            default: {
                throw new LopsException(this.printErrorLocation() + "In ParameterizedBuiltin Lop, Unknown operation: " + this._operation);
            }
        }
        if (this._operation == Types.ParamBuiltinOp.RMEMPTY) {
            sb.append("bRmEmptyBC");
            sb.append("=");
            sb.append(this._bRmEmptyBC);
            sb.append("\u00b0");
        }
        if (this.getExecType() == Types.ExecType.CP && (this._operation == Types.ParamBuiltinOp.REXPAND || this._operation == Types.ParamBuiltinOp.CONTAINS)) {
            sb.append("k");
            sb.append("=");
            sb.append(this._numThreads);
            sb.append("\u00b0");
        }
        sb.append(this.prepOutputOperand(output));
        return sb.toString();
    }

    @Override
    public String toString() {
        StringBuilder sb = InstructionUtils.getStringBuilder();
        sb.append(this._operation.toString());
        if (!this.getInputs().isEmpty()) {
            sb.append("(");
        }
        for (Lop cur : this.getInputs()) {
            sb.append(cur.toString());
        }
        if (!this.getInputs().isEmpty()) {
            sb.append(") ");
        }
        sb.append(" ; num_rows=" + this.getOutputParameters().getNumRows());
        sb.append(" ; num_cols=" + this.getOutputParameters().getNumCols());
        sb.append(" ; format=" + this.getOutputParameters().getFormat());
        sb.append(" ; blocked=" + this.getOutputParameters().isBlocked());
        return sb.toString();
    }

    private static void compileGenericParamMap(StringBuilder sb, HashMap<String, Lop> params) {
        for (Map.Entry<String, Lop> e : params.entrySet()) {
            sb.append(e.getKey());
            sb.append("=");
            if (e.getValue().getDataType() != Types.DataType.SCALAR) {
                sb.append(e.getValue().getOutputParameters().getLabel());
            } else {
                sb.append(e.getValue().prepScalarLabel());
            }
            sb.append("\u00b0");
        }
    }
}

