/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.ioc.internal.services;

import java.util.List;
import org.apache.tapestry5.ioc.AnnotationProvider;
import org.apache.tapestry5.ioc.Invokable;
import org.apache.tapestry5.ioc.ObjectLocator;
import org.apache.tapestry5.ioc.ObjectProvider;
import org.apache.tapestry5.ioc.OperationTracker;
import org.apache.tapestry5.ioc.annotations.PreventServiceDecoration;
import org.apache.tapestry5.ioc.internal.services.StaticObjectProvider;
import org.apache.tapestry5.ioc.internal.util.CollectionFactory;
import org.apache.tapestry5.ioc.services.MasterObjectProvider;
import org.apache.tapestry5.plastic.PlasticUtils;

@PreventServiceDecoration
public class MasterObjectProviderImpl
implements MasterObjectProvider {
    private final List<ObjectProvider> configuration;
    private final OperationTracker tracker;

    public MasterObjectProviderImpl(List<ObjectProvider> configuration, OperationTracker tracker) {
        this.configuration = CollectionFactory.newList(configuration);
        this.tracker = tracker;
        this.configuration.add(0, new StaticObjectProvider<OperationTracker>(OperationTracker.class, tracker));
    }

    @Override
    public <T> T provide(final Class<T> objectType, final AnnotationProvider annotationProvider, final ObjectLocator locator, final boolean required) {
        return this.tracker.invoke(String.format("Resolving object of type %s using MasterObjectProvider", PlasticUtils.toTypeName(objectType)), new Invokable<T>(){

            @Override
            public T invoke() {
                for (ObjectProvider provider : MasterObjectProviderImpl.this.configuration) {
                    Object result = provider.provide(objectType, annotationProvider, locator);
                    if (result == null) continue;
                    return result;
                }
                if (required) {
                    return locator.getService(objectType);
                }
                return null;
            }
        });
    }
}

