/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.corelib.base;

import java.util.Map;
import org.apache.tapestry5.ClientElement;
import org.apache.tapestry5.ComponentResources;
import org.apache.tapestry5.Link;
import org.apache.tapestry5.MarkupWriter;
import org.apache.tapestry5.annotations.Parameter;
import org.apache.tapestry5.annotations.SetupRender;
import org.apache.tapestry5.annotations.SupportsInformalParameters;
import org.apache.tapestry5.dom.Element;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.services.javascript.JavaScriptSupport;

@SupportsInformalParameters
public abstract class AbstractLink
implements ClientElement {
    @Parameter(defaultPrefix="literal")
    private String anchor;
    @Parameter(value="false")
    private boolean disabled;
    @Parameter(allowNull=false)
    private Map<String, ?> parameters;
    @Inject
    protected ComponentResources resources;
    @Inject
    private JavaScriptSupport jsSupport;
    private Link link;
    private Element element;
    private String clientId;

    private String buildHref(Link link) {
        String href = link.toURI();
        if (this.anchor == null) {
            return href;
        }
        return href + "#" + this.anchor;
    }

    @SetupRender
    void resetElementAndClientId() {
        this.element = null;
        this.clientId = null;
    }

    protected final void writeLink(MarkupWriter writer, Link link, Object ... namesAndValues) {
        this.addParameters(link);
        this.element = writer.element("a", "href", this.buildHref(link));
        writer.attributes(namesAndValues);
        this.resources.renderInformalParameters(writer);
        this.link = link;
    }

    protected final void addParameters(Link link) {
        if (!this.resources.isBound("parameters")) {
            return;
        }
        for (Map.Entry<String, ?> entry : this.parameters.entrySet()) {
            String name = entry.getKey();
            link.removeParameter(name);
            link.addParameterValue(name, entry.getValue());
        }
    }

    public Link getLink() {
        return this.link;
    }

    @Override
    public final String getClientId() {
        if (this.clientId == null) {
            if (this.element == null) {
                throw new IllegalStateException(String.format("Client id for %s is not available as it did not render yet (or was disabled).", this.resources.getCompleteId()));
            }
            this.clientId = this.jsSupport.allocateClientId(this.resources);
            this.element.forceAttributes("id", this.clientId);
        }
        return this.clientId;
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    final void inject(String anchor, ComponentResources resources) {
        this.anchor = anchor;
        this.resources = resources;
    }
}

